/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum AssuredReplicationLocalLevel {
    NONE(0),
    RECEIVED_ANY_SERVER(1),
    PROCESSED_ALL_SERVERS(2);

    private final int intValue;

    private AssuredReplicationLocalLevel(int intValue) {
        this.intValue = intValue;
    }

    public int intValue() {
        return this.intValue;
    }

    @Nullable
    public static AssuredReplicationLocalLevel valueOf(int intValue) {
        for (AssuredReplicationLocalLevel l : AssuredReplicationLocalLevel.values()) {
            if (l.intValue != intValue) continue;
            return l;
        }
        return null;
    }

    @Nullable
    public static AssuredReplicationLocalLevel forName(@NotNull String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "none": {
                return NONE;
            }
            case "receivedanyserver": 
            case "received-any-server": 
            case "received_any_server": {
                return RECEIVED_ANY_SERVER;
            }
            case "processedallservers": 
            case "processed-all-servers": 
            case "processed_all_servers": {
                return PROCESSED_ALL_SERVERS;
            }
        }
        return null;
    }

    @NotNull
    public static AssuredReplicationLocalLevel getLessStrict(@NotNull AssuredReplicationLocalLevel l1, @NotNull AssuredReplicationLocalLevel l2) {
        if (l1.intValue <= l2.intValue) {
            return l1;
        }
        return l2;
    }

    @NotNull
    public static AssuredReplicationLocalLevel getMoreStrict(@NotNull AssuredReplicationLocalLevel l1, @NotNull AssuredReplicationLocalLevel l2) {
        if (l1.intValue >= l2.intValue) {
            return l1;
        }
        return l2;
    }
}

