/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class DeliverSingleUseTokenExtendedResult
extends ExtendedResult {
    @NotNull
    public static final String DELIVER_SINGLE_USE_TOKEN_RESULT_OID = "1.3.6.1.4.1.30221.2.6.50";
    private static final byte RECIPIENT_ID_BER_TYPE = -128;
    private static final byte DELIVERY_MESSAGE_BER_TYPE = -127;
    private static final long serialVersionUID = 8874679715973086041L;
    @Nullable
    private final String deliveryMechanism;
    @Nullable
    private final String deliveryMessage;
    @Nullable
    private final String recipientID;

    public DeliverSingleUseTokenExtendedResult(int messageID, @NotNull ResultCode resultCode, @Nullable String diagnosticMessage, @Nullable String matchedDN, @Nullable String[] referralURLs, @Nullable String deliveryMechanism, @Nullable String recipientID, @Nullable String deliveryMessage, Control ... responseControls) {
        super(messageID, resultCode, diagnosticMessage, matchedDN, referralURLs, deliveryMechanism == null ? null : DELIVER_SINGLE_USE_TOKEN_RESULT_OID, DeliverSingleUseTokenExtendedResult.encodeValue(deliveryMechanism, recipientID, deliveryMessage), responseControls);
        this.deliveryMechanism = deliveryMechanism;
        this.recipientID = recipientID;
        this.deliveryMessage = deliveryMessage;
    }

    public DeliverSingleUseTokenExtendedResult(@NotNull ExtendedResult result) throws LDAPException {
        super(result);
        ASN1OctetString value = result.getValue();
        if (value == null) {
            this.deliveryMechanism = null;
            this.recipientID = null;
            this.deliveryMessage = null;
            return;
        }
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(value.getValue()).elements();
            this.deliveryMechanism = ASN1OctetString.decodeAsOctetString(elements[0]).stringValue();
            String id = null;
            String msg = null;
            block7: for (int i = 1; i < elements.length; ++i) {
                switch (elements[i].getType()) {
                    case -128: {
                        id = ASN1OctetString.decodeAsOctetString(elements[i]).stringValue();
                        continue block7;
                    }
                    case -127: {
                        msg = ASN1OctetString.decodeAsOctetString(elements[i]).stringValue();
                        continue block7;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_DELIVER_SINGLE_USE_TOKEN_RESULT_UNEXPECTED_TYPE.get(StaticUtils.toHex(elements[i].getType())));
                    }
                }
            }
            this.recipientID = id;
            this.deliveryMessage = msg;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_DELIVER_SINGLE_USE_TOKEN_RESULT_ERROR_DECODING_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Nullable
    private static ASN1OctetString encodeValue(@Nullable String deliveryMechanism, @Nullable String recipientID, @Nullable String deliveryMessage) {
        if (deliveryMechanism == null) {
            Validator.ensureTrue(recipientID == null, "The delivery mechanism must be non-null if the recipient ID is non-null.");
            Validator.ensureTrue(deliveryMessage == null, "The delivery mechanism must be non-null if the delivery message is non-null.");
            return null;
        }
        ArrayList<ASN1OctetString> elements = new ArrayList<ASN1OctetString>(3);
        elements.add(new ASN1OctetString(deliveryMechanism));
        if (recipientID != null) {
            elements.add(new ASN1OctetString(-128, recipientID));
        }
        if (deliveryMessage != null) {
            elements.add(new ASN1OctetString(-127, deliveryMessage));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @Nullable
    public String getDeliveryMechanism() {
        return this.deliveryMechanism;
    }

    @Nullable
    public String getRecipientID() {
        return this.recipientID;
    }

    @Nullable
    public String getDeliveryMessage() {
        return this.deliveryMessage;
    }

    @Override
    @NotNull
    public String getExtendedResultName() {
        return ExtOpMessages.INFO_EXTENDED_RESULT_NAME_DELIVER_SINGLE_USE_TOKEN.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        Control[] responseControls;
        String[] referralURLs;
        String matchedDN;
        String diagnosticMessage;
        buffer.append("DeliverSingleUseTokenExtendedResult(resultCode=");
        buffer.append(this.getResultCode());
        int messageID = this.getMessageID();
        if (messageID >= 0) {
            buffer.append(", messageID=");
            buffer.append(messageID);
        }
        if (this.deliveryMechanism != null) {
            buffer.append(", deliveryMechanism='");
            buffer.append(this.deliveryMechanism);
            buffer.append('\'');
        }
        if (this.recipientID != null) {
            buffer.append(", recipientID='");
            buffer.append(this.recipientID);
            buffer.append('\'');
        }
        if (this.deliveryMessage != null) {
            buffer.append(", deliveryMessage='");
            buffer.append(this.deliveryMessage);
            buffer.append('\'');
        }
        if ((diagnosticMessage = this.getDiagnosticMessage()) != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(diagnosticMessage);
            buffer.append('\'');
        }
        if ((matchedDN = this.getMatchedDN()) != null) {
            buffer.append(", matchedDN='");
            buffer.append(matchedDN);
            buffer.append('\'');
        }
        if ((referralURLs = this.getReferralURLs()).length > 0) {
            buffer.append(", referralURLs={");
            for (int i = 0; i < referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'');
                buffer.append(referralURLs[i]);
                buffer.append('\'');
            }
            buffer.append('}');
        }
        if ((responseControls = this.getResponseControls()).length > 0) {
            buffer.append(", responseControls={");
            for (int i = 0; i < responseControls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(responseControls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

