/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldap.sdk.unboundidds.tools.SplitLDIFEntry;
import com.unboundid.ldap.sdk.unboundidds.tools.SplitLDIFTranslator;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolMessages;
import com.unboundid.ldif.LDIFException;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
final class SplitLDIFFilterTranslator
extends SplitLDIFTranslator {
    @Nullable
    private final ConcurrentHashMap<String, Set<String>> rdnCache;
    @NotNull
    private final Map<Filter, Set<String>> setFilters;
    @NotNull
    private final Map<Integer, Set<String>> setNames;
    @Nullable
    private final Schema schema;
    @NotNull
    private final Set<String> outsideSplitBaseSetNames;
    @NotNull
    private final Set<String> splitBaseEntrySetNames;

    SplitLDIFFilterTranslator(@NotNull DN splitBaseDN, @Nullable Schema schema, @NotNull LinkedHashSet<Filter> filters, boolean assumeFlatDIT, boolean addEntriesOutsideSplitToAllSets, boolean addEntriesOutsideSplitToDedicatedSet) {
        super(splitBaseDN);
        this.schema = schema;
        this.rdnCache = assumeFlatDIT ? null : new ConcurrentHashMap(StaticUtils.computeMapCapacity(100));
        int numSets = filters.size();
        this.outsideSplitBaseSetNames = new LinkedHashSet<String>(StaticUtils.computeMapCapacity(numSets + 1));
        this.splitBaseEntrySetNames = new LinkedHashSet<String>(StaticUtils.computeMapCapacity(numSets));
        if (addEntriesOutsideSplitToDedicatedSet) {
            this.outsideSplitBaseSetNames.add(".outside-split");
        }
        this.setFilters = new LinkedHashMap<Filter, Set<String>>(StaticUtils.computeMapCapacity(numSets));
        this.setNames = new LinkedHashMap<Integer, Set<String>>(StaticUtils.computeMapCapacity(numSets));
        int i = 0;
        for (Filter f : filters) {
            String setName = ".set" + (i + 1);
            Set<String> sets = Collections.singleton(setName);
            this.splitBaseEntrySetNames.add(setName);
            if (addEntriesOutsideSplitToAllSets) {
                this.outsideSplitBaseSetNames.add(setName);
            }
            this.setFilters.put(f, sets);
            this.setNames.put(i, sets);
            ++i;
        }
    }

    @Override
    @NotNull
    public SplitLDIFEntry translate(@NotNull Entry original, long firstLineNumber) throws LDIFException {
        DN dn;
        try {
            dn = original.getParsedDN();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            return this.createEntry(original, ToolMessages.ERR_SPLIT_LDIF_FILTER_TRANSLATOR_CANNOT_PARSE_DN.get(le.getMessage()), this.getErrorSetNames());
        }
        if (!dn.isDescendantOf(this.getSplitBaseDN(), true)) {
            return this.createEntry(original, this.outsideSplitBaseSetNames);
        }
        if (dn.equals(this.getSplitBaseDN())) {
            return this.createEntry(original, this.splitBaseEntrySetNames);
        }
        RDN[] rdns = dn.getRDNs();
        int targetRDNIndex = rdns.length - this.getSplitBaseRDNs().length - 1;
        String normalizedRDNString = rdns[targetRDNIndex].toNormalizedString();
        if (targetRDNIndex > 0) {
            if (this.rdnCache == null) {
                return this.createEntry(original, ToolMessages.ERR_SPLIT_LDIF_FILTER_TRANSLATOR_NON_FLAT_DIT.get(this.getSplitBaseDN().toString()), this.getErrorSetNames());
            }
            return this.createEntry(original, this.rdnCache.get(normalizedRDNString));
        }
        for (Map.Entry<Filter, Set<String>> e : this.setFilters.entrySet()) {
            Filter f = e.getKey();
            try {
                if (!f.matchesEntry(original, this.schema)) continue;
                Set<String> sets = e.getValue();
                if (this.rdnCache != null) {
                    this.rdnCache.put(normalizedRDNString, sets);
                }
                return this.createEntry(original, sets);
            }
            catch (Exception ex) {
                Debug.debugException(ex);
            }
        }
        SplitLDIFEntry e = this.createFromRDNHash(original, dn, this.setNames);
        if (this.rdnCache != null) {
            this.rdnCache.put(normalizedRDNString, e.getSets());
        }
        return e;
    }
}

