/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transform.transforms;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.transform.transforms.DestConfig;
import org.elasticsearch.client.transform.transforms.SettingsConfig;
import org.elasticsearch.client.transform.transforms.SourceConfig;
import org.elasticsearch.client.transform.transforms.SyncConfig;
import org.elasticsearch.client.transform.transforms.TransformConfig;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;

public class TransformConfigUpdate
implements ToXContentObject {
    public static final String NAME = "transform_config_update";
    private static final ConstructingObjectParser<TransformConfigUpdate, String> PARSER = new ConstructingObjectParser("transform_config_update", false, args -> {
        SourceConfig source = (SourceConfig)args[0];
        DestConfig dest = (DestConfig)args[1];
        TimeValue frequency = args[2] == null ? null : TimeValue.parseTimeValue((String)((String)args[2]), (String)TransformConfig.FREQUENCY.getPreferredName());
        SyncConfig syncConfig = (SyncConfig)args[3];
        String description = (String)args[4];
        SettingsConfig settings = (SettingsConfig)args[5];
        return new TransformConfigUpdate(source, dest, frequency, syncConfig, description, settings);
    });
    private final SourceConfig source;
    private final DestConfig dest;
    private final TimeValue frequency;
    private final SyncConfig syncConfig;
    private final String description;
    private final SettingsConfig settings;

    private static SyncConfig parseSyncConfig(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        SyncConfig syncConfig = (SyncConfig)parser.namedObject(SyncConfig.class, parser.currentName(), (Object)false);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        return syncConfig;
    }

    public TransformConfigUpdate(SourceConfig source, DestConfig dest, TimeValue frequency, SyncConfig syncConfig, String description, SettingsConfig settings) {
        this.source = source;
        this.dest = dest;
        this.frequency = frequency;
        this.syncConfig = syncConfig;
        this.description = description;
        this.settings = settings;
    }

    public SourceConfig getSource() {
        return this.source;
    }

    public DestConfig getDestination() {
        return this.dest;
    }

    public TimeValue getFrequency() {
        return this.frequency;
    }

    public SyncConfig getSyncConfig() {
        return this.syncConfig;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public SettingsConfig getSettings() {
        return this.settings;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.source != null) {
            builder.field(TransformConfig.SOURCE.getPreferredName(), (ToXContent)this.source);
        }
        if (this.dest != null) {
            builder.field(TransformConfig.DEST.getPreferredName(), (ToXContent)this.dest);
        }
        if (this.frequency != null) {
            builder.field(TransformConfig.FREQUENCY.getPreferredName(), this.frequency.getStringRep());
        }
        if (this.syncConfig != null) {
            builder.startObject(TransformConfig.SYNC.getPreferredName());
            builder.field(this.syncConfig.getName(), (ToXContent)this.syncConfig);
            builder.endObject();
        }
        if (this.description != null) {
            builder.field(TransformConfig.DESCRIPTION.getPreferredName(), this.description);
        }
        if (this.settings != null) {
            builder.field(TransformConfig.SETTINGS.getPreferredName(), (ToXContent)this.settings);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TransformConfigUpdate that = (TransformConfigUpdate)other;
        return Objects.equals(this.source, that.source) && Objects.equals(this.dest, that.dest) && Objects.equals(this.frequency, that.frequency) && Objects.equals(this.syncConfig, that.syncConfig) && Objects.equals(this.description, that.description) && Objects.equals(this.settings, that.settings);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.dest, this.frequency, this.syncConfig, this.description, this.settings);
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static TransformConfigUpdate fromXContent(XContentParser parser) {
        return (TransformConfigUpdate)PARSER.apply(parser, null);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> (SourceConfig)SourceConfig.PARSER.apply(p, null), TransformConfig.SOURCE);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> (DestConfig)DestConfig.PARSER.apply(p, null), TransformConfig.DEST);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), TransformConfig.FREQUENCY);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TransformConfigUpdate.parseSyncConfig(p), TransformConfig.SYNC);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), TransformConfig.DESCRIPTION);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> SettingsConfig.fromXContent(p), TransformConfig.SETTINGS);
    }

    public static class Builder {
        private SourceConfig source;
        private DestConfig dest;
        private TimeValue frequency;
        private SyncConfig syncConfig;
        private String description;
        private SettingsConfig settings;

        public Builder setSource(SourceConfig source) {
            this.source = source;
            return this;
        }

        public Builder setDest(DestConfig dest) {
            this.dest = dest;
            return this;
        }

        public Builder setFrequency(TimeValue frequency) {
            this.frequency = frequency;
            return this;
        }

        public Builder setSyncConfig(SyncConfig syncConfig) {
            this.syncConfig = syncConfig;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setSettings(SettingsConfig settings) {
            this.settings = settings;
            return this;
        }

        public TransformConfigUpdate build() {
            return new TransformConfigUpdate(this.source, this.dest, this.frequency, this.syncConfig, this.description, this.settings);
        }
    }
}

