/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.quota.search.elasticsearch.v7.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.mailbox.model.QuotaRatio;

public class QuotaRatioAsJson {
    private final String user;
    private final Optional<String> domain;
    private final QuotaRatio quotaRatio;

    public static Builder builder() {
        return new Builder();
    }

    private QuotaRatioAsJson(String user, Optional<String> domain, QuotaRatio quotaRatio) {
        this.user = user;
        this.domain = domain;
        this.quotaRatio = quotaRatio;
    }

    @JsonProperty(value="user")
    public String getUser() {
        return this.user;
    }

    @JsonProperty(value="domain")
    public Optional<String> getDomain() {
        return this.domain;
    }

    @JsonProperty(value="quotaRatio")
    public double getMaxQuotaRatio() {
        return this.quotaRatio.max();
    }

    public final boolean equals(Object o) {
        if (o instanceof QuotaRatioAsJson) {
            QuotaRatioAsJson that = (QuotaRatioAsJson)o;
            return Objects.equals(this.quotaRatio, that.quotaRatio) && Objects.equals(this.user, that.user) && Objects.equals(this.domain, that.domain);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.user, this.domain, this.quotaRatio);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("quotaRatio", (Object)this.quotaRatio).add("user", (Object)this.user).add("domain", this.domain).toString();
    }

    public static class Builder {
        private String user;
        private Optional<String> domain = Optional.empty();
        private QuotaRatio quotaRatio;

        private Builder() {
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder domain(Optional<String> domain) {
            this.domain = domain;
            return this;
        }

        public Builder quotaRatio(QuotaRatio quotaRatio) {
            this.quotaRatio = quotaRatio;
            return this;
        }

        public QuotaRatioAsJson build() {
            Preconditions.checkState((!Strings.isNullOrEmpty((String)this.user) ? 1 : 0) != 0, (Object)"'user' is mandatory");
            Preconditions.checkNotNull((Object)this.quotaRatio, (Object)"'quotaRatio' is mandatory");
            return new QuotaRatioAsJson(this.user, this.domain, this.quotaRatio);
        }
    }
}

