/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.io.Closeable;
import java.util.List;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.message.request.CopyRequest;
import org.apache.james.imap.processor.AbstractMessageRangeProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;

public class CopyProcessor
extends AbstractMessageRangeProcessor<CopyRequest> {
    public CopyProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(CopyRequest.class, next, mailboxManager, factory, metricFactory);
    }

    @Override
    protected String getOperationName() {
        return "Copy";
    }

    @Override
    protected List<MessageRange> process(MailboxPath targetMailbox, SelectedMailbox currentMailbox, MailboxSession mailboxSession, MessageRange messageSet) throws MailboxException {
        return this.getMailboxManager().copyMessages(messageSet, currentMailbox.getPath(), targetMailbox, mailboxSession);
    }

    @Override
    protected Closeable addContextToMDC(CopyRequest request) {
        return MDCBuilder.create().addToContext("action", "COPY").addToContext("targetMailbox", request.getMailboxName()).addToContext("uidEnabled", Boolean.toString(request.isUseUids())).addToContext("idSet", IdRange.toString(request.getIdSet())).build();
    }
}

