/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.mdc;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import org.apache.james.util.MDCStructuredLogger;
import org.apache.james.webadmin.mdc.RequestId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Filter;
import spark.Request;
import spark.Response;

public class LoggingResponseFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingResponseFilter.class);
    private static final String STATUS = "status";
    private static final String RESPONSE_BODY = "response-body";

    public void handle(Request request, Response response) {
        RequestId requestId = (RequestId)request.attribute("requestId");
        MDCStructuredLogger.forLogger((Logger)LOGGER).field("requestId", requestId.asString()).field("ip", request.ip()).field("endpoint", request.url()).field("method", request.requestMethod()).field("LOGIN", (String)request.attribute("LOGIN")).field("queryParameters", ImmutableSet.copyOf((Collection)request.queryParams()).toString()).field(STATUS, Integer.toString(response.status())).field(RESPONSE_BODY, response.body()).log(logger -> logger.info("WebAdmin response received"));
    }
}

