/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.es.v7.search;

import com.github.fge.lambdas.Throwing;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.james.backends.es.v7.ReactorElasticSearchClient;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.SearchHit;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;

public class ScrolledSearch {
    private static final TimeValue TIMEOUT = TimeValue.timeValueMinutes((long)1L);
    private final ReactorElasticSearchClient client;
    private final SearchRequest searchRequest;

    public ScrolledSearch(ReactorElasticSearchClient client, SearchRequest searchRequest) {
        this.client = client;
        this.searchRequest = searchRequest;
    }

    public Flux<SearchHit> searchHits() {
        return this.searchResponses().concatMap(searchResponse -> Flux.just((Object[])searchResponse.getHits().getHits()));
    }

    public Flux<SearchResponse> searchResponses() {
        return Flux.push(sink -> {
            AtomicReference scrollId = new AtomicReference(Optional.empty());
            sink.onRequest(numberOfRequestedElements -> this.next((FluxSink<SearchResponse>)sink, scrollId, numberOfRequestedElements));
            sink.onDispose(() -> this.close(scrollId));
        });
    }

    private void next(FluxSink<SearchResponse> sink, AtomicReference<Optional<String>> scrollId, long numberOfRequestedElements) {
        if (numberOfRequestedElements <= 0L) {
            return;
        }
        Consumer<SearchResponse> onResponse = searchResponse -> {
            boolean noHitsLeft;
            scrollId.set(Optional.of(searchResponse.getScrollId()));
            sink.next(searchResponse);
            boolean bl = noHitsLeft = searchResponse.getHits().getHits().length == 0;
            if (noHitsLeft) {
                sink.complete();
            } else {
                this.next(sink, scrollId, numberOfRequestedElements - 1L);
            }
        };
        Consumer<Throwable> onFailure = arg_0 -> sink.error(arg_0);
        this.buildRequest(scrollId.get()).subscribe(onResponse, onFailure);
    }

    private Mono<SearchResponse> buildRequest(Optional<String> scrollId) {
        return scrollId.map(id -> this.client.scroll(new SearchScrollRequest().scrollId((String)scrollId.get()).scroll(TIMEOUT), RequestOptions.DEFAULT)).orElseGet(() -> this.client.search(this.searchRequest, RequestOptions.DEFAULT));
    }

    public void close(AtomicReference<Optional<String>> scrollId) {
        scrollId.get().map(id -> {
            ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
            clearScrollRequest.addScrollId(id);
            return clearScrollRequest;
        }).ifPresent(Throwing.consumer(clearScrollRequest -> this.client.clearScroll((ClearScrollRequest)clearScrollRequest, RequestOptions.DEFAULT).subscribe()).sneakyThrow());
    }
}

