/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Ordering;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import reactor.core.publisher.Mono;

public class CassandraFirstUnseenDAO {
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement addStatement;
    private final PreparedStatement deleteStatement;
    private final PreparedStatement deleteAllStatement;
    private final PreparedStatement readStatement;

    @Inject
    public CassandraFirstUnseenDAO(Session session) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.addStatement = this.prepareAddStatement(session);
        this.deleteStatement = this.prepareDeleteStatement(session);
        this.deleteAllStatement = this.prepareDeleteAllStatement(session);
        this.readStatement = this.prepareReadStatement(session);
    }

    private PreparedStatement prepareReadStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"uid"}).from("firstUnseen").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))).orderBy(new Ordering[]{QueryBuilder.asc((String)"uid")}).limit(1));
    }

    private PreparedStatement prepareDeleteStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("firstUnseen").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))).and(QueryBuilder.eq((String)"uid", (Object)QueryBuilder.bindMarker((String)"uid"))));
    }

    private PreparedStatement prepareDeleteAllStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("firstUnseen").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))));
    }

    private PreparedStatement prepareAddStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"firstUnseen").value("mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId")).value("uid", (Object)QueryBuilder.bindMarker((String)"uid")));
    }

    public Mono<Void> addUnread(CassandraId cassandraId, MessageUid uid) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.addStatement.bind().setUUID("mailboxId", cassandraId.asUuid()).setLong("uid", uid.asLong()));
    }

    public Mono<Void> removeUnread(CassandraId cassandraId, MessageUid uid) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.deleteStatement.bind().setUUID("mailboxId", cassandraId.asUuid()).setLong("uid", uid.asLong()));
    }

    public Mono<Void> removeAll(CassandraId cassandraId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.deleteAllStatement.bind().setUUID("mailboxId", cassandraId.asUuid()));
    }

    public Mono<MessageUid> retrieveFirstUnread(CassandraId cassandraId) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.readStatement.bind().setUUID("mailboxId", cassandraId.asUuid())).map(row -> MessageUid.of((long)row.getLong("uid")));
    }
}

