/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.init.configuration.CassandraConsistenciesConfiguration;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.Username;
import org.apache.james.mailbox.cassandra.GhostMailbox;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.table.CassandraMailboxPathV3Table;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.UidValidity;
import org.apache.james.util.FunctionalUtils;
import org.apache.james.util.ReactorUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraMailboxPathV3DAO {
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement delete;
    private final PreparedStatement insert;
    private final PreparedStatement select;
    private final PreparedStatement selectUser;
    private final PreparedStatement selectAll;
    private final CassandraConsistenciesConfiguration consistenciesConfiguration;

    @Inject
    public CassandraMailboxPathV3DAO(Session session, CassandraConsistenciesConfiguration consistenciesConfiguration) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.consistenciesConfiguration = consistenciesConfiguration;
        this.insert = this.prepareInsert(session);
        this.delete = this.prepareDelete(session);
        this.select = this.prepareSelect(session);
        this.selectUser = this.prepareSelectUser(session);
        this.selectAll = this.prepareSelectAll(session);
    }

    private PreparedStatement prepareDelete(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("mailboxPathV3").where(QueryBuilder.eq((String)"namespace", (Object)QueryBuilder.bindMarker((String)"namespace"))).and(QueryBuilder.eq((String)"user", (Object)QueryBuilder.bindMarker((String)"user"))).and(QueryBuilder.eq((String)"mailboxName", (Object)QueryBuilder.bindMarker((String)"mailboxName"))).ifExists());
    }

    private PreparedStatement prepareInsert(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"mailboxPathV3").value("namespace", (Object)QueryBuilder.bindMarker((String)"namespace")).value("user", (Object)QueryBuilder.bindMarker((String)"user")).value("mailboxName", (Object)QueryBuilder.bindMarker((String)"mailboxName")).value("mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId")).value("uidvalidity", (Object)QueryBuilder.bindMarker((String)"uidvalidity")).ifNotExists());
    }

    private PreparedStatement prepareSelect(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])CassandraMailboxPathV3Table.FIELDS).from("mailboxPathV3").where(QueryBuilder.eq((String)"namespace", (Object)QueryBuilder.bindMarker((String)"namespace"))).and(QueryBuilder.eq((String)"user", (Object)QueryBuilder.bindMarker((String)"user"))).and(QueryBuilder.eq((String)"mailboxName", (Object)QueryBuilder.bindMarker((String)"mailboxName"))));
    }

    private PreparedStatement prepareSelectUser(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])CassandraMailboxPathV3Table.FIELDS).from("mailboxPathV3").where(QueryBuilder.eq((String)"namespace", (Object)QueryBuilder.bindMarker((String)"namespace"))).and(QueryBuilder.eq((String)"user", (Object)QueryBuilder.bindMarker((String)"user"))));
    }

    private PreparedStatement prepareSelectAll(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])CassandraMailboxPathV3Table.FIELDS).from("mailboxPathV3"));
    }

    public Mono<Mailbox> retrieve(MailboxPath mailboxPath) {
        return this.retrieve(mailboxPath, this.consistenciesConfiguration.getLightweightTransaction());
    }

    public Mono<Mailbox> retrieve(MailboxPath mailboxPath, CassandraConsistenciesConfiguration.ConsistencyChoice consistencyChoice) {
        return this.retrieve(mailboxPath, consistencyChoice.choose(this.consistenciesConfiguration));
    }

    private Mono<Mailbox> retrieve(MailboxPath mailboxPath, ConsistencyLevel consistencyLevel) {
        return this.cassandraAsyncExecutor.executeSingleRow(this.select.bind().setString("namespace", mailboxPath.getNamespace()).setString("user", this.sanitizeUser(mailboxPath.getUser())).setString("mailboxName", mailboxPath.getName()).setConsistencyLevel(consistencyLevel)).map(this::fromRowToCassandraIdAndPath).map((Function)FunctionalUtils.toFunction(this::logGhostMailboxSuccess)).switchIfEmpty(ReactorUtils.executeAndEmpty(() -> this.logGhostMailboxFailure(mailboxPath)));
    }

    public Flux<Mailbox> listUserMailboxes(String namespace, Username user, CassandraConsistenciesConfiguration.ConsistencyChoice consistencyChoice) {
        return this.cassandraAsyncExecutor.executeRows(this.selectUser.bind().setString("namespace", namespace).setString("user", this.sanitizeUser(user)).setConsistencyLevel(consistencyChoice.choose(this.consistenciesConfiguration))).map(this::fromRowToCassandraIdAndPath).map((Function)FunctionalUtils.toFunction(this::logReadSuccess));
    }

    public Flux<Mailbox> listAll() {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.selectAll.bind()).map(this::fromRowToCassandraIdAndPath).map((Function)FunctionalUtils.toFunction(this::logReadSuccess));
    }

    public void logGhostMailboxSuccess(Mailbox value) {
        this.logReadSuccess(value);
    }

    public void logGhostMailboxFailure(MailboxPath mailboxPath) {
        GhostMailbox.logger().field("mailboxName", mailboxPath.asString()).field("type", "readMiss").log(logger -> logger.debug("Read mailbox missed"));
    }

    private void logReadSuccess(Mailbox mailbox) {
        GhostMailbox.logger().field("mailboxName", mailbox.generateAssociatedPath().asString()).field("type", "readSuccess").field("mailboxId", mailbox.getMailboxId().serialize()).log(logger -> logger.debug("Read mailbox succeeded"));
    }

    private Mailbox fromRowToCassandraIdAndPath(Row row) {
        return new Mailbox(new MailboxPath(row.getString("namespace"), Username.of((String)row.getString("user")), row.getString("mailboxName")), UidValidity.of((long)row.getLong("uidvalidity")), (MailboxId)CassandraId.of(row.getUUID("mailboxId")));
    }

    public Mono<Boolean> save(Mailbox mailbox) {
        CassandraId id = (CassandraId)mailbox.getMailboxId();
        return this.cassandraAsyncExecutor.executeReturnApplied((Statement)this.insert.bind().setString("namespace", mailbox.getNamespace()).setString("user", this.sanitizeUser(mailbox.getUser())).setLong("uidvalidity", mailbox.getUidValidity().asLong()).setString("mailboxName", mailbox.getName()).setUUID("mailboxId", id.asUuid()));
    }

    public Mono<Void> delete(MailboxPath mailboxPath) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.delete.bind().setString("namespace", mailboxPath.getNamespace()).setString("user", this.sanitizeUser(mailboxPath.getUser())).setString("mailboxName", mailboxPath.getName()));
    }

    private String sanitizeUser(Username user) {
        if (user == null) {
            return "";
        }
        return user.asString();
    }
}

