/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.cassandra.utils;

import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public class PipedInputStreamHandlingError
extends PipedInputStream {
    private final AtomicReference<RuntimeException> error = new AtomicReference();

    void setError(RuntimeException e) {
        this.error.set(e);
    }

    private void assertNoError() {
        Optional<RuntimeException> maybeError = Optional.ofNullable(this.error.get());
        if (maybeError.isPresent()) {
            throw maybeError.get();
        }
    }

    @Override
    public void connect(PipedOutputStream src) throws IOException {
        this.assertNoError();
        super.connect(src);
    }

    @Override
    protected synchronized void receive(int b) throws IOException {
        this.assertNoError();
        super.receive(b);
    }

    @Override
    public synchronized int read() throws IOException {
        this.assertNoError();
        return super.read();
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        this.assertNoError();
        return super.read(b, off, len);
    }

    @Override
    public synchronized int available() throws IOException {
        this.assertNoError();
        return super.available();
    }

    @Override
    public void close() throws IOException {
        try {
            this.assertNoError();
        }
        finally {
            super.close();
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.assertNoError();
        return super.read(b);
    }

    @Override
    public long skip(long n) throws IOException {
        this.assertNoError();
        return super.skip(n);
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.assertNoError();
        super.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.assertNoError();
        super.reset();
    }

    @Override
    public boolean markSupported() {
        this.assertNoError();
        return super.markSupported();
    }
}

