/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableMap;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.MessageProperties;
import java.time.Clock;
import java.time.Duration;
import java.util.Map;
import java.util.function.Function;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.blob.api.Store;
import org.apache.james.blob.mail.MimeMessagePartsId;
import org.apache.james.metrics.api.Metric;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.rabbitmq.EnqueueId;
import org.apache.james.queue.rabbitmq.EnqueuedItem;
import org.apache.james.queue.rabbitmq.MailQueueName;
import org.apache.james.queue.rabbitmq.MailReference;
import org.apache.james.queue.rabbitmq.MailReferenceDTO;
import org.apache.james.queue.rabbitmq.MailReferenceSerializer;
import org.apache.james.queue.rabbitmq.view.api.DeleteCondition;
import org.apache.james.queue.rabbitmq.view.api.MailQueueView;
import org.apache.james.queue.rabbitmq.view.cassandra.CassandraMailQueueBrowser;
import org.apache.mailet.Mail;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.rabbitmq.OutboundMessage;
import reactor.rabbitmq.Sender;

class Enqueuer {
    private final MailQueueName name;
    private final Sender sender;
    private final Store<MimeMessage, MimeMessagePartsId> mimeMessageStore;
    private final MailReferenceSerializer mailReferenceSerializer;
    private final Metric enqueueMetric;
    private final MailQueueView mailQueueView;
    private final Clock clock;

    Enqueuer(MailQueueName name, Sender sender, Store<MimeMessage, MimeMessagePartsId> mimeMessageStore, MailReferenceSerializer serializer, MetricFactory metricFactory, MailQueueView mailQueueView, Clock clock) {
        this.name = name;
        this.sender = sender;
        this.mimeMessageStore = mimeMessageStore;
        this.mailReferenceSerializer = serializer;
        this.mailQueueView = mailQueueView;
        this.clock = clock;
        this.enqueueMetric = metricFactory.generate("enqueuedMail:" + name.asString());
    }

    Mono<Void> enQueue(Mail mail) throws MailQueue.MailQueueException {
        EnqueueId enqueueId = EnqueueId.generate();
        return this.saveMail(mail).map(partIds -> new MailReference(enqueueId, mail, (MimeMessagePartsId)partIds)).flatMap(Throwing.function(mailReference -> {
            EnqueuedItem enqueuedItem = this.toEnqueuedItems((MailReference)mailReference);
            return Flux.mergeDelayError((int)2, (Publisher[])new Publisher[]{this.mailQueueView.storeMail(enqueuedItem), this.publishReferenceToRabbit((MailReference)mailReference)}).then().onErrorResume(this.cleanupMailQueueView(enqueueId, (MailReference)mailReference));
        }).sneakyThrow()).thenEmpty((Publisher)Mono.fromRunnable(() -> ((Metric)this.enqueueMetric).increment()));
    }

    private Function<Throwable, Mono<Void>> cleanupMailQueueView(EnqueueId enqueueId, MailReference mailReference) {
        return e -> {
            DeleteCondition.WithEnqueueId deleteCondition = DeleteCondition.withEnqueueId(enqueueId, mailReference.getPartsId());
            return Mono.from(this.mailQueueView.delete(deleteCondition)).then(Mono.error((Throwable)e));
        };
    }

    Mono<Void> reQueue(CassandraMailQueueBrowser.CassandraMailQueueItemView item) {
        Mail mail = item.getMail();
        return Mono.fromCallable(() -> new MailReference(item.getEnqueuedId(), mail, item.getEnqueuedPartsId())).flatMap(Throwing.function(this::publishReferenceToRabbit).sneakyThrow()).then();
    }

    private Mono<MimeMessagePartsId> saveMail(Mail mail) throws MailQueue.MailQueueException {
        try {
            return this.mimeMessageStore.save((Object)mail.getMessage());
        }
        catch (MessagingException e) {
            throw new MailQueue.MailQueueException("Error while saving blob", (Exception)((Object)e));
        }
    }

    private Mono<Void> publishReferenceToRabbit(MailReference mailReference) throws MailQueue.MailQueueException {
        AMQP.BasicProperties basicProperties = new AMQP.BasicProperties.Builder().deliveryMode(MessageProperties.PERSISTENT_TEXT_PLAIN.getDeliveryMode()).priority(MessageProperties.PERSISTENT_TEXT_PLAIN.getPriority()).contentType(MessageProperties.PERSISTENT_TEXT_PLAIN.getContentType()).headers((Map)ImmutableMap.of((Object)"x-dead-letter-routing-key", (Object)"")).build();
        OutboundMessage data = new OutboundMessage(this.name.toRabbitExchangeName().asString(), "", basicProperties, this.getMailReferenceBytes(mailReference));
        return this.sender.sendWithPublishConfirms((Publisher)Mono.just((Object)data)).subscribeOn(Schedulers.elastic()).next().handle((result, sink) -> {
            if (!result.isAck()) {
                sink.error((Throwable)new MailQueue.MailQueueException("Publish was not acked"));
            } else {
                sink.complete();
            }
        }).timeout(Duration.ofSeconds(10L), Mono.error(() -> new MailQueue.MailQueueException("Timeout enqueueing " + mailReference.getMail().getName()))).then();
    }

    private EnqueuedItem toEnqueuedItems(MailReference mailReference) {
        return EnqueuedItem.builder().enqueueId(mailReference.getEnqueueId()).mailQueueName(this.name).mail(mailReference.getMail()).enqueuedTime(this.clock.instant()).mimeMessagePartsId(mailReference.getPartsId()).build();
    }

    private byte[] getMailReferenceBytes(MailReference mailReference) throws MailQueue.MailQueueException {
        try {
            MailReferenceDTO mailDTO = MailReferenceDTO.fromMailReference(mailReference);
            return this.mailReferenceSerializer.write(mailDTO);
        }
        catch (JsonProcessingException e) {
            throw new MailQueue.MailQueueException("Unable to serialize message", (Exception)((Object)e));
        }
    }
}

