/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.configuration2.Configuration;
import org.apache.james.util.DurationParser;

public class VaultConfiguration {
    public static final VaultConfiguration DEFAULT = new VaultConfiguration(ChronoUnit.YEARS.getDuration(), "Restored-Messages");
    private final Duration retentionPeriod;
    private final String restoreLocation;

    public static VaultConfiguration from(Configuration propertiesConfiguration) {
        Duration retentionPeriod = Optional.ofNullable(propertiesConfiguration.getString("retentionPeriod")).map(string -> DurationParser.parse((String)string, (ChronoUnit)ChronoUnit.DAYS)).orElse(DEFAULT.getRetentionPeriod());
        String restoreLocation = Optional.ofNullable(propertiesConfiguration.getString("restoreLocation")).orElse(DEFAULT.getRestoreLocation());
        return new VaultConfiguration(retentionPeriod, restoreLocation);
    }

    VaultConfiguration(Duration retentionPeriod, String restoreLocation) {
        Preconditions.checkNotNull((Object)retentionPeriod);
        Preconditions.checkNotNull((Object)restoreLocation);
        this.retentionPeriod = retentionPeriod;
        this.restoreLocation = restoreLocation;
    }

    public Duration getRetentionPeriod() {
        return this.retentionPeriod;
    }

    public String getRestoreLocation() {
        return this.restoreLocation;
    }

    public final boolean equals(Object o) {
        if (o instanceof VaultConfiguration) {
            VaultConfiguration that = (VaultConfiguration)o;
            return Objects.equals(this.retentionPeriod, that.retentionPeriod) && Objects.equals(this.restoreLocation, that.restoreLocation);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.retentionPeriod, this.restoreLocation);
    }
}

