/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task.eventsourcing.distributed;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Delivery;
import java.io.Closeable;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.james.backends.rabbitmq.ReceiverProvider;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.eventstore.cassandra.JsonEventSerializer;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.task.eventsourcing.TerminationSubscriber;
import org.apache.james.task.eventsourcing.distributed.TerminationQueueName;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.DirectProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.UnicastProcessor;
import reactor.core.scheduler.Schedulers;
import reactor.rabbitmq.BindingSpecification;
import reactor.rabbitmq.ExchangeSpecification;
import reactor.rabbitmq.OutboundMessage;
import reactor.rabbitmq.QueueSpecification;
import reactor.rabbitmq.Receiver;
import reactor.rabbitmq.Sender;

public class RabbitMQTerminationSubscriber
implements TerminationSubscriber,
Startable,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RabbitMQTerminationSubscriber.class);
    static final String EXCHANGE_NAME = "terminationSubscriberExchange";
    static final String QUEUE_NAME_PREFIX = "terminationSubscriber";
    static final String ROUTING_KEY = "terminationSubscriberRoutingKey";
    private final TerminationQueueName queueName;
    private final JsonEventSerializer serializer;
    private final Sender sender;
    private final ReceiverProvider receiverProvider;
    private UnicastProcessor<OutboundMessage> sendQueue;
    private DirectProcessor<Event> listener;
    private Disposable sendQueueHandle;
    private Disposable listenQueueHandle;

    @Inject
    RabbitMQTerminationSubscriber(TerminationQueueName queueName, Sender sender, ReceiverProvider receiverProvider, JsonEventSerializer serializer) {
        this.queueName = queueName;
        this.sender = sender;
        this.receiverProvider = receiverProvider;
        this.serializer = serializer;
    }

    public void start() {
        this.sender.declareExchange(ExchangeSpecification.exchange((String)EXCHANGE_NAME)).block();
        this.sender.declare(QueueSpecification.queue((String)this.queueName.asString()).durable(false).autoDelete(true)).block();
        this.sender.bind(BindingSpecification.binding((String)EXCHANGE_NAME, (String)ROUTING_KEY, (String)this.queueName.asString())).block();
        this.sendQueue = UnicastProcessor.create();
        this.sendQueueHandle = this.sender.send(this.sendQueue).subscribeOn(Schedulers.elastic()).subscribe();
        this.listener = DirectProcessor.create();
        this.listenQueueHandle = this.consumeTerminationQueue();
    }

    public void restart() {
        Disposable previousHandler = this.listenQueueHandle;
        this.listenQueueHandle = this.consumeTerminationQueue();
        previousHandler.dispose();
    }

    private Disposable consumeTerminationQueue() {
        return Flux.using(() -> ((ReceiverProvider)this.receiverProvider).createReceiver(), receiver -> receiver.consumeAutoAck(this.queueName.asString()), Receiver::close).subscribeOn(Schedulers.elastic()).map(this::toEvent).handle(ReactorUtils.publishIfPresent()).subscribe(arg_0 -> this.listener.onNext(arg_0));
    }

    public void addEvent(Event event) {
        try {
            byte[] payload = this.serializer.serialize(event).getBytes(StandardCharsets.UTF_8);
            AMQP.BasicProperties basicProperties = new AMQP.BasicProperties.Builder().build();
            OutboundMessage message = new OutboundMessage(EXCHANGE_NAME, ROUTING_KEY, basicProperties, payload);
            this.sendQueue.onNext((Object)message);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public Publisher<Event> listenEvents() {
        return this.listener.share();
    }

    private Optional<Event> toEvent(Delivery delivery) {
        String message = new String(delivery.getBody(), StandardCharsets.UTF_8);
        try {
            Event event = this.serializer.deserialize(message);
            return Optional.of(event);
        }
        catch (Exception e) {
            LOGGER.error("Unable to deserialize '{}'", (Object)message, (Object)e);
            return Optional.empty();
        }
    }

    @Override
    @PreDestroy
    public void close() {
        Optional.ofNullable(this.sendQueueHandle).ifPresent(Disposable::dispose);
        Optional.ofNullable(this.listenQueueHandle).ifPresent(Disposable::dispose);
    }
}

