/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.DriverThrowables;
import com.datastax.driver.core.GuavaCompatibility;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.SystemProperties;
import com.datastax.shaded.netty.util.concurrent.EventExecutor;
import com.google.common.base.Function;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public abstract class AbstractSession
implements Session {
    private static final boolean CHECK_IO_DEADLOCKS = SystemProperties.getBoolean("com.datastax.driver.CHECK_IO_DEADLOCKS", true);

    @Override
    public ResultSet execute(String query) {
        return this.execute(new SimpleStatement(query));
    }

    @Override
    public ResultSet execute(String query, Object ... values) {
        return this.execute(new SimpleStatement(query, values));
    }

    @Override
    public ResultSet execute(String query, Map<String, Object> values) {
        return this.execute(new SimpleStatement(query, values));
    }

    @Override
    public ResultSet execute(Statement statement) {
        this.checkNotInEventLoop();
        return this.executeAsync(statement).getUninterruptibly();
    }

    @Override
    public ResultSetFuture executeAsync(String query) {
        return this.executeAsync(new SimpleStatement(query));
    }

    @Override
    public ResultSetFuture executeAsync(String query, Map<String, Object> values) {
        return this.executeAsync(new SimpleStatement(query, values));
    }

    @Override
    public ResultSetFuture executeAsync(String query, Object ... values) {
        return this.executeAsync(new SimpleStatement(query, values));
    }

    @Override
    public PreparedStatement prepare(String query) {
        this.checkNotInEventLoop();
        try {
            return (PreparedStatement)Uninterruptibles.getUninterruptibly(this.prepareAsync(query));
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    @Override
    public PreparedStatement prepare(RegularStatement statement) {
        this.checkNotInEventLoop();
        try {
            return (PreparedStatement)Uninterruptibles.getUninterruptibly(this.prepareAsync(statement));
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    @Override
    public ListenableFuture<PreparedStatement> prepareAsync(String query) {
        return this.prepareAsync(query, null);
    }

    @Override
    public ListenableFuture<PreparedStatement> prepareAsync(final RegularStatement statement) {
        if (statement.hasValues()) {
            throw new IllegalArgumentException("A statement to prepare should not have values");
        }
        final CodecRegistry codecRegistry = this.getCluster().getConfiguration().getCodecRegistry();
        ListenableFuture<PreparedStatement> prepared = this.prepareAsync(statement.getQueryString(codecRegistry), statement.getOutgoingPayload());
        return GuavaCompatibility.INSTANCE.transform(prepared, new Function<PreparedStatement, PreparedStatement>(){

            public PreparedStatement apply(PreparedStatement prepared) {
                ProtocolVersion protocolVersion = AbstractSession.this.getCluster().getConfiguration().getProtocolOptions().getProtocolVersion();
                ByteBuffer routingKey = statement.getRoutingKey(protocolVersion, codecRegistry);
                if (routingKey != null) {
                    prepared.setRoutingKey(routingKey);
                }
                if (statement.getConsistencyLevel() != null) {
                    prepared.setConsistencyLevel(statement.getConsistencyLevel());
                }
                if (statement.getSerialConsistencyLevel() != null) {
                    prepared.setSerialConsistencyLevel(statement.getSerialConsistencyLevel());
                }
                if (statement.isTracing()) {
                    prepared.enableTracing();
                }
                prepared.setRetryPolicy(statement.getRetryPolicy());
                prepared.setOutgoingPayload(statement.getOutgoingPayload());
                prepared.setIdempotent(statement.isIdempotent());
                return prepared;
            }
        });
    }

    protected abstract ListenableFuture<PreparedStatement> prepareAsync(String var1, Map<String, ByteBuffer> var2);

    @Override
    public void close() {
        try {
            this.closeAsync().get();
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void checkNotInEventLoop() {
        Connection.Factory connectionFactory = this.getCluster().manager.connectionFactory;
        if (!CHECK_IO_DEADLOCKS || connectionFactory == null) {
            return;
        }
        for (EventExecutor executor : connectionFactory.eventLoopGroup) {
            if (!executor.inEventLoop()) continue;
            throw new IllegalStateException("Detected a synchronous call on an I/O thread, this can cause deadlocks or unpredictable behavior. This generally happens when a Future callback calls a synchronous Session method (execute() or prepare()), or iterates a result set past the fetch size (causing an internal synchronous fetch of the next page of results). Avoid this in your callbacks, or schedule them on a different executor.");
        }
    }
}

