/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.credentials;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
public final class AwsCredentialsProviderChain
implements AwsCredentialsProvider,
SdkAutoCloseable {
    private static final Logger log = Logger.loggerFor(AwsCredentialsProviderChain.class);
    private final List<AwsCredentialsProvider> credentialsProviders;
    private final boolean reuseLastProviderEnabled;
    private volatile AwsCredentialsProvider lastUsedProvider;

    private AwsCredentialsProviderChain(BuilderImpl builder) {
        Validate.notEmpty((Collection)builder.credentialsProviders, (String)"No credential providers were specified.", (Object[])new Object[0]);
        this.reuseLastProviderEnabled = builder.reuseLastProviderEnabled;
        this.credentialsProviders = Collections.unmodifiableList(builder.credentialsProviders);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static AwsCredentialsProviderChain of(AwsCredentialsProvider ... awsCredentialsProviders) {
        return AwsCredentialsProviderChain.builder().credentialsProviders(awsCredentialsProviders).build();
    }

    @Override
    public AwsCredentials resolveCredentials() {
        if (this.reuseLastProviderEnabled && this.lastUsedProvider != null) {
            return this.lastUsedProvider.resolveCredentials();
        }
        ArrayList<String> exceptionMessages = null;
        for (AwsCredentialsProvider provider : this.credentialsProviders) {
            try {
                AwsCredentials credentials = provider.resolveCredentials();
                log.debug(() -> "Loading credentials from " + provider);
                this.lastUsedProvider = provider;
                return credentials;
            }
            catch (RuntimeException e) {
                String message = provider + ": " + e.getMessage();
                log.debug(() -> "Unable to load credentials from " + message, (Throwable)e);
                if (exceptionMessages == null) {
                    exceptionMessages = new ArrayList<String>();
                }
                exceptionMessages.add(message);
            }
        }
        throw SdkClientException.builder().message("Unable to load credentials from any of the providers in the chain " + this + " : " + exceptionMessages).build();
    }

    public void close() {
        this.credentialsProviders.forEach(c -> IoUtils.closeIfCloseable((Object)c, null));
    }

    public String toString() {
        return ToString.builder((String)"AwsCredentialsProviderChain").add("credentialsProviders", this.credentialsProviders).build();
    }

    private static final class BuilderImpl
    implements Builder {
        private Boolean reuseLastProviderEnabled = true;
        private List<AwsCredentialsProvider> credentialsProviders = new ArrayList<AwsCredentialsProvider>();

        private BuilderImpl() {
        }

        @Override
        public Builder reuseLastProviderEnabled(Boolean reuseLastProviderEnabled) {
            this.reuseLastProviderEnabled = reuseLastProviderEnabled;
            return this;
        }

        public void setReuseLastProviderEnabled(Boolean reuseLastProviderEnabled) {
            this.reuseLastProviderEnabled(reuseLastProviderEnabled);
        }

        @Override
        public Builder credentialsProviders(Collection<? extends AwsCredentialsProvider> credentialsProviders) {
            this.credentialsProviders = new ArrayList<AwsCredentialsProvider>(credentialsProviders);
            return this;
        }

        public void setCredentialsProviders(Collection<? extends AwsCredentialsProvider> credentialsProviders) {
            this.credentialsProviders(credentialsProviders);
        }

        @Override
        public Builder credentialsProviders(AwsCredentialsProvider ... credentialsProviders) {
            return this.credentialsProviders(Arrays.asList(credentialsProviders));
        }

        @Override
        public Builder addCredentialsProvider(AwsCredentialsProvider credentialsProviders) {
            this.credentialsProviders.add(credentialsProviders);
            return this;
        }

        @Override
        public AwsCredentialsProviderChain build() {
            return new AwsCredentialsProviderChain(this);
        }
    }

    public static interface Builder {
        public Builder reuseLastProviderEnabled(Boolean var1);

        public Builder credentialsProviders(Collection<? extends AwsCredentialsProvider> var1);

        public Builder credentialsProviders(AwsCredentialsProvider ... var1);

        public Builder addCredentialsProvider(AwsCredentialsProvider var1);

        public AwsCredentialsProviderChain build();
    }
}

