/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;

public class Role {
    public static final String USER_DEFINED_ROLE_PREFIX = "x-";
    private static final BiFunction<String, String, Boolean> CASE_SENSITIVE_COMPARATOR = (a, b) -> a.equals(b);
    private static final BiFunction<String, String, Boolean> NON_CASE_SENSITIVE_COMPARATOR = (a, b) -> a.equalsIgnoreCase((String)b);
    public static final Role INBOX = new Role("inbox", "INBOX", NON_CASE_SENSITIVE_COMPARATOR);
    public static final Role DRAFTS = new Role("drafts", "Drafts", CASE_SENSITIVE_COMPARATOR);
    public static final Role OUTBOX = new Role("outbox", "Outbox", CASE_SENSITIVE_COMPARATOR);
    public static final Role SENT = new Role("sent", "Sent", CASE_SENSITIVE_COMPARATOR);
    public static final Role TRASH = new Role("trash", "Trash", CASE_SENSITIVE_COMPARATOR);
    public static final Role ARCHIVE = new Role("archive", "Archive", CASE_SENSITIVE_COMPARATOR);
    public static final Role SPAM = new Role("spam", "Spam", CASE_SENSITIVE_COMPARATOR);
    public static final Role TEMPLATES = new Role("templates", "Templates", CASE_SENSITIVE_COMPARATOR);
    public static final Role RESTORED_MESSAGES = new Role("restored messages", "Restored-Messages", CASE_SENSITIVE_COMPARATOR);
    private static final List<Role> ROLES = ImmutableList.of((Object)INBOX, (Object)DRAFTS, (Object)OUTBOX, (Object)SENT, (Object)TRASH, (Object)ARCHIVE, (Object)SPAM, (Object)TEMPLATES, (Object)RESTORED_MESSAGES);
    private final String name;
    private final String defaultMailbox;
    private final BiFunction<String, String, Boolean> comparator;

    @VisibleForTesting
    Role(String name, String defaultMailbox, BiFunction<String, String, Boolean> comparator) {
        this.name = name;
        this.defaultMailbox = defaultMailbox;
        this.comparator = comparator;
    }

    @VisibleForTesting
    Role(String name) {
        this.name = name;
        this.defaultMailbox = null;
        this.comparator = NON_CASE_SENSITIVE_COMPARATOR;
    }

    public static Optional<Role> from(String name) {
        Optional<Role> predefinedRole = Role.predefinedRole(name);
        if (predefinedRole.isPresent()) {
            return predefinedRole;
        }
        return Role.tryBuildCustomRole(name);
    }

    private static Optional<Role> predefinedRole(String name) {
        return ROLES.stream().filter(role -> role.comparator.apply(role.defaultMailbox, name)).findFirst();
    }

    private static Optional<Role> tryBuildCustomRole(String name) {
        if (name.startsWith(USER_DEFINED_ROLE_PREFIX)) {
            return Optional.of(new Role(name));
        }
        return Optional.empty();
    }

    public boolean isSystemRole() {
        return Role.predefinedRole(this.defaultMailbox).isPresent();
    }

    public String serialize() {
        return this.name;
    }

    public String getDefaultMailbox() {
        return this.defaultMailbox;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.defaultMailbox});
    }

    public boolean equals(Object object) {
        if (object instanceof Role) {
            Role that = (Role)object;
            return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.defaultMailbox, (Object)that.defaultMailbox);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("defaultMailbox", (Object)this.defaultMailbox).toString();
    }
}

