/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.function.Function;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.indexer.ReIndexingExecutionFailures;
import org.apache.james.mailbox.model.MailboxId;

public class SerializableReIndexingExecutionFailures {
    private final List<SerializableReIndexingFailure> failures;

    public static SerializableReIndexingExecutionFailures from(ReIndexingExecutionFailures reIndexingExecutionFailures) {
        return new SerializableReIndexingExecutionFailures((List)reIndexingExecutionFailures.messageFailures().stream().map(failure -> new SerializableReIndexingFailure(failure.getMailboxId(), failure.getUid())).collect(ImmutableList.toImmutableList()));
    }

    public SerializableReIndexingExecutionFailures(List<SerializableReIndexingFailure> failures) {
        this.failures = failures;
    }

    @JsonValue
    public Multimap<String, SerializableReIndexingFailure> failures() {
        return (Multimap)this.failures.stream().collect(ImmutableListMultimap.toImmutableListMultimap(SerializableReIndexingFailure::getSerializedMailboxId, Function.identity()));
    }

    public static class SerializableReIndexingFailure {
        private final MailboxId mailboxId;
        private final MessageUid uid;

        public SerializableReIndexingFailure(MailboxId mailboxId, MessageUid uid) {
            this.mailboxId = mailboxId;
            this.uid = uid;
        }

        @JsonIgnore
        public String getSerializedMailboxId() {
            return this.mailboxId.serialize();
        }

        public long getUid() {
            return this.uid.asLong();
        }
    }
}

