/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.PasswordProvider;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.util.Arrays;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ReadFromFilePasswordProvider
extends PasswordProvider {
    private static final long serialVersionUID = -3343425971796985100L;
    @NotNull
    private final File passwordFile;

    public ReadFromFilePasswordProvider(@NotNull String passwordFile) {
        Validator.ensureNotNull(passwordFile);
        this.passwordFile = new File(passwordFile);
    }

    public ReadFromFilePasswordProvider(@NotNull File passwordFile) {
        Validator.ensureNotNull(passwordFile);
        this.passwordFile = passwordFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public byte[] getPasswordBytes() throws LDAPException {
        byte[] pwBytes = null;
        try {
            int fileLength = (int)this.passwordFile.length();
            pwBytes = new byte[fileLength];
            try (FileInputStream inputStream = new FileInputStream(this.passwordFile);){
                int bytesRead;
                for (int pos = 0; pos < fileLength; pos += bytesRead) {
                    bytesRead = inputStream.read(pwBytes, pos, pwBytes.length - pos);
                    if (bytesRead >= 0) continue;
                    break;
                }
            }
            for (int i = 0; i < pwBytes.length; ++i) {
                if (pwBytes[i] != 10 && pwBytes[i] != 13) continue;
                byte[] pwWithoutEOL = new byte[i];
                System.arraycopy(pwBytes, 0, pwWithoutEOL, 0, i);
                Arrays.fill(pwBytes, (byte)0);
                pwBytes = pwWithoutEOL;
                break;
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            if (pwBytes != null) {
                Arrays.fill(pwBytes, (byte)0);
            }
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_FILE_PW_PROVIDER_ERROR_READING_PW.get(this.passwordFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
        }
        if (pwBytes.length == 0) {
            throw new LDAPException(ResultCode.PARAM_ERROR, LDAPMessages.ERR_FILE_PW_PROVIDER_EMPTY_PW.get(this.passwordFile.getAbsolutePath()));
        }
        return pwBytes;
    }
}

