/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPRuntimeException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.CommandLineTool;
import com.unboundid.util.CryptoHelper;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.ssl.SSLMessages;
import com.unboundid.util.ssl.SSLUtil;
import com.unboundid.util.ssl.TLSCipherSuiteComparator;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class TLSCipherSuiteSelector
extends CommandLineTool {
    @NotNull
    private static final AtomicReference<TLSCipherSuiteSelector> STATIC_INSTANCE = new AtomicReference();
    @NotNull
    public static final String PROPERTY_ALLOW_RSA_KEY_EXCHANGE = TLSCipherSuiteSelector.class.getName() + ".allowRSAKeyExchange";
    @NotNull
    public static final String PROPERTY_ALLOW_SHA_1 = TLSCipherSuiteSelector.class.getName() + ".allowSHA1";
    @NotNull
    private static final AtomicBoolean ALLOW_RSA_KEY_EXCHANGE = new AtomicBoolean(false);
    @NotNull
    private static final AtomicBoolean ALLOW_SHA_1 = new AtomicBoolean(false);
    private final boolean jvmSSLDebuggingEnabled;
    @NotNull
    private final SortedMap<String, List<String>> nonRecommendedCipherSuites;
    @NotNull
    private final SortedSet<String> defaultCipherSuites;
    @NotNull
    private final SortedSet<String> recommendedCipherSuites;
    @NotNull
    private final SortedSet<String> supportedCipherSuites;
    @NotNull
    private final String[] recommendedCipherSuiteArray;

    public static void main(String ... args) {
        ResultCode resultCode = TLSCipherSuiteSelector.main(System.out, System.err, args);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    @NotNull
    public static ResultCode main(@Nullable OutputStream out, @Nullable OutputStream err, String ... args) {
        TLSCipherSuiteSelector tool = new TLSCipherSuiteSelector(out, err);
        return tool.runTool(args);
    }

    private TLSCipherSuiteSelector(boolean useJVMDefaults) {
        this(null, null, useJVMDefaults);
    }

    public TLSCipherSuiteSelector(@Nullable OutputStream out, @Nullable OutputStream err) {
        this(out, err, false);
    }

    public TLSCipherSuiteSelector(@Nullable OutputStream out, @Nullable OutputStream err, boolean useJVMDefaults) {
        super(out, err);
        try {
            SSLContext sslContext = useJVMDefaults ? SSLContext.getDefault() : CryptoHelper.getDefaultSSLContext();
            SSLParameters supportedParameters = sslContext.getSupportedSSLParameters();
            TreeSet<String> supportedSet = new TreeSet<String>(TLSCipherSuiteComparator.getInstance());
            supportedSet.addAll(Arrays.asList(supportedParameters.getCipherSuites()));
            this.supportedCipherSuites = Collections.unmodifiableSortedSet(supportedSet);
            SSLParameters defaultParameters = sslContext.getDefaultSSLParameters();
            TreeSet<String> defaultSet = new TreeSet<String>(TLSCipherSuiteComparator.getInstance());
            defaultSet.addAll(Arrays.asList(defaultParameters.getCipherSuites()));
            this.defaultCipherSuites = Collections.unmodifiableSortedSet(defaultSet);
            if (useJVMDefaults) {
                this.recommendedCipherSuites = this.defaultCipherSuites;
                this.nonRecommendedCipherSuites = Collections.unmodifiableSortedMap(new TreeMap());
            } else {
                ObjectPair<SortedSet<String>, SortedMap<String, List<String>>> selectedPair = TLSCipherSuiteSelector.selectCipherSuites(supportedParameters.getCipherSuites());
                if (selectedPair.getFirst().isEmpty()) {
                    this.recommendedCipherSuites = this.defaultCipherSuites;
                    this.nonRecommendedCipherSuites = Collections.unmodifiableSortedMap(new TreeMap());
                } else {
                    this.recommendedCipherSuites = Collections.unmodifiableSortedSet(selectedPair.getFirst());
                    this.nonRecommendedCipherSuites = Collections.unmodifiableSortedMap(selectedPair.getSecond());
                }
            }
            this.recommendedCipherSuiteArray = this.recommendedCipherSuites.toArray(StaticUtils.NO_STRINGS);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPRuntimeException(new LDAPException(ResultCode.LOCAL_ERROR, SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_INIT_ERROR.get(StaticUtils.getExceptionMessage(e)), e));
        }
        String javaxNetDebugPropertyValue = StaticUtils.getSystemProperty("javax.net.debug");
        if (javaxNetDebugPropertyValue == null) {
            this.jvmSSLDebuggingEnabled = false;
        } else {
            String lowerValue = StaticUtils.toLowerCase(javaxNetDebugPropertyValue);
            boolean bl = this.jvmSSLDebuggingEnabled = lowerValue.contains("all") || lowerValue.contains("ssl");
            if (this.jvmSSLDebuggingEnabled) {
                System.err.println();
                System.err.println(this.getClass().getName() + " Results:");
                this.generateOutput(System.err);
                System.err.println();
            }
        }
    }

    @NotNull
    public static SortedSet<String> getSupportedCipherSuites() {
        return TLSCipherSuiteSelector.getStaticInstance().supportedCipherSuites;
    }

    @NotNull
    public static SortedSet<String> getDefaultCipherSuites() {
        return TLSCipherSuiteSelector.getStaticInstance().defaultCipherSuites;
    }

    @NotNull
    public static SortedSet<String> getRecommendedCipherSuites() {
        return TLSCipherSuiteSelector.getStaticInstance().recommendedCipherSuites;
    }

    @NotNull
    public static String[] getRecommendedCipherSuiteArray() {
        return (String[])TLSCipherSuiteSelector.getStaticInstance().recommendedCipherSuiteArray.clone();
    }

    @NotNull
    public static SortedMap<String, List<String>> getNonRecommendedCipherSuites() {
        return TLSCipherSuiteSelector.getStaticInstance().nonRecommendedCipherSuites;
    }

    @NotNull
    static ObjectPair<SortedSet<String>, SortedMap<String, List<String>>> selectCipherSuites(@NotNull String[] cipherSuiteArray) {
        return TLSCipherSuiteSelector.selectCipherSuites(cipherSuiteArray, false);
    }

    @NotNull
    private static ObjectPair<SortedSet<String>, SortedMap<String, List<String>>> selectCipherSuites(@NotNull String[] cipherSuiteArray, boolean includeSSLSuites) {
        TreeSet<String> recommendedSet = new TreeSet<String>(TLSCipherSuiteComparator.getInstance());
        TreeMap nonRecommendedMap = new TreeMap(TLSCipherSuiteComparator.getInstance());
        boolean anyTLSSuitesFound = false;
        for (String cipherSuiteName : cipherSuiteArray) {
            String name = StaticUtils.toUpperCase(cipherSuiteName).replace('-', '_');
            if (name.endsWith("_SCSV")) {
                recommendedSet.add(cipherSuiteName);
                continue;
            }
            ArrayList<String> nonRecommendedReasons = new ArrayList<String>(5);
            if (name.startsWith("SSL_") && !includeSSLSuites) {
                nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_LEGACY_SSL_PROTOCOL.get());
            } else if (name.startsWith("TLS_") || name.startsWith("SSL_")) {
                if (name.startsWith("TLS_")) {
                    anyTLSSuitesFound = true;
                } else {
                    name = "TLS_" + name.substring(4);
                }
                if (!(name.startsWith("TLS_AES_") || name.startsWith("TLS_CHACHA20_") || name.startsWith("TLS_ECDHE_") || name.startsWith("TLS_DHE_"))) {
                    if (name.startsWith("TLS_RSA_")) {
                        if (!ALLOW_RSA_KEY_EXCHANGE.get()) {
                            nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_NON_RECOMMENDED_KNOWN_KE_ALG.get("RSA"));
                        }
                    } else if (name.startsWith("TLS_ECDH_")) {
                        nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_NON_RECOMMENDED_KNOWN_KE_ALG.get("ECDH"));
                    } else if (name.startsWith("TLS_DH_")) {
                        nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_NON_RECOMMENDED_KNOWN_KE_ALG.get("DH"));
                    } else if (name.startsWith("TLS_KRB5_")) {
                        nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_NON_RECOMMENDED_KNOWN_KE_ALG.get("KRB5"));
                    } else {
                        nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_NON_RECOMMENDED_UNKNOWN_KE_ALG.get());
                    }
                }
            } else {
                nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_UNRECOGNIZED_PROTOCOL.get());
            }
            if (name.contains("_PSK")) {
                nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_PSK.get());
            }
            if (name.contains("_NULL")) {
                nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_NULL_COMPONENT.get());
            }
            if (name.contains("_ANON")) {
                nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_ANON_AUTH.get());
            }
            if (name.contains("_EXPORT")) {
                nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_EXPORT_ENCRYPTION.get());
            }
            if (!name.contains("_AES") && !name.contains("_CHACHA20")) {
                if (name.contains("_RC4")) {
                    nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_NON_RECOMMENDED_KNOWN_BE_ALG.get("RC4"));
                } else if (name.contains("_3DES")) {
                    nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_NON_RECOMMENDED_KNOWN_BE_ALG.get("3DES"));
                } else if (name.contains("_DES")) {
                    nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_NON_RECOMMENDED_KNOWN_BE_ALG.get("DES"));
                } else if (name.contains("_IDEA")) {
                    nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_NON_RECOMMENDED_KNOWN_BE_ALG.get("IDEA"));
                } else if (name.contains("_CAMELLIA")) {
                    nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_NON_RECOMMENDED_KNOWN_BE_ALG.get("Camellia"));
                } else if (name.contains("_ARIA")) {
                    nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_NON_RECOMMENDED_KNOWN_BE_ALG.get("ARIA"));
                } else {
                    nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_NON_RECOMMENDED_UNKNOWN_BE_ALG.get());
                }
            }
            if (!(name.endsWith("_SHA512") || name.endsWith("_SHA384") || name.endsWith("_SHA256"))) {
                if (name.endsWith("_SHA")) {
                    if (!ALLOW_SHA_1.get()) {
                        nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_NON_RECOMMENDED_KNOWN_DIGEST_ALG.get("SHA-1"));
                    }
                } else if (name.endsWith("_MD5")) {
                    nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_NON_RECOMMENDED_KNOWN_DIGEST_ALG.get("MD5"));
                } else {
                    nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_NON_RECOMMENDED_UNKNOWN_DIGEST_ALG.get());
                }
            }
            if (nonRecommendedReasons.isEmpty()) {
                recommendedSet.add(cipherSuiteName);
                continue;
            }
            nonRecommendedMap.put(cipherSuiteName, Collections.unmodifiableList(nonRecommendedReasons));
        }
        if (recommendedSet.isEmpty() && !anyTLSSuitesFound && !includeSSLSuites) {
            return TLSCipherSuiteSelector.selectCipherSuites(cipherSuiteArray, true);
        }
        return new ObjectPair<SortedSet<String>, SortedMap<String, List<String>>>(recommendedSet, nonRecommendedMap);
    }

    @Override
    @NotNull
    public String getToolName() {
        return "tls-cipher-suite-selector";
    }

    @Override
    @NotNull
    public String getToolDescription() {
        return SSLMessages.INFO_TLS_CIPHER_SUITE_SELECTOR_TOOL_DESC.get();
    }

    @Override
    @NotNull
    public String getToolVersion() {
        return "6.0.3";
    }

    @Override
    public void addToolArguments(@NotNull ArgumentParser parser) throws ArgumentException {
    }

    @Override
    @NotNull
    public ResultCode doToolProcessing() {
        this.generateOutput(this.getOut());
        return ResultCode.SUCCESS;
    }

    private void generateOutput(@NotNull PrintStream s) {
        try {
            SSLContext sslContext = CryptoHelper.getDefaultSSLContext();
            s.println("Supported TLS Protocols:");
            for (String protocol : sslContext.getSupportedSSLParameters().getProtocols()) {
                s.println("* " + protocol);
            }
            s.println();
            s.println("Enabled TLS Protocols:");
            for (String protocol : SSLUtil.getEnabledSSLProtocols()) {
                s.println("* " + protocol);
            }
            s.println();
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        s.println("Supported TLS Cipher Suites:");
        for (String string : this.supportedCipherSuites) {
            s.println("* " + string);
        }
        s.println();
        s.println("JVM-Default TLS Cipher Suites:");
        for (String string : this.defaultCipherSuites) {
            s.println("* " + string);
        }
        s.println();
        s.println("Non-Recommended TLS Cipher Suites:");
        for (Map.Entry entry : this.nonRecommendedCipherSuites.entrySet()) {
            s.println("* " + (String)entry.getKey());
            for (String reason : (List)entry.getValue()) {
                s.println("  - " + reason);
            }
        }
        s.println();
        s.println("Recommended TLS Cipher Suites:");
        for (String string : this.recommendedCipherSuites) {
            s.println("* " + string);
        }
    }

    @NotNull
    public static Set<String> selectSupportedCipherSuites(@Nullable Collection<String> potentialSuiteNames) {
        if (potentialSuiteNames == null) {
            return Collections.emptySet();
        }
        TLSCipherSuiteSelector instance = TLSCipherSuiteSelector.getStaticInstance();
        int capacity = StaticUtils.computeMapCapacity(instance.supportedCipherSuites.size());
        HashMap<String, String> supportedMap = new HashMap<String, String>(capacity);
        for (String supportedSuite : instance.supportedCipherSuites) {
            supportedMap.put(StaticUtils.toUpperCase(supportedSuite).replace('-', '_'), supportedSuite);
        }
        LinkedHashSet<String> selectedSet = new LinkedHashSet<String>(capacity);
        for (String potentialSuite : potentialSuiteNames) {
            String supportedName = (String)supportedMap.get(StaticUtils.toUpperCase(potentialSuite).replace('-', '_'));
            if (supportedName == null) continue;
            selectedSet.add(supportedName);
        }
        return Collections.unmodifiableSet(selectedSet);
    }

    public static boolean allowRSAKeyExchange() {
        return ALLOW_RSA_KEY_EXCHANGE.get();
    }

    public static void setAllowRSAKeyExchange(boolean allowRSAKeyExchange) {
        ALLOW_RSA_KEY_EXCHANGE.set(allowRSAKeyExchange);
        TLSCipherSuiteSelector.recompute();
    }

    public static boolean allowSHA1() {
        return ALLOW_SHA_1.get();
    }

    public static void setAllowSHA1(boolean allowSHA1) {
        ALLOW_SHA_1.set(allowSHA1);
        TLSCipherSuiteSelector.recompute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private static TLSCipherSuiteSelector getStaticInstance() {
        TLSCipherSuiteSelector instance = STATIC_INSTANCE.get();
        if (instance != null) return instance;
        Class<TLSCipherSuiteSelector> clazz = TLSCipherSuiteSelector.class;
        synchronized (TLSCipherSuiteSelector.class) {
            STATIC_INSTANCE.compareAndSet(null, new TLSCipherSuiteSelector(null, null, false));
            return STATIC_INSTANCE.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recompute() {
        Class<TLSCipherSuiteSelector> clazz = TLSCipherSuiteSelector.class;
        synchronized (TLSCipherSuiteSelector.class) {
            STATIC_INSTANCE.set(null);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static boolean jvmSSLDebuggingEnabled() {
        return TLSCipherSuiteSelector.getStaticInstance().jvmSSLDebuggingEnabled;
    }

    static {
        String allowRSAPropertyValue = StaticUtils.getSystemProperty(PROPERTY_ALLOW_RSA_KEY_EXCHANGE);
        boolean allowRSA = allowRSAPropertyValue != null ? allowRSAPropertyValue.equalsIgnoreCase("true") : false;
        String allowSHA1PropertyValue = StaticUtils.getSystemProperty(PROPERTY_ALLOW_SHA_1);
        boolean allowSHA1 = allowSHA1PropertyValue != null ? allowSHA1PropertyValue.equalsIgnoreCase("true") : false;
        ALLOW_RSA_KEY_EXCHANGE.set(allowRSA);
        ALLOW_SHA_1.set(allowSHA1);
    }
}

