/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.api;

import java.util.EnumSet;
import java.util.Objects;
import org.apache.james.imap.api.ImapSessionState;

public class ImapCommand {
    private final Validity validity;
    private final String name;

    public static ImapCommand nonAuthenticatedStateCommand(String name) {
        return new ImapCommand(Validity.NonAuthenticated, name);
    }

    public static ImapCommand authenticatedStateCommand(String name) {
        return new ImapCommand(Validity.Authenticated, name);
    }

    public static ImapCommand selectedStateCommand(String name) {
        return new ImapCommand(Validity.Selected, name);
    }

    public static ImapCommand anyStateCommand(String name) {
        return new ImapCommand(Validity.Any, name);
    }

    private ImapCommand(Validity validity, String name) {
        this.validity = validity;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean validForState(ImapSessionState state) {
        return this.validity.allowed(state);
    }

    public String toString() {
        return this.name;
    }

    public final boolean equals(Object o) {
        if (o instanceof ImapCommand) {
            ImapCommand that = (ImapCommand)o;
            return Objects.equals(this.name, that.name);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.name);
    }

    static enum Validity {
        NonAuthenticated(EnumSet.of(ImapSessionState.NON_AUTHENTICATED)),
        Authenticated(EnumSet.of(ImapSessionState.AUTHENTICATED, ImapSessionState.SELECTED)),
        Selected(EnumSet.of(ImapSessionState.SELECTED)),
        Any(EnumSet.of(ImapSessionState.AUTHENTICATED, ImapSessionState.NON_AUTHENTICATED, ImapSessionState.SELECTED));

        private final EnumSet<ImapSessionState> validStates;

        private Validity(EnumSet<ImapSessionState> validStates) {
            this.validStates = validStates;
        }

        boolean allowed(ImapSessionState sessionState) {
            return this.validStates.contains((Object)sessionState);
        }
    }
}

