/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.james.imap.message.Literal;

public class BytesBackedLiteral
implements Literal {
    private final byte[] content;

    public static BytesBackedLiteral copy(InputStream stream) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        stream.transferTo(out);
        return BytesBackedLiteral.of(out.toByteArray());
    }

    public static BytesBackedLiteral of(byte[] bytes) {
        return new BytesBackedLiteral(bytes);
    }

    private BytesBackedLiteral(byte[] content) {
        this.content = content;
    }

    @Override
    public long size() {
        return this.content.length;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.content);
    }
}

