/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.MailboxType;
import org.apache.james.imap.api.process.MailboxTyper;
import org.apache.james.imap.message.request.XListRequest;
import org.apache.james.imap.message.response.XListResponse;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.imap.processor.ListProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.metrics.api.MetricFactory;

public class XListProcessor
extends ListProcessor
implements CapabilityImplementingProcessor {
    private static final List<Capability> XLIST_CAPS = ImmutableList.of((Object)ImapConstants.SUPPORTS_XLIST);
    private final MailboxTyper mailboxTyper;

    public XListProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MailboxTyper mailboxTyper, MetricFactory metricFactory) {
        super(next, mailboxManager, factory, metricFactory);
        this.mailboxTyper = mailboxTyper;
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        if (this.mailboxTyper == null) {
            return Collections.emptyList();
        }
        return XLIST_CAPS;
    }

    @Override
    protected boolean isAcceptable(ImapMessage message) {
        return message instanceof XListRequest;
    }

    @Override
    protected ImapResponseMessage createResponse(MailboxMetaData.Children children, MailboxMetaData.Selectability selectability, String name, char hierarchyDelimiter, MailboxType type) {
        return new XListResponse(children, selectability, name, hierarchyDelimiter, type);
    }

    @Override
    protected MailboxType getMailboxType(ImapSession session, MailboxPath path) {
        return this.mailboxTyper.getMailboxType(session, path);
    }
}

