/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.ldap.listener.ListenerMessages;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.NameResolver;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Base64;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadLocalSecureRandom;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.cert.CertException;
import com.unboundid.util.ssl.cert.ManageCertificates;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class SelfSignedCertificateGenerator {
    private SelfSignedCertificateGenerator() {
    }

    @NotNull
    public static ObjectPair<File, char[]> generateTemporarySelfSignedCertificate(@NotNull String toolName, @NotNull String keyStoreType) throws CertException {
        File keyStoreFile;
        try {
            keyStoreFile = File.createTempFile("temp-keystore-", ".jks");
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(ListenerMessages.ERR_SELF_SIGNED_CERT_GENERATOR_CANNOT_CREATE_FILE.get(StaticUtils.getExceptionMessage(e)), e);
        }
        keyStoreFile.delete();
        byte[] randomBytes = new byte[50];
        ThreadLocalSecureRandom.get().nextBytes(randomBytes);
        String keyStorePIN = Base64.encode(randomBytes);
        SelfSignedCertificateGenerator.generateSelfSignedCertificate(toolName, keyStoreFile, keyStorePIN, keyStoreType, "server-cert");
        return new ObjectPair<File, char[]>(keyStoreFile, keyStorePIN.toCharArray());
    }

    public static void generateSelfSignedCertificate(@NotNull String toolName, @NotNull File keyStoreFile, @NotNull String keyStorePIN, @NotNull String keyStoreType, @NotNull String alias) throws CertException {
        NameResolver nameResolver = LDAPConnectionOptions.DEFAULT_NAME_RESOLVER;
        Set<InetAddress> localAddresses = StaticUtils.getAllLocalAddresses(nameResolver, false);
        if (localAddresses.isEmpty()) {
            localAddresses = StaticUtils.getAllLocalAddresses(nameResolver, true);
        }
        Set<String> canonicalHostNames = StaticUtils.getAvailableCanonicalHostNames(nameResolver, localAddresses);
        DN subjectDN = localAddresses.isEmpty() ? new DN(new RDN("CN", toolName)) : new DN(new RDN("CN", nameResolver.getCanonicalHostName(localAddresses.iterator().next())), new RDN("OU", toolName));
        long oneDayAgoTime = System.currentTimeMillis() - 86400000L;
        Date oneDayAgoDate = new Date(oneDayAgoTime);
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMddHHmmss");
        String yesterdayTimeStamp = dateFormatter.format(oneDayAgoDate);
        ArrayList<String> argList = new ArrayList<String>(30);
        argList.add("generate-self-signed-certificate");
        argList.add("--keystore");
        argList.add(keyStoreFile.getAbsolutePath());
        argList.add("--keystore-password");
        argList.add(keyStorePIN);
        argList.add("--keystore-type");
        argList.add(keyStoreType);
        argList.add("--alias");
        argList.add(alias);
        argList.add("--subject-dn");
        argList.add(subjectDN.toString());
        argList.add("--days-valid");
        argList.add("366");
        argList.add("--validityStartTime");
        argList.add(yesterdayTimeStamp);
        argList.add("--key-algorithm");
        argList.add("RSA");
        argList.add("--key-size-bits");
        argList.add("2048");
        argList.add("--signature-algorithm");
        argList.add("SHA256withRSA");
        for (String hostName : canonicalHostNames) {
            argList.add("--subject-alternative-name-dns");
            argList.add(hostName);
        }
        for (InetAddress address : localAddresses) {
            argList.add("--subject-alternative-name-ip-address");
            argList.add(StaticUtils.trimInterfaceNameFromHostAddress(address.getHostAddress()));
        }
        argList.add("--key-usage");
        argList.add("digitalSignature");
        argList.add("--key-usage");
        argList.add("keyEncipherment");
        argList.add("--extended-key-usage");
        argList.add("server-auth");
        argList.add("--extended-key-usage");
        argList.add("client-auth");
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ResultCode resultCode = ManageCertificates.main(null, output, output, argList.toArray(StaticUtils.NO_STRINGS));
        if (resultCode != ResultCode.SUCCESS) {
            throw new CertException(ListenerMessages.ERR_SELF_SIGNED_CERT_GENERATOR_ERROR_GENERATING_CERT.get(StaticUtils.toUTF8String(output.toByteArray())));
        }
    }
}

