/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeUtils;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;

public class SMTPAuthUserIs
extends GenericMatcher {
    private Collection<String> users;

    public void init() throws MessagingException {
        StringTokenizer st = new StringTokenizer(this.getCondition(), ", \t", false);
        this.users = new HashSet<String>();
        while (st.hasMoreTokens()) {
            this.users.add(st.nextToken());
        }
    }

    public Collection<MailAddress> match(Mail mail) {
        return AttributeUtils.getValueAndCastFromMail((Mail)mail, (AttributeName)Mail.SMTP_AUTH_USER, String.class).filter(this.users::contains).map(ignored -> mail.getRecipients()).orElse(null);
    }
}

