/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import java.util.ArrayList;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.mailbox.Authenticator;
import org.apache.james.mailbox.Authorizator;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MailboxSessionIdGenerator;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.exception.BadCredentialsException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.NotAdminException;
import org.apache.james.mailbox.exception.UserDoesNotExistException;
import org.apache.james.mailbox.store.RandomMailboxSessionIdGenerator;

public class SessionProviderImpl
implements SessionProvider {
    private final MailboxSessionIdGenerator idGenerator = new RandomMailboxSessionIdGenerator();
    private final Authenticator authenticator;
    private final Authorizator authorizator;

    @Inject
    public SessionProviderImpl(Authenticator authenticator, Authorizator authorizator) {
        this.authenticator = authenticator;
        this.authorizator = authorizator;
    }

    public char getDelimiter() {
        return '.';
    }

    public MailboxSession createSystemSession(Username userName) {
        return this.createSession(userName, MailboxSession.SessionType.System);
    }

    public MailboxSession login(Username userid, String passwd) throws MailboxException {
        if (this.isValidLogin(userid, passwd)) {
            return this.createSession(userid, MailboxSession.SessionType.User);
        }
        throw new BadCredentialsException();
    }

    public MailboxSession loginAsOtherUser(Username adminUserid, String passwd, Username otherUserId) throws MailboxException {
        if (!this.isValidLogin(adminUserid, passwd)) {
            throw new BadCredentialsException();
        }
        Authorizator.AuthorizationState authorizationState = this.authorizator.canLoginAsOtherUser(adminUserid, otherUserId);
        switch (authorizationState) {
            case ALLOWED: {
                return this.createSystemSession(otherUserId);
            }
            case NOT_ADMIN: {
                throw new NotAdminException();
            }
            case UNKNOWN_USER: {
                throw new UserDoesNotExistException(otherUserId);
            }
        }
        throw new RuntimeException("Unknown AuthorizationState " + authorizationState);
    }

    public void logout(MailboxSession session) {
        if (session != null) {
            session.close();
        }
    }

    private MailboxSession createSession(Username userName, MailboxSession.SessionType type) {
        return new MailboxSession(this.newSessionId(), userName, new ArrayList(), this.getDelimiter(), type);
    }

    private MailboxSession.SessionId newSessionId() {
        return MailboxSession.SessionId.of((long)this.randomId());
    }

    private long randomId() {
        return this.idGenerator.nextId();
    }

    private boolean isValidLogin(Username userid, String passwd) throws MailboxException {
        return this.authenticator.isAuthentic(userid, (CharSequence)passwd);
    }
}

