/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.CRAMMD5BindRequest;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DIGESTMD5BindRequest;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.EXTERNALBindRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.InternalSDKHelper;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.PLAINBindRequest;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.extensions.StartTLSExtendedRequest;
import com.unboundid.ldap.sdk.unboundidds.LDAPConnectionHandlerConfiguration;
import com.unboundid.util.CommandLineTool;
import com.unboundid.util.Debug;
import com.unboundid.util.ExampleCommandLineArgument;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.LDAPCommandLineTool;
import com.unboundid.util.MultiServerLDAPCommandLineTool;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.PasswordReader;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentHelper;
import com.unboundid.util.args.ArgumentListArgument;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.BooleanValueArgument;
import com.unboundid.util.args.ControlArgument;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.DurationArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.FilterArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.ScopeArgument;
import com.unboundid.util.args.StringArgument;
import com.unboundid.util.args.SubCommand;
import com.unboundid.util.args.TimestampArgument;
import com.unboundid.util.ssl.KeyStoreKeyManager;
import com.unboundid.util.ssl.SSLUtil;
import com.unboundid.util.ssl.TrustAllTrustManager;
import com.unboundid.util.ssl.TrustStoreTrustManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.net.ssl.X509TrustManager;

@InternalUseOnly
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
final class CommandLineToolInteractiveModeProcessor {
    private static volatile boolean IN_UNIT_TEST = false;
    @NotNull
    private final ArgumentParser parser;
    @NotNull
    private final BufferedReader systemInReader;
    @NotNull
    private final CommandLineTool tool;
    private final int wrapColumn;

    CommandLineToolInteractiveModeProcessor(@NotNull CommandLineTool tool, @NotNull ArgumentParser parser) {
        this.tool = tool;
        this.parser = parser;
        this.systemInReader = new BufferedReader(new InputStreamReader(System.in));
        this.wrapColumn = StaticUtils.TERMINAL_WIDTH_COLUMNS - 1;
        ArgumentHelper.reset(parser.getNamedArgument("interactive"));
    }

    void doInteractiveModeProcessing() throws LDAPException {
        this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_LAUNCHING.get(this.tool.getToolName()));
        ArrayList<String> allArgs = new ArrayList<String>(10);
        List<SubCommand> subCommands = this.parser.getSubCommands();
        if (!subCommands.isEmpty()) {
            SubCommand subcommand = this.promptForSubCommand();
            ArgumentHelper.setSelectedSubCommand(this.parser, subcommand);
            allArgs.add(subcommand.getPrimaryName());
        }
        ArrayList<String> ldapArgs = new ArrayList<String>(10);
        if (this.tool instanceof LDAPCommandLineTool) {
            this.promptForLDAPArguments(ldapArgs, true);
        } else if (this.tool instanceof MultiServerLDAPCommandLineTool) {
            this.promptForMultiServerLDAPArguments(ldapArgs, true);
        }
        allArgs.addAll(ldapArgs);
        List<String> toolArgs = this.displayInteractiveMenu(ldapArgs);
        allArgs.addAll(toolArgs);
        this.tool.out(new Object[0]);
        if (allArgs.isEmpty()) {
            this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_RUNNING_WITH_NO_ARGS.get(this.tool.getToolName()));
        } else {
            this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_RUNNING_WITH_ARGS.get());
            this.printArgs(allArgs);
        }
        this.tool.out(new Object[0]);
    }

    private void printArgs(@NotNull List<String> args) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("     ");
        buffer.append(this.tool.getToolName());
        if (!args.isEmpty()) {
            buffer.append(' ');
            buffer.append(StaticUtils.getCommandLineContinuationString());
        }
        this.tool.out(buffer);
        for (int i = 0; i < args.size(); ++i) {
            String nextArg;
            buffer.setLength(0);
            buffer.append("          ");
            String arg = args.get(i);
            buffer.append(ExampleCommandLineArgument.getCleanArgument(arg).getLocalForm());
            if (arg.startsWith("-") && i + 1 < args.size() && !(nextArg = args.get(i + 1)).startsWith("-")) {
                buffer.append(' ');
                buffer.append(ExampleCommandLineArgument.getCleanArgument(nextArg).getLocalForm());
                ++i;
            }
            if (i < args.size() - 1) {
                buffer.append(' ');
                buffer.append(StaticUtils.getCommandLineContinuationString());
            }
            this.tool.out(buffer);
        }
    }

    @NotNull
    private SubCommand promptForSubCommand() throws LDAPException {
        List<SubCommand> subCommands = this.parser.getSubCommands();
        TreeMap<String, SubCommand> subCommandsByName = new TreeMap<String, SubCommand>();
        for (SubCommand sc : subCommands) {
            subCommandsByName.put(sc.getPrimaryName(), sc);
        }
        int index = 0;
        String[] subCommandNames = new String[subCommandsByName.size()];
        for (SubCommand sc : subCommandsByName.values()) {
            subCommandNames[index++] = sc.getPrimaryName();
        }
        int selectedSubCommandNumber = this.getNumberedMenuChoice(UtilityMessages.INFO_INTERACTIVE_SUBCOMMAND_PROMPT.get(), false, null, subCommandNames);
        return this.parser.getSubCommand(subCommandNames[selectedSubCommandNumber]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void promptForLDAPArguments(@NotNull List<String> argList, boolean test) throws LDAPException {
        block111: {
            int defaultPort;
            IntegerArgument portArgument;
            boolean defaultTrust;
            boolean useStartTLS;
            boolean useSSL;
            LDAPConnectionHandlerConfiguration cfg;
            File configFile;
            LDAPCommandLineTool ldapTool = (LDAPCommandLineTool)this.tool;
            argList.clear();
            StringArgument hostnameArgument = this.parser.getStringArgument("hostname");
            String defaultHostname = hostnameArgument.isPresent() ? hostnameArgument.getValue() : "localhost";
            ArgumentHelper.reset(hostnameArgument);
            String hostname = this.promptForString(UtilityMessages.INFO_INTERACTIVE_LDAP_PROMPT_HOST.get(), defaultHostname, true);
            ArgumentHelper.addValueSuppressException(hostnameArgument, hostname);
            argList.add("--hostname");
            argList.add(hostname);
            List<LDAPConnectionHandlerConfiguration> serverListenerConfigs = null;
            File dsInstanceRoot = InternalSDKHelper.getPingIdentityServerRoot();
            if (dsInstanceRoot != null && (configFile = StaticUtils.constructPath(dsInstanceRoot, "config", "config.ldif")).exists() && configFile.isFile()) {
                try {
                    serverListenerConfigs = LDAPConnectionHandlerConfiguration.readConfiguration(configFile, true);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
            BooleanArgument useSSLArgument = this.parser.getBooleanArgument("useSSL");
            BooleanArgument useStartTLSArgument = this.parser.getBooleanArgument("useStartTLS");
            String defaultSecurityChoice = useSSLArgument.isPresent() ? "1" : (useStartTLSArgument.isPresent() ? "3" : (serverListenerConfigs != null && !serverListenerConfigs.isEmpty() ? ((cfg = serverListenerConfigs.get(0)).usesSSL() ? "1" : (cfg.supportsStartTLS() ? "3" : "5")) : "1"));
            ArgumentHelper.reset(useSSLArgument);
            ArgumentHelper.reset(useStartTLSArgument);
            int securityType = this.getNumberedMenuChoice(UtilityMessages.INFO_INTERACTIVE_LDAP_SECURITY_PROMPT.get(), false, defaultSecurityChoice, UtilityMessages.INFO_INTERACTIVE_LDAP_SECURITY_OPTION_SSL_DEFAULT.get(), UtilityMessages.INFO_INTERACTIVE_LDAP_SECURITY_OPTION_SSL_MANUAL.get(), UtilityMessages.INFO_INTERACTIVE_LDAP_SECURITY_OPTION_START_TLS_DEFAULT.get(), UtilityMessages.INFO_INTERACTIVE_LDAP_SECURITY_OPTION_START_TLS_MANUAL.get(), UtilityMessages.INFO_INTERACTIVE_LDAP_SECURITY_OPTION_NONE.get());
            switch (securityType) {
                case 0: {
                    useSSL = true;
                    useStartTLS = false;
                    defaultTrust = true;
                    argList.add("--useSSL");
                    ArgumentHelper.incrementOccurrencesSuppressException(useSSLArgument);
                    break;
                }
                case 1: {
                    useSSL = true;
                    useStartTLS = false;
                    defaultTrust = false;
                    argList.add("--useSSL");
                    ArgumentHelper.incrementOccurrencesSuppressException(useSSLArgument);
                    break;
                }
                case 2: {
                    useSSL = false;
                    useStartTLS = true;
                    defaultTrust = true;
                    argList.add("--useStartTLS");
                    ArgumentHelper.incrementOccurrencesSuppressException(useStartTLSArgument);
                    break;
                }
                case 3: {
                    useSSL = false;
                    useStartTLS = true;
                    defaultTrust = false;
                    argList.add("--useStartTLS");
                    ArgumentHelper.incrementOccurrencesSuppressException(useStartTLSArgument);
                    break;
                }
                default: {
                    useSSL = false;
                    useStartTLS = false;
                    defaultTrust = false;
                }
            }
            BindRequest bindRequest = null;
            boolean trustAll = false;
            byte[] keyStorePIN = null;
            byte[] trustStorePIN = null;
            File keyStorePath = null;
            File trustStorePath = null;
            String certificateNickname = null;
            String keyStoreFormat = null;
            String trustStoreFormat = null;
            StringArgument keyStorePasswordArgument = this.parser.getStringArgument("keyStorePassword");
            StringArgument trustStorePasswordArgument = this.parser.getStringArgument("trustStorePassword");
            StringArgument saslOptionArgument = this.parser.getStringArgument("saslOption");
            if (!defaultTrust) {
                ArgumentHelper.reset(keyStorePasswordArgument);
                ArgumentHelper.reset(trustStorePasswordArgument);
                ArgumentHelper.reset(this.parser.getNamedArgument("keyStorePasswordFile"));
                ArgumentHelper.reset(this.parser.getNamedArgument("promptForKeyStorePassword"));
                ArgumentHelper.reset(this.parser.getNamedArgument("trustStorePasswordFile"));
                ArgumentHelper.reset(this.parser.getNamedArgument("promptForTrustStorePassword"));
                if (useSSL || useStartTLS) {
                    String format;
                    String format2;
                    StringArgument keyStorePathArgument = this.parser.getStringArgument("keyStorePath");
                    StringArgument keyStoreFormatArgument = this.parser.getStringArgument("keyStoreFormat");
                    String defaultStoreTypeChoice = keyStoreFormatArgument.isPresent() ? ((format2 = keyStoreFormatArgument.getValue()).equalsIgnoreCase("PKCS12") ? "3" : "2") : (keyStorePathArgument.isPresent() ? "2" : "1");
                    String defaultKeyStorePath = keyStorePathArgument.isPresent() ? keyStorePathArgument.getValue() : null;
                    StringArgument certNicknameArgument = this.parser.getStringArgument("certNickname");
                    String defaultCertNickname = certNicknameArgument.isPresent() ? certNicknameArgument.getValue() : null;
                    ArgumentHelper.reset(keyStorePathArgument);
                    ArgumentHelper.reset(keyStoreFormatArgument);
                    ArgumentHelper.reset(certNicknameArgument);
                    int keystoreType = this.getNumberedMenuChoice(UtilityMessages.INFO_INTERACTIVE_LDAP_CLIENT_CERT_PROMPT.get(), false, defaultStoreTypeChoice, UtilityMessages.INFO_INTERACTIVE_LDAP_CLIENT_CERT_OPTION_NO.get(), UtilityMessages.INFO_INTERACTIVE_LDAP_CLIENT_CERT_OPTION_JKS.get(), UtilityMessages.INFO_INTERACTIVE_LDAP_CLIENT_CERT_OPTION_PKCS12.get());
                    ArgumentHelper.reset(keyStoreFormatArgument);
                    switch (keystoreType) {
                        case 1: {
                            keyStoreFormat = "JKS";
                            break;
                        }
                        case 2: {
                            keyStoreFormat = "PKCS12";
                            break;
                        }
                    }
                    if (keyStoreFormat != null) {
                        ArgumentHelper.addValueSuppressException(keyStoreFormatArgument, keyStoreFormat);
                        keyStorePath = this.promptForPath(UtilityMessages.INFO_INTERACTIVE_LDAP_KEYSTORE_PATH_PROMPT.get(), defaultKeyStorePath, true, true, true, true, false);
                        argList.add("--keyStorePath");
                        argList.add(keyStorePath.getAbsolutePath());
                        ArgumentHelper.addValueSuppressException(keyStorePathArgument, keyStorePath.getAbsolutePath());
                        keyStorePIN = this.promptForPassword(UtilityMessages.INFO_INTERACTIVE_LDAP_KEYSTORE_PIN_PROMPT.get(), null, false);
                        if (keyStorePIN != null) {
                            argList.add("--keyStorePassword");
                            argList.add("***REDACTED***");
                            ArgumentHelper.addValueSuppressException(keyStorePasswordArgument, StaticUtils.toUTF8String(keyStorePIN));
                        }
                        argList.add("--keyStoreFormat");
                        argList.add(keyStoreFormat);
                        certificateNickname = this.promptForString(UtilityMessages.INFO_INTERACTIVE_LDAP_CERT_NICKNAME_PROMPT.get(), defaultCertNickname, false);
                        if (certificateNickname != null) {
                            argList.add("--certNickname");
                            argList.add(certificateNickname);
                            ArgumentHelper.addValueSuppressException(certNicknameArgument, certificateNickname);
                        }
                        if (ldapTool.supportsAuthentication() && this.promptForYesNo(UtilityMessages.INFO_INTERACTIVE_LDAP_CERT_AUTH_PROMPT.get(), false, true).booleanValue()) {
                            bindRequest = new EXTERNALBindRequest();
                            argList.add("--saslOption");
                            argList.add("mech=EXTERNAL");
                            ArgumentHelper.reset(saslOptionArgument);
                            ArgumentHelper.addValueSuppressException(saslOptionArgument, "mech=EXTERNAL");
                        }
                    }
                    BooleanArgument trustAllArgument = this.parser.getBooleanArgument("trustAll");
                    StringArgument trustStorePathArgument = this.parser.getStringArgument("trustStorePath");
                    StringArgument trustStoreFormatArgument = this.parser.getStringArgument("trustStoreFormat");
                    String defaultTrustTypeChoice = trustAllArgument.isPresent() ? "4" : (trustStoreFormatArgument.isPresent() ? ((format = trustStoreFormatArgument.getValue()).equalsIgnoreCase("PKCS12") ? "3" : "2") : (trustStorePathArgument.isPresent() ? "2" : "1"));
                    String defaultTrustStorePath = trustStorePathArgument.isPresent() ? trustStorePathArgument.getValue() : null;
                    ArgumentHelper.reset(trustAllArgument);
                    ArgumentHelper.reset(trustStorePathArgument);
                    ArgumentHelper.reset(trustStoreFormatArgument);
                    int trustType = this.getNumberedMenuChoice(UtilityMessages.INFO_INTERACTIVE_LDAP_TRUST_PROMPT.get(), false, defaultTrustTypeChoice, UtilityMessages.INFO_INTERACTIVE_LDAP_TRUST_OPTION_PROMPT.get(), UtilityMessages.INFO_INTERACTIVE_LDAP_TRUST_OPTION_JKS.get(), UtilityMessages.INFO_INTERACTIVE_LDAP_TRUST_OPTION_PKCS12.get(), UtilityMessages.INFO_INTERACTIVE_LDAP_TRUST_OPTION_BLIND.get());
                    switch (trustType) {
                        case 1: {
                            trustStoreFormat = "JKS";
                            break;
                        }
                        case 2: {
                            trustStoreFormat = "PKCS12";
                            break;
                        }
                        case 3: {
                            trustAll = true;
                            argList.add("--trustAll");
                            ArgumentHelper.incrementOccurrencesSuppressException(trustAllArgument);
                            break;
                        }
                        default: {
                            ArgumentHelper.incrementOccurrencesSuppressException(trustAllArgument);
                        }
                    }
                    if (trustStoreFormat != null) {
                        ArgumentHelper.addValueSuppressException(trustStoreFormatArgument, trustStoreFormat);
                        trustStorePath = this.promptForPath(UtilityMessages.INFO_INTERACTIVE_LDAP_TRUSTSTORE_PATH_PROMPT.get(), defaultTrustStorePath, true, true, true, true, false);
                        argList.add("--trustStorePath");
                        argList.add(trustStorePath.getAbsolutePath());
                        ArgumentHelper.addValueSuppressException(trustStorePathArgument, trustStorePath.getAbsolutePath());
                        trustStorePIN = this.promptForPassword(UtilityMessages.INFO_INTERACTIVE_LDAP_TRUSTSTORE_PIN_PROMPT.get(), null, false);
                        if (trustStorePIN != null) {
                            argList.add("--trustStorePassword");
                            argList.add("***REDACTED***");
                            ArgumentHelper.addValueSuppressException(trustStorePasswordArgument, StaticUtils.toUTF8String(trustStorePIN));
                        }
                        argList.add("--trustStoreFormat");
                        argList.add(trustStoreFormat);
                    }
                } else {
                    ArgumentHelper.reset(this.parser.getNamedArgument("keyStorePath"));
                    ArgumentHelper.reset(this.parser.getNamedArgument("keyStoreFormat"));
                    ArgumentHelper.reset(this.parser.getNamedArgument("trustStorePath"));
                    ArgumentHelper.reset(this.parser.getNamedArgument("trustStoreFormat"));
                    ArgumentHelper.reset(this.parser.getNamedArgument("certNickname"));
                }
            }
            if ((portArgument = this.parser.getIntegerArgument("port")).getNumOccurrences() > 0) {
                defaultPort = portArgument.getValue();
            } else if (useSSL) {
                defaultPort = 636;
                if (serverListenerConfigs != null) {
                    for (LDAPConnectionHandlerConfiguration cfg2 : serverListenerConfigs) {
                        if (!cfg2.usesSSL()) continue;
                        defaultPort = cfg2.getPort();
                        break;
                    }
                }
            } else if (useStartTLS) {
                defaultPort = 389;
                if (serverListenerConfigs != null) {
                    for (LDAPConnectionHandlerConfiguration cfg2 : serverListenerConfigs) {
                        if (!cfg2.supportsStartTLS()) continue;
                        defaultPort = cfg2.getPort();
                        break;
                    }
                }
            } else {
                defaultPort = 389;
                if (serverListenerConfigs != null) {
                    for (LDAPConnectionHandlerConfiguration cfg2 : serverListenerConfigs) {
                        if (cfg2.usesSSL()) continue;
                        defaultPort = cfg2.getPort();
                        break;
                    }
                }
            }
            ArgumentHelper.reset(portArgument);
            int port = this.promptForInteger(UtilityMessages.INFO_INTERACTIVE_LDAP_PROMPT_PORT.get(), defaultPort, 1, 65535, true);
            argList.add("--port");
            argList.add(String.valueOf(port));
            ArgumentHelper.addValueSuppressException(portArgument, String.valueOf(port));
            if (ldapTool.supportsAuthentication()) {
                DNArgument bindDNArgument = this.parser.getDNArgument("bindDN");
                StringArgument bindPasswordArgument = this.parser.getStringArgument("bindPassword");
                ArgumentHelper.reset(bindPasswordArgument);
                ArgumentHelper.reset(this.parser.getNamedArgument("bindPasswordFile"));
                ArgumentHelper.reset(this.parser.getNamedArgument("promptForBindPassword"));
                if (bindRequest == null) {
                    String defaultBindDN;
                    String defaultAuthTypeChoice;
                    if (saslOptionArgument.isPresent()) {
                        defaultAuthTypeChoice = "2";
                        defaultBindDN = null;
                    } else {
                        defaultAuthTypeChoice = "1";
                        defaultBindDN = bindDNArgument.isPresent() ? bindDNArgument.getStringValue() : null;
                    }
                    ArgumentHelper.reset(bindDNArgument);
                    boolean useSimpleAuth = false;
                    boolean useSASLAuth = false;
                    int authMethod = this.getNumberedMenuChoice(UtilityMessages.INFO_INTERACTIVE_LDAP_AUTH_PROMPT.get(), false, defaultAuthTypeChoice, UtilityMessages.INFO_INTERACTIVE_LDAP_AUTH_OPTION_SIMPLE.get(), UtilityMessages.INFO_INTERACTIVE_LDAP_AUTH_OPTION_SASL.get(), UtilityMessages.INFO_INTERACTIVE_LDAP_AUTH_OPTION_NONE.get());
                    switch (authMethod) {
                        case 0: {
                            useSimpleAuth = true;
                            break;
                        }
                        case 1: {
                            useSASLAuth = true;
                            break;
                        }
                    }
                    if (useSimpleAuth) {
                        ArgumentHelper.reset(saslOptionArgument);
                        DN bindDN = this.promptForDN(UtilityMessages.INFO_INTERACTIVE_LDAP_AUTH_BIND_DN_PROMPT.get(), defaultBindDN, true);
                        if (bindDN.isNullDN()) {
                            bindRequest = new SimpleBindRequest();
                            argList.add("--bindDN");
                            argList.add("");
                            argList.add("--bindPassword");
                            argList.add("");
                            ArgumentHelper.addValueSuppressException(bindDNArgument, "");
                            ArgumentHelper.addValueSuppressException(bindPasswordArgument, "");
                        } else {
                            byte[] bindPassword = this.promptForPassword(UtilityMessages.INFO_INTERACTIVE_LDAP_AUTH_PW_PROMPT.get(), null, true);
                            bindRequest = new SimpleBindRequest(bindDN, bindPassword);
                            argList.add("--bindDN");
                            argList.add(bindDN.toString());
                            argList.add("--bindPassword");
                            argList.add("***REDACTED***");
                            ArgumentHelper.addValueSuppressException(bindDNArgument, bindDN.toString());
                            ArgumentHelper.addValueSuppressException(bindPasswordArgument, StaticUtils.toUTF8String(bindPassword));
                        }
                    } else if (useSASLAuth) {
                        String defaultMechChoice = null;
                        String defaultAuthID = null;
                        String defaultAuthzID = null;
                        String defaultRealm = null;
                        if (saslOptionArgument.isPresent()) {
                            for (String saslOption : saslOptionArgument.getValues()) {
                                String lowerOption = StaticUtils.toLowerCase(saslOption);
                                if (lowerOption.equals("mech=cram-md5")) {
                                    defaultMechChoice = "1";
                                    continue;
                                }
                                if (lowerOption.equals("mech=digest-md5")) {
                                    defaultMechChoice = "2";
                                    continue;
                                }
                                if (lowerOption.equals("mech=plain")) {
                                    defaultMechChoice = "3";
                                    continue;
                                }
                                if (lowerOption.startsWith("authid=")) {
                                    defaultAuthID = saslOption.substring(7);
                                    continue;
                                }
                                if (lowerOption.startsWith("authzid=")) {
                                    defaultAuthzID = saslOption.substring(8);
                                    continue;
                                }
                                if (!lowerOption.startsWith("realm=")) continue;
                                defaultRealm = saslOption.substring(6);
                            }
                        }
                        ArgumentHelper.reset(saslOptionArgument);
                        int mech = this.getNumberedMenuChoice(UtilityMessages.INFO_INTERACTIVE_LDAP_AUTH_SASL_PROMPT.get(), false, defaultMechChoice, UtilityMessages.INFO_INTERACTIVE_LDAP_SASL_OPTION_CRAM_MD5.get(), UtilityMessages.INFO_INTERACTIVE_LDAP_SASL_OPTION_DIGEST_MD5.get(), UtilityMessages.INFO_INTERACTIVE_LDAP_SASL_OPTION_PLAIN.get());
                        switch (mech) {
                            case 0: {
                                String authID = this.promptForString(UtilityMessages.INFO_INTERACTIVE_LDAP_AUTH_AUTHID_PROMPT.get(), defaultAuthID, true);
                                byte[] pw = this.promptForPassword(UtilityMessages.INFO_INTERACTIVE_LDAP_AUTH_PW_PROMPT.get(), null, true);
                                bindRequest = new CRAMMD5BindRequest(authID, pw);
                                argList.add("--saslOption");
                                argList.add("mech=CRAM-MD5");
                                argList.add("--saslOption");
                                argList.add("authID=" + authID);
                                argList.add("--bindPassword");
                                argList.add("***REDACTED***");
                                ArgumentHelper.addValueSuppressException(saslOptionArgument, "mech=CRAM-MD5");
                                ArgumentHelper.addValueSuppressException(saslOptionArgument, "authID=" + authID);
                                ArgumentHelper.addValueSuppressException(bindPasswordArgument, StaticUtils.toUTF8String(pw));
                                break;
                            }
                            case 1: {
                                String authID = this.promptForString(UtilityMessages.INFO_INTERACTIVE_LDAP_AUTH_AUTHID_PROMPT.get(), defaultAuthID, true);
                                String authzID = this.promptForString(UtilityMessages.INFO_INTERACTIVE_LDAP_AUTH_AUTHZID_PROMPT.get(), defaultAuthzID, false);
                                String realm = this.promptForString(UtilityMessages.INFO_INTERACTIVE_LDAP_AUTH_REALM_PROMPT.get(), defaultRealm, false);
                                byte[] pw = this.promptForPassword(UtilityMessages.INFO_INTERACTIVE_LDAP_AUTH_PW_PROMPT.get(), null, true);
                                bindRequest = new DIGESTMD5BindRequest(authID, authzID, pw, realm, new Control[0]);
                                argList.add("--saslOption");
                                argList.add("mech=DIGEST-MD5");
                                argList.add("--saslOption");
                                argList.add("authID=" + authID);
                                ArgumentHelper.addValueSuppressException(saslOptionArgument, "mech=DIGEST-MD5");
                                ArgumentHelper.addValueSuppressException(saslOptionArgument, "authID=" + authID);
                                if (authzID != null) {
                                    argList.add("--saslOption");
                                    argList.add("authzID=" + authzID);
                                    ArgumentHelper.addValueSuppressException(saslOptionArgument, "authzID=" + authzID);
                                }
                                if (realm != null) {
                                    argList.add("--saslOption");
                                    argList.add("realm=" + realm);
                                    ArgumentHelper.addValueSuppressException(saslOptionArgument, "realm=" + realm);
                                }
                                argList.add("--bindPassword");
                                argList.add("***REDACTED***");
                                ArgumentHelper.addValueSuppressException(bindPasswordArgument, StaticUtils.toUTF8String(pw));
                                break;
                            }
                            case 2: {
                                String authID = this.promptForString(UtilityMessages.INFO_INTERACTIVE_LDAP_AUTH_AUTHID_PROMPT.get(), defaultAuthID, true);
                                String authzID = this.promptForString(UtilityMessages.INFO_INTERACTIVE_LDAP_AUTH_AUTHZID_PROMPT.get(), defaultAuthzID, false);
                                byte[] pw = this.promptForPassword(UtilityMessages.INFO_INTERACTIVE_LDAP_AUTH_PW_PROMPT.get(), null, true);
                                bindRequest = new PLAINBindRequest(authID, authzID, pw);
                                argList.add("--saslOption");
                                argList.add("mech=PLAIN");
                                argList.add("--saslOption");
                                argList.add("authID=" + authID);
                                ArgumentHelper.addValueSuppressException(saslOptionArgument, "mech=PLAIN");
                                ArgumentHelper.addValueSuppressException(saslOptionArgument, "authID=" + authID);
                                if (authzID != null) {
                                    argList.add("--saslOption");
                                    argList.add("authzID=" + authzID);
                                    ArgumentHelper.addValueSuppressException(saslOptionArgument, "authzID=" + authzID);
                                }
                                argList.add("--bindPassword");
                                argList.add("***REDACTED***");
                                ArgumentHelper.addValueSuppressException(bindPasswordArgument, StaticUtils.toUTF8String(pw));
                            }
                        }
                    }
                } else {
                    ArgumentHelper.reset(bindDNArgument);
                }
            }
            if (test) {
                LDAPConnection conn;
                block110: {
                    SSLUtil sslUtil;
                    if (useSSL || useStartTLS) {
                        X509TrustManager trustManager;
                        KeyStoreKeyManager keyManager;
                        if (keyStorePath == null) {
                            keyManager = null;
                        } else {
                            char[] pinChars;
                            if (keyStorePIN == null) {
                                pinChars = null;
                            } else {
                                String pinString = StaticUtils.toUTF8String(keyStorePIN);
                                pinChars = pinString.toCharArray();
                            }
                            try {
                                keyManager = new KeyStoreKeyManager(keyStorePath, pinChars, keyStoreFormat, certificateNickname, true);
                            }
                            catch (Exception e) {
                                Debug.debugException(e);
                                this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_LDAP_CANNOT_CREATE_KEY_MANAGER.get(StaticUtils.getExceptionMessage(e)));
                                if (this.promptForYesNo(UtilityMessages.INFO_INTERACTIVE_LDAP_RETRY_PROMPT.get(), true, true).booleanValue()) {
                                    this.promptForLDAPArguments(argList, test);
                                    return;
                                }
                                throw new LDAPException(ResultCode.LOCAL_ERROR, "", e);
                            }
                        }
                        if (trustAll) {
                            trustManager = new TrustAllTrustManager();
                        } else if (trustStorePath == null) {
                            trustManager = InternalSDKHelper.getPreferredPromptTrustManagerChain(null);
                        } else {
                            char[] pinChars;
                            if (trustStorePIN == null) {
                                pinChars = null;
                            } else {
                                String pinString = StaticUtils.toUTF8String(trustStorePIN);
                                pinChars = pinString.toCharArray();
                            }
                            try {
                                trustManager = new TrustStoreTrustManager(trustStorePath, pinChars, trustStoreFormat, true);
                            }
                            catch (Exception e) {
                                Debug.debugException(e);
                                this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_LDAP_CANNOT_CREATE_TRUST_MANAGER.get(StaticUtils.getExceptionMessage(e)));
                                if (this.promptForYesNo(UtilityMessages.INFO_INTERACTIVE_LDAP_RETRY_PROMPT.get(), true, true).booleanValue()) {
                                    this.promptForLDAPArguments(argList, test);
                                    return;
                                }
                                throw new LDAPException(ResultCode.LOCAL_ERROR, "", e);
                            }
                        }
                        sslUtil = new SSLUtil(keyManager, trustManager);
                    } else {
                        sslUtil = null;
                    }
                    if (useSSL) {
                        try {
                            conn = new LDAPConnection(sslUtil.createSSLSocketFactory());
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                            this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_LDAP_CANNOT_CREATE_SOCKET_FACTORY.get(StaticUtils.getExceptionMessage(e)), e);
                            if (this.promptForYesNo(UtilityMessages.INFO_INTERACTIVE_LDAP_RETRY_PROMPT.get(), true, true).booleanValue()) {
                                this.promptForLDAPArguments(argList, test);
                                return;
                            }
                            throw new LDAPException(ResultCode.LOCAL_ERROR, "", e);
                        }
                    } else {
                        conn = new LDAPConnection();
                    }
                    try {
                        conn.connect(hostname, port);
                    }
                    catch (LDAPException le) {
                        Debug.debugException(le);
                        this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_LDAP_CANNOT_CONNECT.get(hostname, port, le.getResultString()));
                        if (this.promptForYesNo(UtilityMessages.INFO_INTERACTIVE_LDAP_RETRY_PROMPT.get(), true, true).booleanValue()) {
                            this.promptForLDAPArguments(argList, test);
                            conn.close();
                            return;
                        }
                        throw new LDAPException(le.getResultCode(), "", le);
                    }
                    if (!useStartTLS) break block110;
                    try {
                        ExtendedResult startTLSResult = conn.processExtendedOperation(new StartTLSExtendedRequest(sslUtil.createSSLContext()));
                        if (startTLSResult.getResultCode() != ResultCode.SUCCESS) {
                            throw new LDAPException(startTLSResult);
                        }
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        String msg = e instanceof LDAPException ? ((LDAPException)e).getResultString() : StaticUtils.getExceptionMessage(e);
                        this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_LDAP_CANNOT_PERFORM_STARTTLS.get(msg));
                        if (this.promptForYesNo(UtilityMessages.INFO_INTERACTIVE_LDAP_RETRY_PROMPT.get(), true, true).booleanValue()) {
                            this.promptForLDAPArguments(argList, test);
                            conn.close();
                            return;
                        }
                        throw new LDAPException(ResultCode.LOCAL_ERROR, "", e);
                    }
                }
                if (bindRequest != null) {
                    try {
                        conn.bind(bindRequest);
                    }
                    catch (LDAPException le) {
                        Debug.debugException(le);
                        this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_LDAP_CANNOT_AUTHENTICATE.get(le.getResultString()));
                        if (this.promptForYesNo(UtilityMessages.INFO_INTERACTIVE_LDAP_RETRY_PROMPT.get(), true, true).booleanValue()) {
                            this.promptForLDAPArguments(argList, test);
                            conn.close();
                            return;
                        }
                        throw new LDAPException(le.getResultCode(), "", le);
                    }
                }
                break block111;
                finally {
                    conn.close();
                }
            }
        }
    }

    private void promptForMultiServerLDAPArguments(@NotNull List<String> argList, boolean test) throws LDAPException {
        throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_INTERACTIVE_MULTI_SERVER_LDAP_NOT_SUPPORTED.get());
    }

    @NotNull
    private List<String> displayInteractiveMenu(@NotNull List<String> ldapArgs) throws LDAPException {
        ArrayList<Argument> args = new ArrayList<Argument>(this.parser.getNamedArguments());
        if (this.parser.getSelectedSubCommand() != null) {
            args.addAll(this.parser.getSelectedSubCommand().getArgumentParser().getNamedArguments());
        }
        Set<String> usageArguments = CommandLineTool.getUsageArgumentIdentifiers(this.tool);
        Set<Object> ldapArguments = this.tool instanceof LDAPCommandLineTool ? LDAPCommandLineTool.getLongLDAPArgumentIdentifiers((LDAPCommandLineTool)this.tool) : Collections.emptySet();
        int maxIdentifierLength = 0;
        String trailingArgsIdentifier = UtilityMessages.INFO_INTERACTIVE_MENU_TRAILING_ARGS_IDENTIFIER.get();
        if (this.parser.allowsTrailingArguments()) {
            maxIdentifierLength = trailingArgsIdentifier.length();
        }
        Iterator<Argument> argIterator = args.iterator();
        while (argIterator.hasNext()) {
            Argument a = argIterator.next();
            String longID = a.getLongIdentifier();
            if (usageArguments.contains(longID) || ldapArguments.contains(longID)) {
                argIterator.remove();
                continue;
            }
            maxIdentifierLength = Math.max(maxIdentifierLength, a.getIdentifierString().length());
        }
        if (args.isEmpty() && !this.parser.allowsTrailingArguments()) {
            return Collections.emptyList();
        }
        for (Argument arg : args) {
            List<String> valueStrings;
            if (!arg.isRequired() || !(valueStrings = arg.getValueStringRepresentations(true)).isEmpty()) continue;
            this.promptForArgument(arg);
        }
        if (this.parser.requiresTrailingArguments()) {
            this.promptForTrailingArguments();
        }
        block23: while (true) {
            Argument selectedArg;
            int maxNumberLength = String.valueOf(args.size()).length();
            int subsequentIndent = maxNumberLength + maxIdentifierLength + 4;
            this.tool.out(new Object[0]);
            this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_MENU_PROMPT.get());
            int optionNumber = 1;
            for (Argument arg : args) {
                List<String> valueStrings = arg.getValueStringRepresentations(true);
                if (arg.isSensitive()) {
                    int size = valueStrings.size();
                    switch (size) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            valueStrings = Collections.singletonList("***REDACTED***");
                            break;
                        }
                        default: {
                            valueStrings = new ArrayList<String>(size);
                            for (int i = 0; i <= size; ++i) {
                                valueStrings.add("***REDACTED" + i + "***");
                            }
                        }
                    }
                }
                switch (valueStrings.size()) {
                    case 0: {
                        this.tool.wrapStandardOut(0, subsequentIndent, this.wrapColumn, true, CommandLineToolInteractiveModeProcessor.rightAlign(String.valueOf(optionNumber), maxNumberLength), Character.valueOf(' '), CommandLineToolInteractiveModeProcessor.leftAlign(arg.getIdentifierString(), maxIdentifierLength), " -");
                        break;
                    }
                    case 1: {
                        this.tool.wrapStandardOut(0, subsequentIndent, this.wrapColumn, true, CommandLineToolInteractiveModeProcessor.rightAlign(String.valueOf(optionNumber), maxNumberLength), Character.valueOf(' '), CommandLineToolInteractiveModeProcessor.leftAlign(arg.getIdentifierString(), maxIdentifierLength), " - ", valueStrings.get(0));
                        break;
                    }
                    default: {
                        this.tool.wrapStandardOut(0, subsequentIndent, this.wrapColumn, true, CommandLineToolInteractiveModeProcessor.rightAlign(String.valueOf(optionNumber), maxNumberLength), Character.valueOf(' '), CommandLineToolInteractiveModeProcessor.leftAlign(arg.getIdentifierString(), maxIdentifierLength), " - ", valueStrings.get(0));
                        for (int i = 1; i < valueStrings.size(); ++i) {
                            this.tool.wrapStandardOut(0, subsequentIndent, this.wrapColumn, true, CommandLineToolInteractiveModeProcessor.rightAlign("", maxNumberLength), Character.valueOf(' '), CommandLineToolInteractiveModeProcessor.leftAlign("", maxIdentifierLength), " - ", valueStrings.get(i));
                        }
                    }
                }
                ++optionNumber;
            }
            if (this.parser.allowsTrailingArguments()) {
                List<String> trailingArgs = this.parser.getTrailingArguments();
                switch (trailingArgs.size()) {
                    case 0: {
                        this.tool.wrapStandardOut(0, subsequentIndent, this.wrapColumn, true, CommandLineToolInteractiveModeProcessor.rightAlign("t", maxNumberLength), Character.valueOf(' '), CommandLineToolInteractiveModeProcessor.leftAlign(trailingArgsIdentifier, maxIdentifierLength), " -");
                        break;
                    }
                    case 1: {
                        this.tool.wrapStandardOut(0, subsequentIndent, this.wrapColumn, true, CommandLineToolInteractiveModeProcessor.rightAlign("t", maxNumberLength), Character.valueOf(' '), CommandLineToolInteractiveModeProcessor.leftAlign(trailingArgsIdentifier, maxIdentifierLength), " - ", trailingArgs.get(0));
                        break;
                    }
                    default: {
                        this.tool.wrapStandardOut(0, subsequentIndent, this.wrapColumn, true, CommandLineToolInteractiveModeProcessor.rightAlign("t", maxNumberLength), Character.valueOf(' '), CommandLineToolInteractiveModeProcessor.leftAlign(trailingArgsIdentifier, maxIdentifierLength), " - ", trailingArgs.get(0));
                        for (int i = 1; i < trailingArgs.size(); ++i) {
                            this.tool.wrapStandardOut(0, subsequentIndent, this.wrapColumn, true, CommandLineToolInteractiveModeProcessor.rightAlign("", maxNumberLength), Character.valueOf(' '), CommandLineToolInteractiveModeProcessor.leftAlign("", maxIdentifierLength), " - ", trailingArgs.get(i));
                        }
                    }
                }
            }
            this.tool.out(new Object[0]);
            if (this.tool instanceof LDAPCommandLineTool) {
                LDAPCommandLineTool ldapTool = (LDAPCommandLineTool)this.tool;
                if (ldapTool.supportsAuthentication()) {
                    this.tool.wrapStandardOut(maxNumberLength - 1, subsequentIndent, this.wrapColumn, true, "l - ", UtilityMessages.INFO_INTERACTIVE_MENU_OPTION_REPROMPT_FOR_CONN_AUTH_ARGS.get());
                } else {
                    this.tool.wrapStandardOut(maxNumberLength - 1, subsequentIndent, this.wrapColumn, true, "l - ", UtilityMessages.INFO_INTERACTIVE_MENU_OPTION_REPROMPT_FOR_CONN_ARGS.get());
                }
            } else if (this.tool instanceof MultiServerLDAPCommandLineTool) {
                this.tool.wrapStandardOut(maxNumberLength - 1, subsequentIndent, this.wrapColumn, true, "l - ", UtilityMessages.INFO_INTERACTIVE_MENU_OPTION_REPROMPT_FOR_CONN_AUTH_ARGS.get());
            }
            this.tool.wrapStandardOut(maxNumberLength - 1, subsequentIndent, this.wrapColumn, true, "d - ", UtilityMessages.INFO_INTERACTIVE_MENU_OPTION_DISPLAY_ARGS.get(this.tool.getToolName()));
            this.tool.wrapStandardOut(maxNumberLength - 1, subsequentIndent, this.wrapColumn, true, "r - ", UtilityMessages.INFO_INTERACTIVE_MENU_OPTION_RUN.get(this.tool.getToolName()));
            this.tool.wrapStandardOut(maxNumberLength - 1, subsequentIndent, this.wrapColumn, true, "q - ", UtilityMessages.INFO_INTERACTIVE_MENU_OPTION_QUIT.get());
            this.tool.out(new Object[0]);
            this.tool.getOut().print(UtilityMessages.INFO_INTERACTIVE_MENU_ENTER_CHOICE_WITHOUT_DEFAULT.get() + ' ');
            try {
                int selectedValue;
                while (true) {
                    String line;
                    if ((line = this.systemInReader.readLine().trim()).equalsIgnoreCase("t") && this.tool.getMaxTrailingArguments() != 0) {
                        this.promptForTrailingArguments();
                        continue block23;
                    }
                    if (line.equalsIgnoreCase("l")) {
                        if (this.tool instanceof LDAPCommandLineTool) {
                            this.promptForLDAPArguments(ldapArgs, true);
                            continue block23;
                        }
                        if (this.tool instanceof MultiServerLDAPCommandLineTool) {
                            this.promptForMultiServerLDAPArguments(ldapArgs, true);
                            continue block23;
                        }
                        this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_ARG_MENU_INVALID_CHOICE.get());
                        this.tool.getOut().print(UtilityMessages.INFO_INTERACTIVE_MENU_ENTER_CHOICE_WITHOUT_DEFAULT.get() + ' ');
                        continue block23;
                    }
                    if (line.equalsIgnoreCase("d")) {
                        try {
                            this.validateRequiredExclusiveAndDependentArgumentSets();
                            this.tool.doExtendedArgumentValidation();
                            ArrayList<String> argStrings = new ArrayList<String>(2 * args.size());
                            SubCommand subcommand = this.parser.getSelectedSubCommand();
                            if (subcommand != null) {
                                argStrings.add(subcommand.getPrimaryName());
                            }
                            argStrings.addAll(ldapArgs);
                            for (Argument a : args) {
                                ArgumentHelper.addToCommandLine(a, argStrings);
                            }
                            argStrings.addAll(this.parser.getTrailingArguments());
                            if (argStrings.isEmpty()) {
                                this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_MENU_NO_CURRENT_ARGS.get(this.tool.getToolName()));
                            } else {
                                this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_MENU_CURRENT_ARGS_HEADER.get(this.tool.getToolName()));
                                this.printArgs(argStrings);
                            }
                            this.tool.out(new Object[0]);
                            this.promptForString(UtilityMessages.INFO_INTERACTIVE_MENU_PROMPT_PRESS_ENTER_TO_CONTINUE.get(), null, false);
                        }
                        catch (ArgumentException ae) {
                            Debug.debugException(ae);
                            this.tool.err(new Object[0]);
                            this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_MENU_EXTENDED_VALIDATION_ERRORS.get(ae.getMessage()));
                            this.tool.err(new Object[0]);
                            this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_MENU_CORRECT_VALIDATION_ERRORS.get());
                            this.tool.err(new Object[0]);
                            this.promptForString(UtilityMessages.INFO_INTERACTIVE_MENU_PROMPT_PRESS_ENTER_TO_CONTINUE.get(), null, false);
                        }
                        continue block23;
                    }
                    if (line.equalsIgnoreCase("r")) {
                        try {
                            this.validateRequiredExclusiveAndDependentArgumentSets();
                            this.tool.doExtendedArgumentValidation();
                            break block23;
                        }
                        catch (ArgumentException ae) {
                            Debug.debugException(ae);
                            this.tool.err(new Object[0]);
                            this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_MENU_EXTENDED_VALIDATION_ERRORS.get(ae.getMessage()));
                            this.tool.err(new Object[0]);
                            this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_MENU_CORRECT_VALIDATION_ERRORS.get());
                            this.tool.err(new Object[0]);
                            this.promptForString(UtilityMessages.INFO_INTERACTIVE_MENU_PROMPT_PRESS_ENTER_TO_CONTINUE.get(), null, false);
                            continue block23;
                        }
                    }
                    if (line.equalsIgnoreCase("q")) {
                        throw new LDAPException(ResultCode.SUCCESS, "");
                    }
                    selectedValue = -1;
                    try {
                        selectedValue = Integer.parseInt(line);
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                    }
                    if (selectedValue >= 1 && selectedValue <= args.size()) break;
                    this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_ARG_MENU_INVALID_CHOICE.get());
                    this.tool.getOut().print(UtilityMessages.INFO_INTERACTIVE_MENU_ENTER_CHOICE_WITHOUT_DEFAULT.get() + ' ');
                }
                selectedArg = args.get(selectedValue - 1);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                throw le;
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_INTERACTIVE_MENU_CANNOT_READ_CHOICE.get(StaticUtils.getExceptionMessage(e)), e);
            }
            this.promptForArgument(selectedArg);
        }
        ArrayList<String> argStrings = new ArrayList<String>(2 * args.size());
        for (Argument a : args) {
            ArgumentHelper.addToCommandLine(a, argStrings);
        }
        argStrings.addAll(this.parser.getTrailingArguments());
        return argStrings;
    }

    private void promptForTrailingArguments() throws LDAPException {
        this.tool.out(new Object[0]);
        ArgumentHelper.resetTrailingArguments(this.parser);
        if (this.parser.getMaxTrailingArguments() == 1) {
            if (this.parser.requiresTrailingArguments()) {
                this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_TRAILING_DESC_SINGLE_REQUIRED.get(this.tool.getToolName()));
            } else {
                this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_TRAILING_DESC_SINGLE_OPTIONAL.get(this.tool.getToolName()));
            }
            this.tool.out("     ", this.tool.getTrailingArgumentsPlaceholder());
            this.tool.out(new Object[0]);
            this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_TRAILING_PROMPT_SINGLE.get());
            while (true) {
                String trailingArgValue;
                if ((trailingArgValue = this.promptForString(UtilityMessages.INFO_INTERACTIVE_TRAILING_ARG_PROMPT.get(), null, false)) == null) {
                    return;
                }
                try {
                    ArgumentHelper.addTrailingArgument(this.parser, trailingArgValue);
                    return;
                }
                catch (ArgumentException ae) {
                    Debug.debugException(ae);
                    this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_TRAILING_VALUE_INVALID.get(ae.getMessage()));
                    continue;
                }
                break;
            }
        }
        if (this.parser.requiresTrailingArguments()) {
            this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_TRAILING_DESC_MULTIPLE_REQUIRED.get(this.tool.getToolName(), this.parser.getMinTrailingArguments()));
        } else {
            this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_TRAILING_DESC_MULTIPLE_OPTIONAL.get(this.tool.getToolName()));
        }
        this.tool.out("     ", this.tool.getTrailingArgumentsPlaceholder());
        this.tool.out(new Object[0]);
        this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_TRAILING_PROMPT_MULTIPLE.get());
        String trailingArgValue;
        while ((trailingArgValue = this.promptForString(UtilityMessages.INFO_INTERACTIVE_TRAILING_ARG_PROMPT.get(), null, false)) != null) {
            try {
                ArgumentHelper.addTrailingArgument(this.parser, trailingArgValue);
                continue;
            }
            catch (ArgumentException ae) {
                Debug.debugException(ae);
                this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_TRAILING_VALUE_INVALID.get(ae.getMessage()));
                continue;
            }
            break;
        }
        return;
    }

    private void promptForArgument(@NotNull Argument a) throws LDAPException {
        String constraints;
        this.tool.out(new Object[0]);
        int maxValues = a.getMaxOccurrences();
        if (maxValues == 1) {
            this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_SPECIFY_SINGLE_VALUE.get(a.getIdentifierString()));
        } else {
            this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_SPECIFY_MULTIPLE_VALUES.get(a.getIdentifierString()));
        }
        String description = a.getDescription();
        if (description != null && !description.isEmpty()) {
            this.tool.out(new Object[0]);
            String prompt = UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_DESCRIPTION.get();
            this.tool.wrapStandardOut(0, prompt.length(), this.wrapColumn, true, prompt, description);
        }
        if ((constraints = a.getValueConstraints()) != null && !constraints.isEmpty()) {
            this.tool.out(new Object[0]);
            String prompt = UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_CONSTRAINTS.get();
            this.tool.wrapStandardOut(0, prompt.length(), this.wrapColumn, true, prompt, constraints);
            if (a.isRequired()) {
                if (maxValues == 1) {
                    this.tool.wrapStandardOut(prompt.length(), prompt.length(), this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_SINGLE_REQUIRED.get());
                } else {
                    this.tool.wrapStandardOut(prompt.length(), prompt.length(), this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_AT_LEAST_ONE_REQUIRED.get());
                }
            }
        } else if (a.isRequired()) {
            this.tool.out(new Object[0]);
            String prompt = UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_CONSTRAINTS.get();
            if (maxValues == 1) {
                this.tool.wrapStandardOut(0, prompt.length(), this.wrapColumn, true, prompt, UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_SINGLE_REQUIRED.get());
            } else {
                this.tool.wrapStandardOut(0, prompt.length(), this.wrapColumn, true, prompt, UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_AT_LEAST_ONE_REQUIRED.get());
            }
        }
        if (a instanceof ArgumentListArgument) {
            this.promptForArgumentList((ArgumentListArgument)a);
        } else if (a instanceof BooleanArgument) {
            this.promptForBoolean((BooleanArgument)a);
        } else if (a instanceof BooleanValueArgument) {
            this.promptForBoolean((BooleanValueArgument)a);
        } else if (a instanceof ControlArgument) {
            this.promptForControl((ControlArgument)a);
        } else if (a instanceof DNArgument) {
            this.promptForDN((DNArgument)a);
        } else if (a instanceof DurationArgument) {
            this.promptForDuration((DurationArgument)a);
        } else if (a instanceof FileArgument) {
            this.promptForFile((FileArgument)a);
        } else if (a instanceof FilterArgument) {
            this.promptForFilter((FilterArgument)a);
        } else if (a instanceof IntegerArgument) {
            this.promptForInteger((IntegerArgument)a);
        } else if (a instanceof ScopeArgument) {
            this.promptForScope((ScopeArgument)a);
        } else if (a instanceof StringArgument) {
            this.promptForString((StringArgument)a);
        } else if (a instanceof TimestampArgument) {
            this.promptForTimestamp((TimestampArgument)a);
        } else {
            throw new AssertionError((Object)("Unexpected argument type " + a.getClass().getName()));
        }
    }

    private void promptForArgumentList(@NotNull ArgumentListArgument a) throws LDAPException {
        List<String> values = a.getValueStrings();
        ArgumentHelper.reset(a);
        if (a.getMaxOccurrences() == 1) {
            if (!values.isEmpty()) {
                this.tool.out(new Object[0]);
                this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_DESC_CURRENT_VALUE.get());
                this.tool.wrapStandardOut(5, 10, this.wrapColumn, true, values.get(0));
            }
            while (true) {
                String newValue = this.promptForString(UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_NEW_VALUE.get(), null, a.isRequired());
                try {
                    if (newValue != null) {
                        ArgumentHelper.addValue(a, newValue);
                    }
                    return;
                }
                catch (ArgumentException ae) {
                    Debug.debugException(ae);
                    this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_ARG_PROMPT_INVALID_VALUE.get(ae.getMessage()));
                    continue;
                }
                break;
            }
        }
        if (!values.isEmpty()) {
            this.tool.out(new Object[0]);
            this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_DESC_CURRENT_VALUES.get());
            for (String s : values) {
                this.tool.wrapStandardOut(5, 10, this.wrapColumn, true, s);
            }
        }
        this.tool.out(new Object[0]);
        this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_NEW_VALUES.get());
        boolean first = true;
        String s;
        while ((s = this.promptForString(UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_NEW_VALUE.get(), null, first && a.isRequired())) != null) {
            try {
                ArgumentHelper.addValue(a, s);
                first = false;
                continue;
            }
            catch (ArgumentException ae) {
                Debug.debugException(ae);
                this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_ARG_PROMPT_INVALID_VALUE.get(ae.getMessage()));
                continue;
            }
            break;
        }
        return;
    }

    private void promptForBoolean(@NotNull BooleanArgument a) throws LDAPException {
        this.tool.out(new Object[0]);
        this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_DESC_CURRENT_VALUE.get());
        this.tool.wrapStandardOut(5, 10, this.wrapColumn, true, a.isPresent());
        ArgumentHelper.reset(a);
        if (this.promptForBoolean(UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_NEW_VALUE.get(), null, true).booleanValue()) {
            ArgumentHelper.incrementOccurrencesSuppressException(a);
        }
    }

    private void promptForBoolean(@NotNull BooleanValueArgument a) throws LDAPException {
        Boolean value = a.getValue();
        ArgumentHelper.reset(a);
        Boolean b = this.promptForBoolean(UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_NEW_VALUE.get(), null, a.isRequired());
        if (b != null) {
            ArgumentHelper.addValueSuppressException(a, String.valueOf(b));
        }
    }

    private void promptForControl(@NotNull ControlArgument a) throws LDAPException {
        List<Control> values = a.getValues();
        ArgumentHelper.reset(a);
        if (a.getMaxOccurrences() == 1) {
            if (!values.isEmpty()) {
                this.tool.out(new Object[0]);
                this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_DESC_CURRENT_VALUE.get());
                this.tool.wrapStandardOut(5, 10, this.wrapColumn, true, values.get(0));
            }
            while (true) {
                String newValue = this.promptForString(UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_NEW_VALUE.get(), null, false);
                try {
                    if (newValue == null) {
                        ArgumentHelper.addValue(a, "");
                    } else {
                        ArgumentHelper.addValue(a, newValue);
                    }
                    return;
                }
                catch (ArgumentException ae) {
                    Debug.debugException(ae);
                    this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_ARG_PROMPT_INVALID_VALUE.get(ae.getMessage()));
                    continue;
                }
                break;
            }
        }
        if (!values.isEmpty()) {
            this.tool.out(new Object[0]);
            this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_DESC_CURRENT_VALUES.get());
            for (Control c : values) {
                this.tool.wrapStandardOut(5, 10, this.wrapColumn, true, c);
            }
        }
        this.tool.out(new Object[0]);
        this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_NEW_VALUES.get());
        boolean first = true;
        String s;
        while ((s = this.promptForString(UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_NEW_VALUE.get(), null, first && a.isRequired())) != null) {
            try {
                ArgumentHelper.addValue(a, s);
                first = false;
                continue;
            }
            catch (ArgumentException ae) {
                Debug.debugException(ae);
                this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_ARG_PROMPT_INVALID_VALUE.get(ae.getMessage()));
                continue;
            }
            break;
        }
        return;
    }

    private void promptForDN(@NotNull DNArgument a) throws LDAPException {
        List<DN> values = a.getValues();
        ArgumentHelper.reset(a);
        if (a.getMaxOccurrences() == 1) {
            if (!values.isEmpty()) {
                this.tool.out(new Object[0]);
                this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_DESC_CURRENT_VALUE.get());
                this.tool.wrapStandardOut(5, 10, this.wrapColumn, true, values.get(0));
            }
        } else {
            if (!values.isEmpty()) {
                this.tool.out(new Object[0]);
                this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_DESC_CURRENT_VALUES.get());
                for (DN dn : values) {
                    this.tool.wrapStandardOut(5, 10, this.wrapColumn, true, dn);
                }
            }
            this.tool.out(new Object[0]);
            this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_NEW_VALUES.get());
            boolean first = true;
            while (true) {
                boolean allowNullDN;
                if (first) {
                    first = false;
                    allowNullDN = !a.isRequired();
                } else {
                    allowNullDN = true;
                }
                DN dnValue = this.promptForDN(UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_NEW_VALUE.get(), null, allowNullDN);
                if (dnValue.isNullDN()) {
                    return;
                }
                ArgumentHelper.addValueSuppressException(a, String.valueOf(dnValue));
            }
        }
        DN dnValue = this.promptForDN(UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_NEW_VALUE.get(), null, true);
        ArgumentHelper.addValueSuppressException(a, String.valueOf(dnValue));
    }

    private void promptForDuration(@NotNull DurationArgument a) throws LDAPException {
        List<String> values = a.getValueStringRepresentations(true);
        if (!values.isEmpty()) {
            this.tool.out(new Object[0]);
            this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_DESC_CURRENT_VALUE.get());
            this.tool.wrapStandardOut(5, 10, this.wrapColumn, true, values.get(0));
        }
        while (true) {
            String newValue = this.promptForString(UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_NEW_VALUE.get(), null, a.isRequired());
            try {
                if (newValue != null) {
                    ArgumentHelper.addValue(a, newValue);
                }
                return;
            }
            catch (ArgumentException ae) {
                Debug.debugException(ae);
                this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_ARG_PROMPT_INVALID_VALUE.get(ae.getMessage()));
                continue;
            }
            break;
        }
    }

    private void promptForFile(@NotNull FileArgument a) throws LDAPException {
        List<File> values = a.getValues();
        ArgumentHelper.reset(a);
        if (a.getMaxOccurrences() == 1) {
            File fileValue;
            if (!values.isEmpty()) {
                this.tool.out(new Object[0]);
                this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_DESC_CURRENT_VALUE.get());
                this.tool.wrapStandardOut(5, 10, this.wrapColumn, true, values.get(0));
            }
            if ((fileValue = this.promptForPath(UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_NEW_VALUE.get(), null, a.isRequired(), a.fileMustExist(), a.parentMustExist(), a.mustBeFile(), a.mustBeDirectory())) != null) {
                ArgumentHelper.addValueSuppressException(a, fileValue.getPath());
            }
        } else {
            if (!values.isEmpty()) {
                this.tool.out(new Object[0]);
                this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_DESC_CURRENT_VALUES.get());
                for (File f : values) {
                    this.tool.wrapStandardOut(5, 10, this.wrapColumn, true, f.getPath());
                }
            }
            this.tool.out(new Object[0]);
            this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_NEW_VALUES.get());
            boolean first = true;
            while (true) {
                boolean isRequired;
                if (first) {
                    first = false;
                    isRequired = a.isRequired();
                } else {
                    isRequired = false;
                }
                File fileValue = this.promptForPath(UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_NEW_VALUE.get(), null, isRequired, a.fileMustExist(), a.parentMustExist(), a.mustBeFile(), a.mustBeDirectory());
                if (fileValue == null) {
                    return;
                }
                ArgumentHelper.addValueSuppressException(a, fileValue.getPath());
            }
        }
    }

    private void promptForFilter(@NotNull FilterArgument a) throws LDAPException {
        List<Filter> values = a.getValues();
        ArgumentHelper.reset(a);
        if (a.getMaxOccurrences() == 1) {
            Filter filterValue;
            if (!values.isEmpty()) {
                this.tool.out(new Object[0]);
                this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_DESC_CURRENT_VALUE.get());
                this.tool.wrapStandardOut(5, 10, this.wrapColumn, true, values.get(0));
            }
            if ((filterValue = this.promptForFilter(UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_NEW_VALUE.get(), null, a.isRequired())) != null) {
                ArgumentHelper.addValueSuppressException(a, filterValue.toString());
            }
        } else {
            if (!values.isEmpty()) {
                this.tool.out(new Object[0]);
                this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_DESC_CURRENT_VALUES.get());
                for (Filter f : values) {
                    this.tool.wrapStandardOut(5, 10, this.wrapColumn, true, String.valueOf(f));
                }
            }
            this.tool.out(new Object[0]);
            this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_NEW_VALUES.get());
            boolean first = true;
            while (true) {
                boolean isRequired;
                if (first) {
                    first = false;
                    isRequired = a.isRequired();
                } else {
                    isRequired = false;
                }
                Filter filterValue = this.promptForFilter(UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_NEW_VALUE.get(), null, isRequired);
                if (filterValue == null) {
                    return;
                }
                ArgumentHelper.addValueSuppressException(a, String.valueOf(filterValue));
            }
        }
    }

    private void promptForInteger(@NotNull IntegerArgument a) throws LDAPException {
        List<Integer> values = a.getValues();
        ArgumentHelper.reset(a);
        if (a.getMaxOccurrences() == 1) {
            Integer intValue;
            if (!values.isEmpty()) {
                this.tool.out(new Object[0]);
                this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_DESC_CURRENT_VALUE.get());
                this.tool.wrapStandardOut(5, 10, this.wrapColumn, true, values.get(0));
            }
            if ((intValue = this.promptForInteger(UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_NEW_VALUE.get(), null, a.getLowerBound(), a.getUpperBound(), a.isRequired())) != null) {
                ArgumentHelper.addValueSuppressException(a, String.valueOf(intValue));
            }
        } else {
            if (!values.isEmpty()) {
                this.tool.out(new Object[0]);
                this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_DESC_CURRENT_VALUES.get());
                for (Integer i : values) {
                    this.tool.wrapStandardOut(5, 10, this.wrapColumn, true, i);
                }
            }
            this.tool.out(new Object[0]);
            this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_NEW_VALUES.get());
            boolean first = true;
            while (true) {
                boolean isRequired;
                if (first) {
                    first = false;
                    isRequired = a.isRequired();
                } else {
                    isRequired = false;
                }
                Integer intValue = this.promptForInteger(UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_NEW_VALUE.get(), null, a.getLowerBound(), a.getUpperBound(), isRequired);
                if (intValue == null) {
                    return;
                }
                ArgumentHelper.addValueSuppressException(a, String.valueOf(intValue));
            }
        }
    }

    private void promptForScope(@NotNull ScopeArgument a) throws LDAPException {
        int newIntValue;
        SearchScope value = a.getValue();
        ArgumentHelper.reset(a);
        String[] scopeValues = new String[]{"base", "one", "sub", "subordinates"};
        this.tool.out(new Object[0]);
        if (value != null && value.intValue() < scopeValues.length) {
            this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_DESC_CURRENT_VALUE.get());
            this.tool.wrapStandardOut(5, 10, this.wrapColumn, true, scopeValues[value.intValue()]);
        }
        if ((newIntValue = this.getNumberedMenuChoice(UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_NEW_VALUE.get(), !a.isRequired(), null, scopeValues)) >= 0) {
            ArgumentHelper.addValueSuppressException(a, scopeValues[newIntValue]);
        }
    }

    private void promptForString(@NotNull StringArgument a) throws LDAPException {
        if (a.getAllowedValues() != null && !a.getAllowedValues().isEmpty() && a.getAllowedValues().size() <= 20) {
            this.promptForStringWithMenu(a);
            return;
        }
        List<String> values = a.getValues();
        ArgumentHelper.reset(a);
        if (a.getMaxOccurrences() == 1) {
            if (!values.isEmpty()) {
                this.tool.out(new Object[0]);
                this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_DESC_CURRENT_VALUE.get());
                this.tool.wrapStandardOut(5, 10, this.wrapColumn, true, values.get(0));
            }
            while (true) {
                byte[] newValueBytes;
                Object newValue = a.isSensitive() ? ((newValueBytes = this.promptForPassword(UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_NEW_VALUE.get(), UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_VALUE_CONFIRM.get(), a.isRequired())) == null ? null : StaticUtils.toUTF8String(newValueBytes)) : this.promptForString(UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_NEW_VALUE.get(), null, a.isRequired());
                try {
                    if (newValue != null) {
                        ArgumentHelper.addValue(a, (String)newValue);
                    }
                    return;
                }
                catch (ArgumentException ae) {
                    Debug.debugException(ae);
                    this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_ARG_PROMPT_INVALID_VALUE.get(ae.getMessage()));
                    continue;
                }
                break;
            }
        }
        if (!values.isEmpty()) {
            this.tool.out(new Object[0]);
            this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_DESC_CURRENT_VALUES.get());
            for (String s : values) {
                this.tool.wrapStandardOut(5, 10, this.wrapColumn, true, s);
            }
        }
        this.tool.out(new Object[0]);
        this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_NEW_VALUES.get());
        boolean first = true;
        String s;
        while ((s = this.promptForString(UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_NEW_VALUE.get(), null, first && a.isRequired())) != null) {
            try {
                ArgumentHelper.addValue(a, s);
                first = false;
                continue;
            }
            catch (ArgumentException ae) {
                Debug.debugException(ae);
                this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_ARG_PROMPT_INVALID_VALUE.get(ae.getMessage()));
                continue;
            }
            break;
        }
        return;
    }

    private void promptForStringWithMenu(@NotNull StringArgument a) throws LDAPException {
        String message;
        int firstChoice;
        List<String> values = a.getValues();
        ArgumentHelper.reset(a);
        String[] allowedValueArray = new String[a.getAllowedValues().size()];
        a.getAllowedValues().toArray(allowedValueArray);
        if (!values.isEmpty()) {
            this.tool.out(new Object[0]);
            if (values.size() == 1) {
                this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_DESC_CURRENT_VALUE.get());
                this.tool.wrapStandardOut(5, 10, this.wrapColumn, true, values.get(0));
            } else {
                this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_DESC_CURRENT_VALUES.get());
                for (String s : values) {
                    this.tool.wrapStandardOut(5, 10, this.wrapColumn, true, s);
                }
            }
        }
        if ((firstChoice = this.getNumberedMenuChoice(message = a.getMaxOccurrences() > 1 ? UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_NEW_VALUES.get() : UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_NEW_VALUE.get(), !a.isRequired(), null, allowedValueArray)) < 0) {
            return;
        }
        ArgumentHelper.addValueSuppressException(a, allowedValueArray[firstChoice]);
        if (a.getMaxOccurrences() > 1) {
            while (true) {
                String stringValue;
                if ((stringValue = this.promptForString(UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_NEW_VALUE.get(), null, false)) == null) {
                    return;
                }
                if (stringValue.equalsIgnoreCase("q")) {
                    throw new LDAPException(ResultCode.SUCCESS, "");
                }
                int selectedValue = -1;
                try {
                    selectedValue = Integer.parseInt(stringValue);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
                if (selectedValue < 1 || selectedValue > allowedValueArray.length) {
                    this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_MENU_INVALID_CHOICE.get());
                    continue;
                }
                ArgumentHelper.addValueSuppressException(a, allowedValueArray[selectedValue - 1]);
            }
        }
    }

    private void promptForTimestamp(@NotNull TimestampArgument a) throws LDAPException {
        List<String> stringValues = a.getValueStringRepresentations(true);
        ArgumentHelper.reset(a);
        if (a.getMaxOccurrences() == 1) {
            ObjectPair<Date, String> p;
            if (!stringValues.isEmpty()) {
                this.tool.out(new Object[0]);
                this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_DESC_CURRENT_VALUE.get());
                this.tool.wrapStandardOut(5, 10, this.wrapColumn, true, stringValues.get(0));
            }
            if ((p = this.promptForTimestamp(UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_NEW_VALUE.get(), null, a.isRequired())) != null) {
                ArgumentHelper.addValueSuppressException(a, p.getSecond());
            }
        } else {
            if (!stringValues.isEmpty()) {
                this.tool.out(new Object[0]);
                this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_DESC_CURRENT_VALUES.get());
                for (String s : stringValues) {
                    this.tool.wrapStandardOut(5, 10, this.wrapColumn, true, String.valueOf(s));
                }
            }
            this.tool.out(new Object[0]);
            this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_NEW_VALUES.get());
            boolean first = true;
            while (true) {
                boolean isRequired;
                if (first) {
                    first = false;
                    isRequired = a.isRequired();
                } else {
                    isRequired = false;
                }
                Filter filterValue = this.promptForFilter(UtilityMessages.INFO_INTERACTIVE_ARG_PROMPT_NEW_VALUE.get(), null, isRequired);
                if (filterValue == null) {
                    return;
                }
                ArgumentHelper.addValueSuppressException(a, String.valueOf(filterValue));
            }
        }
    }

    private int getNumberedMenuChoice(@NotNull String prompt, boolean allowUndefined, @Nullable String defaultOptionString, String ... options) throws LDAPException {
        int maxNumberLength = String.valueOf(options.length).length();
        int subsequentIndent = maxNumberLength + 3;
        this.tool.out(new Object[0]);
        this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, prompt);
        int optionNumber = 1;
        for (String option : options) {
            this.tool.wrapStandardOut(0, subsequentIndent, this.wrapColumn, true, CommandLineToolInteractiveModeProcessor.rightAlign(String.valueOf(optionNumber), maxNumberLength), " - ", option);
            ++optionNumber;
        }
        this.tool.out(new Object[0]);
        if (allowUndefined) {
            this.tool.wrapStandardOut(maxNumberLength - 1, subsequentIndent, this.wrapColumn, true, "u - ", UtilityMessages.INFO_INTERACTIVE_MENU_OPTION_UNDEFINED.get());
        }
        this.tool.wrapStandardOut(maxNumberLength - 1, subsequentIndent, this.wrapColumn, true, "q - ", UtilityMessages.INFO_INTERACTIVE_MENU_OPTION_QUIT.get());
        String message = defaultOptionString == null ? UtilityMessages.INFO_INTERACTIVE_MENU_ENTER_CHOICE_WITHOUT_DEFAULT.get() + ' ' : UtilityMessages.INFO_INTERACTIVE_MENU_ENTER_CHOICE_WITH_DEFAULT.get(defaultOptionString) + ' ';
        try {
            int selectedValue;
            while (true) {
                this.tool.out(new Object[0]);
                this.tool.wrapStandardOut(0, 0, this.wrapColumn, false, message);
                String line = this.systemInReader.readLine().trim();
                if (line.equalsIgnoreCase("q")) {
                    throw new LDAPException(ResultCode.SUCCESS, "");
                }
                if (allowUndefined && line.equalsIgnoreCase("u")) {
                    return -1;
                }
                if (line.isEmpty() && defaultOptionString != null) {
                    line = defaultOptionString;
                }
                selectedValue = -1;
                try {
                    selectedValue = Integer.parseInt(line);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
                if (selectedValue >= 1 && selectedValue <= options.length) break;
                this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_MENU_INVALID_CHOICE.get());
            }
            return selectedValue - 1;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_INTERACTIVE_MENU_CANNOT_READ_CHOICE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Nullable
    private String promptForString(@NotNull String prompt, @Nullable String defaultValue, boolean requireValue) throws LDAPException {
        this.tool.out(new Object[0]);
        String promptStr = defaultValue == null ? prompt + ": " : prompt + " [" + defaultValue + "]: ";
        this.tool.wrapStandardOut(0, 0, this.wrapColumn, false, promptStr);
        try {
            String line = this.systemInReader.readLine().trim();
            if (line.isEmpty() && defaultValue != null) {
                line = defaultValue;
            }
            if (!line.isEmpty()) {
                return line;
            }
            if (requireValue) {
                this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_PROMPT_VALUE_REQUIRED.get());
                return this.promptForString(prompt, defaultValue, requireValue);
            }
            return null;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_INTERACTIVE_PROMPT_ERROR_READING_RESPONSE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Nullable
    private Boolean promptForBoolean(@NotNull String prompt, @Nullable Boolean defaultValue, boolean requireValue) throws LDAPException {
        String[] choices = new String[]{"true", "false"};
        this.tool.out(new Object[0]);
        if (defaultValue != null) {
            this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_DESC_CURRENT_VALUE.get());
            this.tool.wrapStandardOut(5, 10, this.wrapColumn, true, String.valueOf(defaultValue));
        }
        int newIntValue = this.getNumberedMenuChoice(prompt, !requireValue, null, choices);
        switch (newIntValue) {
            case 0: {
                return Boolean.TRUE;
            }
            case 1: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    @Nullable
    private Boolean promptForYesNo(@NotNull String prompt, @Nullable Boolean defaultValue, boolean requireValue) throws LDAPException {
        String[] choices = new String[]{UtilityMessages.INFO_INTERACTIVE_CHOICE_YES.get(), UtilityMessages.INFO_INTERACTIVE_CHOICE_NO.get()};
        this.tool.out(new Object[0]);
        String defaultOptionString = null;
        if (defaultValue != null) {
            this.tool.wrapStandardOut(0, 0, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_ARG_DESC_CURRENT_VALUE.get());
            if (defaultValue.booleanValue()) {
                this.tool.wrapStandardOut(5, 10, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_CHOICE_YES.get());
                defaultOptionString = "1";
            } else {
                this.tool.wrapStandardOut(5, 10, this.wrapColumn, true, UtilityMessages.INFO_INTERACTIVE_CHOICE_NO.get());
                defaultOptionString = "2";
            }
        }
        int newIntValue = this.getNumberedMenuChoice(prompt, !requireValue, defaultOptionString, choices);
        switch (newIntValue) {
            case 0: {
                return Boolean.TRUE;
            }
            case 1: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    /*
     * Loose catch block
     */
    @NotNull
    private DN promptForDN(@NotNull String prompt, @Nullable String defaultValue, boolean nullDNAllowed) throws LDAPException {
        String line;
        block7: {
            this.tool.out(new Object[0]);
            String promptStr = defaultValue == null ? prompt + ": " : prompt + " [" + defaultValue + "]: ";
            this.tool.wrapStandardOut(0, 0, this.wrapColumn, false, promptStr);
            line = this.systemInReader.readLine().trim();
            if (!line.isEmpty()) break block7;
            if (defaultValue != null) {
                line = defaultValue;
            }
            if (!line.isEmpty()) break block7;
            if (nullDNAllowed) {
                return DN.NULL_DN;
            }
            this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_PROMPT_NULL_DN_NOT_ALLOWED.get());
            return this.promptForDN(prompt, defaultValue, nullDNAllowed);
            {
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_INTERACTIVE_PROMPT_ERROR_READING_RESPONSE.get(StaticUtils.getExceptionMessage(e)), e);
                }
            }
        }
        try {
            return new DN(line);
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_PROMPT_INVALID_DN.get());
            return this.promptForDN(prompt, defaultValue, nullDNAllowed);
        }
    }

    /*
     * Loose catch block
     */
    @Nullable
    private Filter promptForFilter(@NotNull String prompt, @Nullable Filter defaultValue, boolean requireValue) throws LDAPException {
        String line;
        block7: {
            this.tool.out(new Object[0]);
            String promptStr = defaultValue == null ? prompt + ": " : prompt + " [" + defaultValue + "]: ";
            this.tool.wrapStandardOut(0, 0, this.wrapColumn, false, promptStr);
            line = this.systemInReader.readLine().trim();
            if (line.isEmpty() && defaultValue != null) {
                line = String.valueOf(defaultValue);
            }
            if (!line.isEmpty()) break block7;
            if (requireValue) {
                this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_PROMPT_VALUE_REQUIRED.get());
                return this.promptForFilter(prompt, defaultValue, requireValue);
            }
            return null;
            {
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_INTERACTIVE_PROMPT_ERROR_READING_RESPONSE.get(StaticUtils.getExceptionMessage(e)), e);
                }
            }
        }
        try {
            return Filter.create(line);
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_PROMPT_INVALID_FILTER.get());
            return this.promptForFilter(prompt, defaultValue, requireValue);
        }
    }

    @Nullable
    private Integer promptForInteger(@NotNull String prompt, @Nullable Integer defaultValue, @Nullable Integer lowerBound, @Nullable Integer upperBound, boolean requireValue) throws LDAPException {
        this.tool.out(new Object[0]);
        int max = upperBound == null ? Integer.MAX_VALUE : upperBound;
        int min = lowerBound == null ? Integer.MIN_VALUE : lowerBound;
        String promptStr = defaultValue == null ? prompt + ": " : prompt + " [" + defaultValue + "]: ";
        this.tool.wrapStandardOut(0, 0, this.wrapColumn, false, promptStr);
        try {
            int intValue;
            String line = this.systemInReader.readLine().trim();
            if (line.isEmpty() && defaultValue != null) {
                line = String.valueOf(defaultValue);
            }
            if (line.isEmpty()) {
                if (requireValue) {
                    this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_PROMPT_VALUE_REQUIRED.get());
                    return this.promptForInteger(prompt, defaultValue, lowerBound, upperBound, requireValue);
                }
                return null;
            }
            try {
                intValue = Integer.parseInt(line);
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_PROMPT_INVALID_INTEGER_WITH_RANGE.get(min, max));
                return this.promptForInteger(prompt, defaultValue, lowerBound, upperBound, requireValue);
            }
            if (intValue > max || intValue < min) {
                this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_PROMPT_INVALID_INTEGER_WITH_RANGE.get(min, max));
                return this.promptForInteger(prompt, defaultValue, lowerBound, upperBound, requireValue);
            }
            return intValue;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_INTERACTIVE_PROMPT_ERROR_READING_RESPONSE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Nullable
    private File promptForPath(@NotNull String prompt, @Nullable String defaultValue, boolean requireValue, boolean fileMustExist, boolean parentMustExist, boolean mustBeFile, boolean mustBeDirectory) throws LDAPException {
        this.tool.out(new Object[0]);
        String promptStr = defaultValue == null ? prompt + ": " : prompt + " [" + defaultValue + "]: ";
        this.tool.wrapStandardOut(0, 0, this.wrapColumn, false, promptStr);
        try {
            String line = this.systemInReader.readLine().trim();
            if (line.isEmpty() && defaultValue != null) {
                line = String.valueOf(defaultValue);
            }
            if (line.isEmpty()) {
                if (requireValue) {
                    this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_PROMPT_VALUE_REQUIRED.get());
                    return this.promptForPath(prompt, defaultValue, requireValue, fileMustExist, parentMustExist, mustBeFile, mustBeDirectory);
                }
                return null;
            }
            File f = new File(line).getAbsoluteFile();
            if (!f.exists()) {
                File parent;
                if (fileMustExist) {
                    if (mustBeDirectory) {
                        this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_PROMPT_DIR_DOES_NOT_EXIST.get(f.getAbsolutePath()));
                        return this.promptForPath(prompt, defaultValue, requireValue, fileMustExist, parentMustExist, mustBeFile, mustBeDirectory);
                    }
                    this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_PROMPT_FILE_DOES_NOT_EXIST.get(f.getAbsolutePath()));
                    return this.promptForPath(prompt, defaultValue, requireValue, fileMustExist, parentMustExist, mustBeFile, mustBeDirectory);
                }
                if (parentMustExist && ((parent = f.getParentFile()) == null || !parent.exists())) {
                    this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_PROMPT_PARENT_DOES_NOT_EXIST.get(f.getAbsolutePath()));
                    return this.promptForPath(prompt, defaultValue, requireValue, fileMustExist, parentMustExist, mustBeFile, mustBeDirectory);
                }
                return f;
            }
            if (f.isDirectory()) {
                if (mustBeFile) {
                    this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_PROMPT_PATH_MUST_BE_FILE.get(f.getAbsolutePath()));
                    return this.promptForPath(prompt, defaultValue, requireValue, fileMustExist, parentMustExist, mustBeFile, mustBeDirectory);
                }
            } else if (mustBeDirectory) {
                this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_PROMPT_PATH_MUST_BE_DIR.get(f.getAbsolutePath()));
                return this.promptForPath(prompt, defaultValue, requireValue, fileMustExist, parentMustExist, mustBeFile, mustBeDirectory);
            }
            return f;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_INTERACTIVE_PROMPT_ERROR_READING_RESPONSE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private byte[] promptForPassword(@NotNull String prompt, @Nullable String confirmPrompt, boolean requireValue) throws LDAPException {
        this.tool.out(new Object[0]);
        this.tool.wrapStandardOut(0, 0, this.wrapColumn, false, prompt, ": ");
        try {
            byte[] pwBytes;
            try {
                if (IN_UNIT_TEST) {
                    PasswordReader.setTestReader(this.systemInReader);
                }
                pwBytes = PasswordReader.readPassword();
            }
            finally {
                PasswordReader.setTestReader(null);
            }
            if (pwBytes == null || pwBytes.length == 0) {
                if (!requireValue) return null;
                this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_PROMPT_VALUE_REQUIRED.get());
                return this.promptForPassword(prompt, confirmPrompt, requireValue);
            }
            if (confirmPrompt == null) return pwBytes;
            try {
                if (IN_UNIT_TEST) {
                    PasswordReader.setTestReader(this.systemInReader);
                }
                this.tool.wrapStandardOut(0, 0, this.wrapColumn, false, confirmPrompt, ": ");
                byte[] confirmedPWBytes = PasswordReader.readPassword();
                if (Arrays.equals(pwBytes, confirmedPWBytes)) return pwBytes;
                this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_PROMPT_CONFIRM_MISMATCH.get());
                byte[] byArray = this.promptForPassword(prompt, confirmPrompt, requireValue);
                return byArray;
            }
            finally {
                PasswordReader.setTestReader(null);
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_INTERACTIVE_PROMPT_ERROR_READING_RESPONSE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    /*
     * Loose catch block
     */
    @Nullable
    private ObjectPair<Date, String> promptForTimestamp(@NotNull String prompt, @Nullable Date defaultValue, boolean requireValue) throws LDAPException {
        String line;
        block7: {
            this.tool.out(new Object[0]);
            String promptStr = defaultValue == null ? prompt + ": " : prompt + " [" + defaultValue + "]: ";
            this.tool.wrapStandardOut(0, 0, this.wrapColumn, false, promptStr);
            line = this.systemInReader.readLine().trim();
            if (line.isEmpty() && defaultValue != null) {
                line = String.valueOf(defaultValue);
            }
            if (!line.isEmpty()) break block7;
            if (requireValue) {
                this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_PROMPT_VALUE_REQUIRED.get());
                return this.promptForTimestamp(prompt, defaultValue, requireValue);
            }
            return null;
            {
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_INTERACTIVE_PROMPT_ERROR_READING_RESPONSE.get(StaticUtils.getExceptionMessage(e)), e);
                }
            }
        }
        try {
            return new ObjectPair<Date, String>(TimestampArgument.parseTimestamp(line), line);
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.tool.wrapErr(0, this.wrapColumn, UtilityMessages.ERR_INTERACTIVE_PROMPT_INVALID_TIMESTAMP.get());
            return this.promptForTimestamp(prompt, defaultValue, requireValue);
        }
    }

    @NotNull
    private static String rightAlign(@NotNull String s, int w) {
        int l = s.length();
        if (l >= w) {
            return s;
        }
        StringBuilder buffer = new StringBuilder(w);
        for (int i = 0; i < w - l; ++i) {
            buffer.append(' ');
        }
        buffer.append(s);
        return buffer.toString();
    }

    @NotNull
    private static String leftAlign(@NotNull String s, int w) {
        int l = s.length();
        if (l >= w) {
            return s;
        }
        StringBuilder buffer = new StringBuilder(w);
        buffer.append(s);
        while (buffer.length() < w) {
            buffer.append(' ');
        }
        return buffer.toString();
    }

    private void validateRequiredExclusiveAndDependentArgumentSets() throws ArgumentException {
        CommandLineToolInteractiveModeProcessor.validateRequiredExclusiveAndDependentArgumentSets(this.parser);
        SubCommand selectedSubCommand = this.parser.getSelectedSubCommand();
        if (selectedSubCommand != null) {
            CommandLineToolInteractiveModeProcessor.validateRequiredExclusiveAndDependentArgumentSets(selectedSubCommand.getArgumentParser());
        }
    }

    private static void validateRequiredExclusiveAndDependentArgumentSets(@NotNull ArgumentParser parser) throws ArgumentException {
        StringBuilder buffer;
        boolean found;
        for (Set<Argument> set : parser.getRequiredArgumentSets()) {
            found = false;
            for (Argument a : set) {
                if (a.getNumOccurrences() <= 0) continue;
                found = true;
                break;
            }
            if (found) continue;
            buffer = new StringBuilder();
            for (Argument a : set) {
                if (buffer.length() > 0) {
                    buffer.append(", ");
                }
                buffer.append(a.getIdentifierString());
            }
            throw new ArgumentException(UtilityMessages.ERR_INTERACTIVE_REQUIRED_ARG_SET_CONFLICT.get(buffer.toString()));
        }
        for (Set<Argument> set : parser.getExclusiveArgumentSets()) {
            found = false;
            for (Argument a : set) {
                if (a.getNumOccurrences() <= 0) continue;
                if (found) {
                    StringBuilder buffer2 = new StringBuilder();
                    for (Argument exclusiveArg : set) {
                        if (buffer2.length() > 0) {
                            buffer2.append(", ");
                        }
                        buffer2.append(exclusiveArg.getIdentifierString());
                    }
                    throw new ArgumentException(UtilityMessages.ERR_INTERACTIVE_EXCLUSIVE_ARG_SET_CONFLICT.get(buffer2.toString()));
                }
                found = true;
            }
        }
        for (ObjectPair objectPair : parser.getDependentArgumentSets()) {
            if (((Argument)objectPair.getFirst()).getNumOccurrences() <= 0) continue;
            found = false;
            for (Argument a : (Set)objectPair.getSecond()) {
                if (!a.isPresent()) continue;
                found = true;
                break;
            }
            if (found) continue;
            buffer = new StringBuilder();
            for (Argument arg : (Set)objectPair.getSecond()) {
                if (buffer.length() > 0) {
                    buffer.append(", ");
                }
                buffer.append(arg.getIdentifierString());
            }
            throw new ArgumentException(UtilityMessages.ERR_INTERACTIVE_DEPENDENT_ARG_SET_CONFLICT.get(((Argument)objectPair.getFirst()).getIdentifierString(), buffer.toString()));
        }
    }

    static void setInUnitTest(boolean inUnitTest) {
        IN_UNIT_TEST = inUnitTest;
    }
}

