/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.buffers;

import java.util.Arrays;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.common.Preconditions;
import org.parboiled.support.IndexRange;
import org.parboiled.support.Position;

public class MutableInputBuffer
implements InputBuffer {
    private final InputBuffer buffer;
    private int[] inserts = new int[0];
    private char[] chars = new char[0];

    public MutableInputBuffer(InputBuffer inputBuffer) {
        this.buffer = inputBuffer;
    }

    @Override
    public char charAt(int n) {
        int n2 = Arrays.binarySearch(this.inserts, n);
        if (n2 >= 0) {
            return this.chars[n2];
        }
        return this.buffer.charAt(n + (n2 + 1));
    }

    @Override
    public boolean test(int n, char[] cArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Position getPosition(int n) {
        return this.buffer.getPosition(this.map(n));
    }

    @Override
    public int getOriginalIndex(int n) {
        return this.buffer.getOriginalIndex(this.map(n));
    }

    @Override
    public String extractLine(int n) {
        return this.buffer.extractLine(n);
    }

    @Override
    public String extract(int n, int n2) {
        return this.buffer.extract(this.map(n), this.map(n2));
    }

    @Override
    public String extract(IndexRange indexRange) {
        return this.buffer.extract(this.map(indexRange.start), this.map(indexRange.end));
    }

    @Override
    public int getLineCount() {
        return this.buffer.getLineCount();
    }

    private int map(int n) {
        int n2 = Arrays.binarySearch(this.inserts, n);
        if (n2 < 0) {
            n2 = -(n2 + 1);
        }
        return n - n2;
    }

    public void insertChar(int n, char c) {
        int n2 = Arrays.binarySearch(this.inserts, n);
        if (n2 < 0) {
            n2 = -(n2 + 1);
        }
        char[] cArray = new char[this.chars.length + 1];
        System.arraycopy(this.chars, 0, cArray, 0, n2);
        cArray[n2] = c;
        System.arraycopy(this.chars, n2, cArray, n2 + 1, this.chars.length - n2);
        this.chars = cArray;
        int[] nArray = new int[this.inserts.length + 1];
        System.arraycopy(this.inserts, 0, nArray, 0, n2);
        nArray[n2] = n;
        for (int i = n2; i < this.inserts.length; ++i) {
            nArray[i + 1] = this.inserts[i] + 1;
        }
        this.inserts = nArray;
    }

    public char undoCharInsertion(int n) {
        int n2 = Arrays.binarySearch(this.inserts, n);
        Preconditions.checkArgument(n2 >= 0, "Cannot undo a non-existing insertion");
        char c = this.chars[n2];
        char[] cArray = new char[this.chars.length - 1];
        System.arraycopy(this.chars, 0, cArray, 0, n2);
        System.arraycopy(this.chars, n2 + 1, cArray, n2, cArray.length - n2);
        this.chars = cArray;
        int[] nArray = new int[this.inserts.length - 1];
        System.arraycopy(this.inserts, 0, nArray, 0, n2);
        for (int i = n2 + 1; i < this.inserts.length; ++i) {
            nArray[i - 1] = this.inserts[i] - 1;
        }
        this.inserts = nArray;
        return c;
    }

    public void replaceInsertedChar(int n, char c) {
        int n2 = Arrays.binarySearch(this.inserts, n);
        Preconditions.checkArgument(n2 >= 0, "Can only replace chars that were previously inserted");
        this.chars[n2] = c;
    }
}

