/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.parboiled.common.Preconditions;
import org.parboiled.support.Checks;
import org.parboiled.transform.InstructionGraphNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.Types;

class RuleMethodInterpreter
extends BasicInterpreter {
    private final RuleMethod method;
    private final List<Edge> additionalEdges = new ArrayList<Edge>();

    public RuleMethodInterpreter(RuleMethod ruleMethod) {
        super(458752);
        this.method = ruleMethod;
    }

    @Override
    public BasicValue newValue(Type type) {
        BasicValue basicValue = super.newValue(type);
        if (basicValue == BasicValue.REFERENCE_VALUE) {
            basicValue = new BasicValue(type);
        }
        return basicValue;
    }

    @Override
    public BasicValue newOperation(AbstractInsnNode abstractInsnNode) throws AnalyzerException {
        return this.createNode(abstractInsnNode, super.newOperation(abstractInsnNode), new BasicValue[0]);
    }

    @Override
    public BasicValue copyOperation(AbstractInsnNode abstractInsnNode, BasicValue basicValue) throws AnalyzerException {
        return this.createNode(abstractInsnNode, super.copyOperation(abstractInsnNode, basicValue), basicValue);
    }

    @Override
    public BasicValue unaryOperation(AbstractInsnNode abstractInsnNode, BasicValue basicValue) throws AnalyzerException {
        return this.createNode(abstractInsnNode, super.unaryOperation(abstractInsnNode, (BasicValue)null), basicValue);
    }

    @Override
    public BasicValue binaryOperation(AbstractInsnNode abstractInsnNode, BasicValue basicValue, BasicValue basicValue2) throws AnalyzerException {
        return this.createNode(abstractInsnNode, super.binaryOperation(abstractInsnNode, (BasicValue)null, (BasicValue)null), basicValue, basicValue2);
    }

    @Override
    public BasicValue ternaryOperation(AbstractInsnNode abstractInsnNode, BasicValue basicValue, BasicValue basicValue2, BasicValue basicValue3) throws AnalyzerException {
        this.additionalEdges.add(new Edge(abstractInsnNode, this.findArrayCreatorPredecessor(basicValue)));
        return this.createNode(abstractInsnNode, super.ternaryOperation(abstractInsnNode, (BasicValue)null, (BasicValue)null, (BasicValue)null), basicValue, basicValue2, basicValue3);
    }

    @Override
    public BasicValue naryOperation(AbstractInsnNode abstractInsnNode, List list) throws AnalyzerException {
        return this.createNode(abstractInsnNode, (BasicValue)super.naryOperation(abstractInsnNode, (List)null), list.toArray(new BasicValue[list.size()]));
    }

    @Override
    public void returnOperation(AbstractInsnNode abstractInsnNode, BasicValue basicValue, BasicValue basicValue2) throws AnalyzerException {
        Preconditions.checkState(abstractInsnNode.getOpcode() == 176);
        Preconditions.checkState(this.unwrap(basicValue).getType().equals(Types.RULE));
        Preconditions.checkState(this.unwrap(basicValue2).getType().equals(Types.RULE));
        Preconditions.checkState(this.method.getReturnInstructionNode() == null);
        this.method.setReturnInstructionNode(this.createNode(abstractInsnNode, null, basicValue));
    }

    private InstructionGraphNode createNode(AbstractInsnNode abstractInsnNode, BasicValue basicValue, BasicValue ... basicValueArray) {
        return this.method.setGraphNode(abstractInsnNode, this.unwrap(basicValue), Arrays.asList(basicValueArray));
    }

    @Override
    public BasicValue merge(BasicValue basicValue, BasicValue basicValue2) {
        return basicValue;
    }

    public void newControlFlowEdge(int n, int n2) {
        AbstractInsnNode abstractInsnNode = this.method.instructions.get(n);
        AbstractInsnNode abstractInsnNode2 = this.method.instructions.get(n2);
        if (abstractInsnNode.getType() == 8 || abstractInsnNode.getType() == 7 || abstractInsnNode2.getType() == 8 || abstractInsnNode2.getType() == 7) {
            this.additionalEdges.add(new Edge(abstractInsnNode, abstractInsnNode2));
        }
    }

    private AbstractInsnNode findArrayCreatorPredecessor(BasicValue basicValue) {
        int n;
        String string = "Internal error during analysis of rule method '" + this.method.name + "', please report this error to info@parboiled.org! Thank you!";
        Checks.ensure(basicValue instanceof InstructionGraphNode, string);
        InstructionGraphNode instructionGraphNode = (InstructionGraphNode)basicValue;
        while ((n = instructionGraphNode.getInstruction().getOpcode()) != 189 && n != 188 && n != 197) {
            Checks.ensure(instructionGraphNode.getPredecessors().size() == 1, string);
            instructionGraphNode = instructionGraphNode.getPredecessors().get(0);
        }
        return instructionGraphNode.getInstruction();
    }

    public void finish() {
        for (Edge edge : this.additionalEdges) {
            InstructionGraphNode instructionGraphNode;
            InstructionGraphNode instructionGraphNode2 = this.getGraphNode(edge.from);
            if (instructionGraphNode2 == null) {
                instructionGraphNode2 = this.createNode(edge.from, null, new BasicValue[0]);
            }
            if ((instructionGraphNode = this.getGraphNode(edge.to)) == null) {
                instructionGraphNode = this.createNode(edge.to, null, new BasicValue[0]);
            }
            instructionGraphNode.addPredecessor(instructionGraphNode2);
        }
    }

    private InstructionGraphNode getGraphNode(AbstractInsnNode abstractInsnNode) {
        return this.method.getGraphNodes().get(this.method.instructions.indexOf(abstractInsnNode));
    }

    private BasicValue unwrap(BasicValue basicValue) {
        return basicValue != null && basicValue instanceof InstructionGraphNode ? ((InstructionGraphNode)basicValue).getResultValue() : basicValue;
    }

    private class Edge {
        public final AbstractInsnNode from;
        public final AbstractInsnNode to;

        public Edge(AbstractInsnNode abstractInsnNode, AbstractInsnNode abstractInsnNode2) {
            this.from = abstractInsnNode;
            this.to = abstractInsnNode2;
        }
    }
}

