/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.base.Objects;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParseException;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.transport.KeyHolder;
import org.apache.james.transport.SMIMEAttributeNames;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeUtils;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSign
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSign.class);
    private static final String HEADERS_PATTERN = "[headers]";
    private static final String SIGNER_NAME_PATTERN = "[signerName]";
    private static final String SIGNER_ADDRESS_PATTERN = "[signerAddress]";
    private static final String REVERSE_PATH_PATTERN = "[reversePath]";
    private boolean debug;
    private Class<?> keyHolderClass;
    private String explanationText;
    private KeyHolder keyHolder;
    private boolean postmasterSigns;
    private boolean rebuildFrom;
    private String signerName;
    @Inject
    private UsersRepository usersRepository;

    protected abstract Set<String> getAllowedInitParameters();

    protected void initDebug() {
        this.setDebug(this.getInitParameter("debug") == null ? false : Boolean.parseBoolean(this.getInitParameter("debug")));
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    protected void initKeyHolderClass() throws MessagingException {
        String keyHolderClassName = this.getInitParameter("keyHolderClass");
        if (keyHolderClassName == null) {
            throw new MessagingException("<keyHolderClass> parameter missing.");
        }
        try {
            this.setKeyHolderClass(Class.forName(keyHolderClassName));
        }
        catch (ClassNotFoundException cnfe) {
            throw new MessagingException("The specified <keyHolderClass> does not exist: " + keyHolderClassName);
        }
        if (this.isDebug()) {
            LOGGER.debug("keyHolderClass: {}", (Object)this.getKeyHolderClass());
        }
    }

    public Class<?> getKeyHolderClass() {
        return this.keyHolderClass;
    }

    public void setKeyHolderClass(Class<?> keyHolderClass) {
        this.keyHolderClass = keyHolderClass;
    }

    protected void initExplanationText() {
        this.setExplanationText(this.getInitParameter("explanationText"));
        if (this.isDebug() && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Explanation text:\r\n" + this.getExplanationText());
        }
    }

    public String getExplanationText() {
        return this.explanationText;
    }

    public void setExplanationText(String explanationText) {
        this.explanationText = explanationText;
    }

    protected void initKeyHolder() throws Exception {
        String keyAlias;
        String keyStoreType;
        Constructor<?> keyHolderConstructor;
        try {
            keyHolderConstructor = this.keyHolderClass.getConstructor(String.class, String.class, String.class, String.class, String.class);
        }
        catch (NoSuchMethodException nsme) {
            throw new MessagingException("The needed constructor does not exist: " + this.keyHolderClass + "(String, String, String, String, String)");
        }
        String keyStoreFileName = this.getInitParameter("keyStoreFileName");
        if (keyStoreFileName == null) {
            throw new MessagingException("<keyStoreFileName> parameter missing.");
        }
        String keyStorePassword = this.getInitParameter("keyStorePassword");
        if (keyStorePassword == null) {
            throw new MessagingException("<keyStorePassword> parameter missing.");
        }
        String keyAliasPassword = this.getInitParameter("keyAliasPassword");
        if (keyAliasPassword == null) {
            keyAliasPassword = keyStorePassword;
            if (this.isDebug()) {
                LOGGER.debug("<keyAliasPassword> parameter not specified: will default to the <keyStorePassword> parameter.");
            }
        }
        if ((keyStoreType = this.getInitParameter("keyStoreType")) == null && this.isDebug()) {
            LOGGER.debug("<keyStoreType> parameter not specified: the default will be as appropriate to the keyStore requested.");
        }
        if ((keyAlias = this.getInitParameter("keyAlias")) == null && this.isDebug()) {
            LOGGER.debug("<keyAlias> parameter not specified: will look for the first one in the keystore.");
        }
        if (this.isDebug()) {
            LOGGER.debug("KeyStore related parameters: keyStoreFileName={}, keyStoreType={}, keyAlias={}", keyStoreFileName, keyStoreType, keyAlias);
        }
        Object[] parameters = new Object[]{keyStoreFileName, keyStorePassword, keyAlias, keyAliasPassword, keyStoreType};
        this.setKeyHolder((KeyHolder)keyHolderConstructor.newInstance(parameters));
        if (this.isDebug()) {
            LOGGER.debug("Subject Distinguished Name: {}", (Object)this.getKeyHolder().getSignerDistinguishedName());
        }
        if (this.getKeyHolder().getSignerAddress() == null) {
            throw new MessagingException("Signer address missing in the certificate.");
        }
    }

    protected KeyHolder getKeyHolder() {
        return this.keyHolder;
    }

    protected void setKeyHolder(KeyHolder keyHolder) {
        this.keyHolder = keyHolder;
    }

    protected void initPostmasterSigns() {
        this.setPostmasterSigns(this.getInitParameter("postmasterSigns") == null ? false : Boolean.parseBoolean(this.getInitParameter("postmasterSigns")));
    }

    public boolean isPostmasterSigns() {
        return this.postmasterSigns;
    }

    public void setPostmasterSigns(boolean postmasterSigns) {
        this.postmasterSigns = postmasterSigns;
    }

    protected void initRebuildFrom() throws MessagingException {
        this.setRebuildFrom(this.getInitParameter("rebuildFrom") == null ? false : Boolean.parseBoolean(this.getInitParameter("rebuildFrom")));
        if (this.isDebug()) {
            if (this.isRebuildFrom()) {
                LOGGER.debug("Will modify the \"From:\" header.");
            } else {
                LOGGER.debug("Will leave the \"From:\" header unchanged.");
            }
        }
    }

    public boolean isRebuildFrom() {
        return this.rebuildFrom;
    }

    public void setRebuildFrom(boolean rebuildFrom) {
        this.rebuildFrom = rebuildFrom;
    }

    protected void initSignerName() {
        this.setSignerName(this.getInitParameter("signerName"));
        if (this.getSignerName() == null) {
            if (this.getKeyHolder() == null) {
                throw new RuntimeException("initKeyHolder() must be invoked before initSignerName()");
            }
            this.setSignerName(this.getKeyHolder().getSignerCN());
            if (this.isDebug()) {
                LOGGER.debug("<signerName> parameter not specified: will use the certificate signer \"CN=\" attribute.");
            }
        }
    }

    public String getSignerName() {
        return this.signerName;
    }

    public void setSignerName(String signerName) {
        this.signerName = signerName;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void init() throws MessagingException {
        this.checkInitParameters(this.getAllowedInitParameters());
        try {
            this.initDebug();
            if (this.isDebug()) {
                LOGGER.debug("Initializing");
            }
            this.initKeyHolderClass();
            this.initKeyHolder();
            this.initSignerName();
            this.initPostmasterSigns();
            this.initRebuildFrom();
            this.initExplanationText();
            if (!this.isDebug()) return;
        }
        catch (MessagingException me) {
            try {
                throw me;
                catch (Exception e) {
                    LOGGER.error("Exception thrown", e);
                    throw new MessagingException("Exception thrown", e);
                }
            }
            catch (Throwable throwable) {
                if (!this.isDebug()) throw throwable;
                LOGGER.debug("Other parameters: signerName={}, postmasterSigns={}, rebuildFrom={}", this.getSignerName(), this.postmasterSigns, this.rebuildFrom);
                throw throwable;
            }
        }
        LOGGER.debug("Other parameters: signerName={}, postmasterSigns={}, rebuildFrom={}", this.getSignerName(), this.postmasterSigns, this.rebuildFrom);
    }

    @Override
    public void service(Mail mail) throws MessagingException {
        try {
            if (!this.isOkToSign(mail)) {
                return;
            }
            MimeBodyPart wrapperBodyPart = this.getWrapperBodyPart(mail);
            MimeMessage originalMessage = mail.getMessage();
            MimeMultipart signedMimeMultipart = wrapperBodyPart != null ? this.getKeyHolder().generate(wrapperBodyPart) : this.getKeyHolder().generate(originalMessage);
            MimeMessage newMessage = new MimeMessage(Session.getDefaultInstance(System.getProperties(), null));
            Enumeration<String> headerEnum = originalMessage.getAllHeaderLines();
            while (headerEnum.hasMoreElements()) {
                newMessage.addHeaderLine(headerEnum.nextElement());
            }
            newMessage.setSender(new InternetAddress(this.getKeyHolder().getSignerAddress(), this.getSignerName()));
            if (this.isRebuildFrom()) {
                InternetAddress modifiedFromIA = new InternetAddress(this.getKeyHolder().getSignerAddress(), mail.getMaybeSender().asString());
                newMessage.setFrom(modifiedFromIA);
                newMessage.setReplyTo(originalMessage.getReplyTo());
            }
            newMessage.setContent(signedMimeMultipart, signedMimeMultipart.getContentType());
            String messageId = originalMessage.getMessageID();
            newMessage.saveChanges();
            if (messageId != null) {
                newMessage.setHeader("Message-ID", messageId);
            }
            mail.setMessage(newMessage);
            mail.setAttribute(new Attribute(SMIMEAttributeNames.SMIME_SIGNING_MAILET, AttributeValue.of(this.getClass().getName())));
            mail.setAttribute(new Attribute(SMIMEAttributeNames.SMIME_SIGNATURE_VALIDITY, AttributeValue.of("valid")));
            mail.setAttribute(new Attribute(SMIMEAttributeNames.SMIME_SIGNER_ADDRESS, AttributeValue.of(this.getKeyHolder().getSignerAddress())));
            if (this.isDebug()) {
                LOGGER.debug("Message signed, reverse-path: {}, Id: {}", (Object)mail.getMaybeSender().asString(), (Object)messageId);
            }
        }
        catch (MessagingException me) {
            LOGGER.error("MessagingException found - could not sign!", me);
            throw me;
        }
        catch (Exception e) {
            LOGGER.error("Exception found", e);
            throw new MessagingException("Exception thrown - could not sign!", e);
        }
    }

    protected boolean isOkToSign(Mail mail) throws MessagingException {
        MimeMessage mimeMessage;
        boolean isAlreadySigned;
        if (!mail.hasSender()) {
            LOGGER.info("Can not sign: no sender");
            return false;
        }
        MailAddress reversePath = mail.getMaybeSender().get();
        Optional<String> fetchedAuthUser = AttributeUtils.getValueAndCastFromMail(mail, Mail.SMTP_AUTH_USER, String.class);
        if (!fetchedAuthUser.isPresent()) {
            LOGGER.info("Can not sign mail for sender <{}> as he is not a SMTP authenticated user", (Object)mail.getMaybeSender().asString());
            return false;
        }
        Username authUser = Username.of(fetchedAuthUser.get());
        if (Objects.equal(this.getMailetContext().getPostmaster(), reversePath)) {
            if (!this.isPostmasterSigns()) {
                LOGGER.info("Can not sign mails for postmaster");
                return false;
            }
        } else {
            Username username = this.getUsername(reversePath);
            if (!username.equals(authUser)) {
                LOGGER.info("SMTP logged in as <{}> but pretend to be sender <{}>", (Object)authUser.asString(), (Object)username.asString());
                return false;
            }
            if (!this.fromAddressSameAsReverse(mail)) {
                LOGGER.info("Can not sign mails with empty FROM header field");
                return false;
            }
        }
        boolean bl = isAlreadySigned = (mimeMessage = mail.getMessage()).isMimeType("multipart/signed") || mimeMessage.isMimeType("application/pkcs7-mime");
        if (isAlreadySigned) {
            LOGGER.info("Can not sign a mail already signed");
        }
        return !isAlreadySigned;
    }

    private Username getUsername(MailAddress mailAddress) {
        try {
            return this.usersRepository.getUsername(mailAddress);
        }
        catch (UsersRepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract MimeBodyPart getWrapperBodyPart(Mail var1) throws MessagingException, IOException;

    protected final boolean fromAddressSameAsReverse(Mail mail) {
        block6: {
            if (!mail.hasSender()) {
                return false;
            }
            MailAddress reversePath = mail.getMaybeSender().get();
            try {
                InternetAddress[] fromArray = (InternetAddress[])mail.getMessage().getFrom();
                if (fromArray == null) break block6;
                for (InternetAddress aFromArray : fromArray) {
                    MailAddress mailAddress;
                    try {
                        mailAddress = new MailAddress(aFromArray);
                    }
                    catch (ParseException pe) {
                        LOGGER.info("Unable to parse a \"FROM\" header address: {}; ignoring.", (Object)aFromArray);
                        continue;
                    }
                    if (!mailAddress.equals(reversePath)) continue;
                    return true;
                }
            }
            catch (MessagingException me) {
                LOGGER.info("Unable to parse the \"FROM\" header; ignoring.");
            }
        }
        return false;
    }

    protected final String getMessageHeaders(MimeMessage message) throws MessagingException {
        Enumeration<String> heads = message.getAllHeaderLines();
        StringBuilder headBuffer = new StringBuilder(1024);
        while (heads.hasMoreElements()) {
            headBuffer.append(heads.nextElement()).append("\r\n");
        }
        return headBuffer.toString();
    }

    protected final String getReplacedExplanationText(String explanationText, String signerName, String signerAddress, String reversePath, String headers) {
        String replacedExplanationText = explanationText;
        replacedExplanationText = this.getReplacedString(replacedExplanationText, SIGNER_NAME_PATTERN, signerName);
        replacedExplanationText = this.getReplacedString(replacedExplanationText, SIGNER_ADDRESS_PATTERN, signerAddress);
        replacedExplanationText = this.getReplacedString(replacedExplanationText, REVERSE_PATH_PATTERN, reversePath);
        replacedExplanationText = this.getReplacedString(replacedExplanationText, HEADERS_PATTERN, headers);
        return replacedExplanationText;
    }

    private String getReplacedString(String template, String pattern, String actual) {
        if (actual != null) {
            int index;
            StringBuilder sb = new StringBuilder(template.length());
            int fromIndex = 0;
            while ((index = template.indexOf(pattern, fromIndex)) >= 0) {
                sb.append(template, fromIndex, index);
                sb.append(actual);
                fromIndex = index + pattern.length();
            }
            if (fromIndex < template.length()) {
                sb.append(template.substring(fromIndex));
            }
            return sb.toString();
        }
        return template;
    }
}

