/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.data.jmap;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import org.apache.james.core.Username;
import org.apache.james.json.DTOModule;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.apache.james.webadmin.data.jmap.MessageFastViewProjectionCorrector;
import org.apache.james.webadmin.data.jmap.RunningOptions;
import org.apache.james.webadmin.data.jmap.RunningOptionsDTO;

public class RecomputeUserFastViewProjectionItemsTask
implements Task {
    static final TaskType TASK_TYPE = TaskType.of((String)"RecomputeUserFastViewProjectionItemsTask");
    private final MessageFastViewProjectionCorrector corrector;
    private final RunningOptions runningOptions;
    private final MessageFastViewProjectionCorrector.Progress progress;
    private final Username username;

    public static TaskDTOModule<RecomputeUserFastViewProjectionItemsTask, RecomputeUserFastViewTaskDTO> module(MessageFastViewProjectionCorrector corrector) {
        return (TaskDTOModule)DTOModule.forDomainObject(RecomputeUserFastViewProjectionItemsTask.class).convertToDTO(RecomputeUserFastViewTaskDTO.class).toDomainObjectConverter(dto -> RecomputeUserFastViewProjectionItemsTask.asTask(corrector, dto)).toDTOConverter(RecomputeUserFastViewProjectionItemsTask::asDTO).typeName(TASK_TYPE.asString()).withFactory(TaskDTOModule::new);
    }

    private static RecomputeUserFastViewTaskDTO asDTO(RecomputeUserFastViewProjectionItemsTask task, String type) {
        return new RecomputeUserFastViewTaskDTO(type, task.username.asString(), Optional.of(RunningOptionsDTO.asDTO(task.runningOptions)));
    }

    private static RecomputeUserFastViewProjectionItemsTask asTask(MessageFastViewProjectionCorrector corrector, RecomputeUserFastViewTaskDTO dto) {
        return new RecomputeUserFastViewProjectionItemsTask(corrector, dto.getRunningOptions().map(RunningOptionsDTO::asDomainObject).orElse(RunningOptions.DEFAULT), Username.of((String)dto.username));
    }

    RecomputeUserFastViewProjectionItemsTask(MessageFastViewProjectionCorrector corrector, RunningOptions runningOptions, Username username) {
        this.corrector = corrector;
        this.runningOptions = runningOptions;
        this.username = username;
        this.progress = new MessageFastViewProjectionCorrector.Progress();
    }

    public Task.Result run() {
        return (Task.Result)this.corrector.correctUsersProjectionItems(this.progress, this.username, this.runningOptions).block();
    }

    public TaskType type() {
        return TASK_TYPE;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(AdditionalInformation.from(this.progress, this.runningOptions, this.username));
    }

    public static class RecomputeUserFastViewTaskDTO
    implements TaskDTO {
        private final String type;
        private final String username;
        private final Optional<RunningOptionsDTO> runningOptions;

        public RecomputeUserFastViewTaskDTO(@JsonProperty(value="type") String type, @JsonProperty(value="username") String username, @JsonProperty(value="runningOptions") Optional<RunningOptionsDTO> runningOptions) {
            this.type = type;
            this.username = username;
            this.runningOptions = runningOptions;
        }

        public String getType() {
            return this.type;
        }

        public String getUsername() {
            return this.username;
        }

        public Optional<RunningOptionsDTO> getRunningOptions() {
            return this.runningOptions;
        }
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final RunningOptions runningOptions;
        private final Username username;
        private final long processedMessageCount;
        private final long failedMessageCount;
        private final Instant timestamp;

        private static AdditionalInformation from(MessageFastViewProjectionCorrector.Progress progress, RunningOptions runningOptions, Username username) {
            return new AdditionalInformation(runningOptions, username, progress.getProcessedMessageCount(), progress.getFailedMessageCount(), Clock.systemUTC().instant());
        }

        public AdditionalInformation(RunningOptions runningOptions, Username username, long processedMessageCount, long failedMessageCount, Instant timestamp) {
            this.runningOptions = runningOptions;
            this.username = username;
            this.processedMessageCount = processedMessageCount;
            this.failedMessageCount = failedMessageCount;
            this.timestamp = timestamp;
        }

        public RunningOptions getRunningOptions() {
            return this.runningOptions;
        }

        public long getProcessedMessageCount() {
            return this.processedMessageCount;
        }

        public long getFailedMessageCount() {
            return this.failedMessageCount;
        }

        public String getUsername() {
            return this.username.asString();
        }

        public Instant timestamp() {
            return this.timestamp;
        }
    }
}

