/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.event.json.MailboxEventSerializer;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventListener;
import org.apache.james.events.EventSerializer;
import org.apache.james.events.InVMEventBus;
import org.apache.james.events.RetryBackoffConfiguration;
import org.apache.james.events.delivery.EventDelivery;
import org.apache.james.events.delivery.InVmEventDelivery;
import org.apache.james.modules.EventDeadLettersProbe;
import org.apache.james.modules.mailbox.ListenersConfiguration;
import org.apache.james.modules.mailbox.MailboxListenerFactory;
import org.apache.james.modules.mailbox.MailboxListenersLoader;
import org.apache.james.modules.mailbox.MailboxListenersLoaderImpl;
import org.apache.james.server.core.configuration.ConfigurationProvider;
import org.apache.james.utils.GuiceProbe;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;

public class DefaultEventModule
extends AbstractModule {
    protected void configure() {
        this.bind(MailboxEventSerializer.class).in(Scopes.SINGLETON);
        this.bind(EventSerializer.class).to(MailboxEventSerializer.class);
        this.bind(MailboxListenerFactory.class).in(Scopes.SINGLETON);
        this.bind(MailboxListenersLoaderImpl.class).in(Scopes.SINGLETON);
        this.bind(InVmEventDelivery.class).in(Scopes.SINGLETON);
        this.bind(InVMEventBus.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)this.binder(), GuiceProbe.class).addBinding().to(EventDeadLettersProbe.class);
        this.bind(MailboxListenersLoader.class).to(MailboxListenersLoaderImpl.class);
        this.bind(EventDelivery.class).to(InVmEventDelivery.class);
        this.bind(EventBus.class).to(InVMEventBus.class);
        Multibinder.newSetBinder((Binder)this.binder(), EventBus.class).addBinding().to(EventBus.class);
        this.bind(RetryBackoffConfiguration.class).toInstance((Object)RetryBackoffConfiguration.DEFAULT);
        Multibinder.newSetBinder((Binder)this.binder(), EventListener.GroupEventListener.class);
        Multibinder.newSetBinder((Binder)this.binder(), EventListener.ReactiveGroupEventListener.class);
    }

    @Provides
    @Singleton
    ListenersConfiguration providesConfiguration(ConfigurationProvider configurationProvider) throws ConfigurationException {
        return ListenersConfiguration.from((HierarchicalConfiguration<ImmutableNode>)configurationProvider.getConfiguration("listeners"));
    }

    @ProvidesIntoSet
    InitializationOperation registerListeners(MailboxListenersLoaderImpl listeners, ListenersConfiguration configuration) {
        return InitilizationOperationBuilder.forClass(MailboxListenersLoaderImpl.class).init(() -> listeners.configure(configuration));
    }
}

