/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.message.DefaultMessageBuilder;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.util.html.HtmlTextExtractor;
import org.apache.james.util.mime.MessageContentExtractor;

public class Preview {
    public static final Preview EMPTY = Preview.from("");
    private static final int MAX_LENGTH = 256;
    private final String value;

    public static Preview from(String value) {
        return new Preview(value);
    }

    public static Preview compute(String textBody) {
        int previewOffsetEstimate = Preview.estimatePreviewOffset(textBody, 256);
        String previewPart = textBody.substring(0, previewOffsetEstimate);
        String normalizeSpace = StringUtils.normalizeSpace((String)previewPart);
        String truncateToMaxLength = Preview.truncateToMaxLength(normalizeSpace);
        return Preview.from(Preview.sanitizeUTF8String(truncateToMaxLength));
    }

    private static String sanitizeUTF8String(String truncateToMaxLength) {
        CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder();
        while (!encoder.canEncode(truncateToMaxLength)) {
            truncateToMaxLength = truncateToMaxLength.substring(0, truncateToMaxLength.length() - 1);
        }
        return truncateToMaxLength;
    }

    private static String truncateToMaxLength(String body) {
        return StringUtils.left((String)body, (int)256);
    }

    private static int estimatePreviewOffset(String body, int charCount) {
        int position;
        int nonWhitespace = 0;
        for (position = 0; position < body.length() && nonWhitespace < charCount; ++position) {
            if (!Character.isLetterOrDigit(body.charAt(position))) continue;
            ++nonWhitespace;
        }
        return position;
    }

    @VisibleForTesting
    Preview(String value) {
        Preconditions.checkNotNull((Object)value);
        Preconditions.checkArgument((value.length() <= 256 ? 1 : 0) != 0, (String)"the preview value '%s' has length longer than %s", (Object)value, (int)256);
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public final boolean equals(Object o) {
        if (o instanceof Preview) {
            Preview preview = (Preview)o;
            return Objects.equals(this.value, preview.value);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).toString();
    }

    public static class Factory {
        private final MessageContentExtractor messageContentExtractor;
        private final HtmlTextExtractor htmlTextExtractor;

        @Inject
        public Factory(MessageContentExtractor messageContentExtractor, HtmlTextExtractor htmlTextExtractor) {
            this.messageContentExtractor = messageContentExtractor;
            this.htmlTextExtractor = htmlTextExtractor;
        }

        public Preview fromMessageResult(MessageResult messageResult) throws MailboxException, IOException {
            try (InputStream inputStream = messageResult.getFullContent().getInputStream();){
                Preview preview = this.fromInputStream(inputStream);
                return preview;
            }
        }

        public Preview fromMessageAsString(String messageAsString) throws IOException {
            return this.fromInputStream(new ByteArrayInputStream(messageAsString.getBytes(StandardCharsets.UTF_8)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Preview fromInputStream(InputStream inputStream) throws IOException {
            Message message = this.parse(inputStream);
            try {
                Preview preview = this.fromMime4JMessage(message);
                return preview;
            }
            finally {
                message.dispose();
            }
        }

        public Preview fromMime4JMessage(Message mimeMessage) throws IOException {
            MessageContentExtractor.MessageContent messageContent = this.messageContentExtractor.extract(mimeMessage);
            return messageContent.extractMainTextContent(this.htmlTextExtractor).map(Preview::compute).orElse(EMPTY);
        }

        private Message parse(InputStream inputStream) throws IOException {
            DefaultMessageBuilder defaultMessageBuilder = new DefaultMessageBuilder();
            defaultMessageBuilder.setMimeEntityConfig(MimeConfig.PERMISSIVE);
            return defaultMessageBuilder.parseMessage(inputStream);
        }
    }
}

