/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.netty;

import io.netty.channel.ChannelHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.concurrent.EventExecutorGroup;
import java.util.function.Supplier;
import org.apache.james.protocols.netty.AbstractChannelPipelineFactory;
import org.apache.james.protocols.netty.ChannelHandlerFactory;
import org.apache.james.protocols.netty.Encryption;

@ChannelHandler.Sharable
public abstract class AbstractSSLAwareChannelPipelineFactory<C extends SocketChannel>
extends AbstractChannelPipelineFactory<C> {
    private final boolean proxyRequired;
    private Supplier<Encryption> secure;

    public AbstractSSLAwareChannelPipelineFactory(int timeout, int maxConnections, int maxConnectsPerIp, boolean proxyRequired, ChannelHandlerFactory frameHandlerFactory, EventExecutorGroup eventExecutorGroup) {
        super(timeout, maxConnections, maxConnectsPerIp, proxyRequired, frameHandlerFactory, eventExecutorGroup);
        this.proxyRequired = proxyRequired;
    }

    public AbstractSSLAwareChannelPipelineFactory(int timeout, int maxConnections, int maxConnectsPerIp, boolean proxyRequired, Supplier<Encryption> secure, ChannelHandlerFactory frameHandlerFactory, EventExecutorGroup eventExecutorGroup) {
        this(timeout, maxConnections, maxConnectsPerIp, proxyRequired, frameHandlerFactory, eventExecutorGroup);
        this.secure = secure;
    }

    @Override
    public void initChannel(C channel) throws Exception {
        super.initChannel(channel);
        if (this.isSSLSocket()) {
            if (this.proxyRequired) {
                channel.pipeline().addAfter("proxyHandler", "sslHandler", (ChannelHandler)this.secure.get().sslHandler());
            } else {
                channel.pipeline().addFirst("sslHandler", (ChannelHandler)this.secure.get().sslHandler());
            }
        }
    }

    protected boolean isSSLSocket() {
        Encryption encryption = this.secure.get();
        return encryption != null && encryption.supportsEncryption() && !encryption.isStartTLS();
    }
}

