/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.jmap.draft.methods.JmapRequest;
import org.apache.james.jmap.draft.methods.JmapResponse;
import org.apache.james.jmap.draft.methods.Method;
import org.apache.james.jmap.draft.methods.SetMessagesProcessor;
import org.apache.james.jmap.draft.model.MethodCallId;
import org.apache.james.jmap.draft.model.SetMessagesRequest;
import org.apache.james.jmap.draft.model.SetMessagesResponse;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public class SetMessagesMethod
implements Method {
    private static final Method.Request.Name METHOD_NAME = Method.Request.name("setMessages");
    private static final Method.Response.Name RESPONSE_NAME = Method.Response.name("messagesSet");
    private final Set<SetMessagesProcessor> messagesProcessors;

    @Inject
    @VisibleForTesting
    SetMessagesMethod(Set<SetMessagesProcessor> messagesProcessors) {
        this.messagesProcessors = messagesProcessors;
    }

    @Override
    public Method.Request.Name requestHandled() {
        return METHOD_NAME;
    }

    @Override
    public Class<? extends JmapRequest> requestType() {
        return SetMessagesRequest.class;
    }

    @Override
    public Flux<JmapResponse> process(JmapRequest request, MethodCallId methodCallId, MailboxSession mailboxSession) {
        Preconditions.checkArgument((boolean)(request instanceof SetMessagesRequest));
        SetMessagesRequest setMessagesRequest = (SetMessagesRequest)request;
        return this.setMessagesResponse(setMessagesRequest, mailboxSession).map(responses -> JmapResponse.builder().methodCallId(methodCallId).response((Method.Response)responses).responseName(RESPONSE_NAME).build()).flux().contextWrite((ContextView)ReactorUtils.context((String)"action", (MDCBuilder)this.mdc(setMessagesRequest)));
    }

    private MDCBuilder mdc(SetMessagesRequest setMessagesRequest) {
        return MDCBuilder.create().addToContext("action", "SET_MESSAGES").addToContextIfPresent("accountId", setMessagesRequest.getAccountId()).addToContext("create", setMessagesRequest.getCreate().toString()).addToContext("destroy", setMessagesRequest.getDestroy().toString()).addToContextIfPresent("ifInState", setMessagesRequest.getIfInState());
    }

    private Mono<SetMessagesResponse> setMessagesResponse(SetMessagesRequest request, MailboxSession mailboxSession) {
        return Flux.fromIterable(this.messagesProcessors).flatMap(processor -> processor.processReactive(request, mailboxSession)).reduce((Object)SetMessagesResponse.builder(), (builder, resp) -> resp.mergeInto((SetMessagesResponse.Builder)builder)).map(SetMessagesResponse.Builder::build);
    }
}

