/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.mail.Flags;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.Username;
import org.apache.james.jmap.draft.exceptions.InvalidOutboxMoveException;
import org.apache.james.jmap.draft.methods.MailboxSendingNotAllowedException;
import org.apache.james.jmap.draft.methods.MessageSender;
import org.apache.james.jmap.draft.methods.ReferenceUpdater;
import org.apache.james.jmap.draft.methods.SetMessagesProcessor;
import org.apache.james.jmap.draft.methods.UpdateMessagePatchConverter;
import org.apache.james.jmap.draft.methods.ValidationResult;
import org.apache.james.jmap.draft.model.Keyword;
import org.apache.james.jmap.draft.model.Keywords;
import org.apache.james.jmap.draft.model.MessageProperties;
import org.apache.james.jmap.draft.model.SetError;
import org.apache.james.jmap.draft.model.SetMessagesRequest;
import org.apache.james.jmap.draft.model.SetMessagesResponse;
import org.apache.james.jmap.draft.model.UpdateMessagePatch;
import org.apache.james.jmap.draft.utils.KeywordsCombiner;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.SystemMailboxesProvider;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.OverQuotaException;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMoves;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.rrt.api.CanSendFrom;
import org.apache.james.server.core.MailImpl;
import org.apache.james.util.ReactorUtils;
import org.apache.james.util.StreamUtils;
import org.apache.mailet.Mail;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SetMessagesUpdateProcessor
implements SetMessagesProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SetMessagesUpdateProcessor.class);
    private final UpdateMessagePatchConverter updatePatchConverter;
    private final MessageIdManager messageIdManager;
    private final MailboxManager mailboxManager;
    private final SystemMailboxesProvider systemMailboxesProvider;
    private final MailboxId.Factory mailboxIdFactory;
    private final MetricFactory metricFactory;
    private final MessageSender messageSender;
    private final ReferenceUpdater referenceUpdater;
    private final CanSendFrom canSendFrom;

    @Inject
    @VisibleForTesting
    SetMessagesUpdateProcessor(UpdateMessagePatchConverter updatePatchConverter, MessageIdManager messageIdManager, MailboxManager mailboxManager, SystemMailboxesProvider systemMailboxesProvider, MailboxId.Factory mailboxIdFactory, MessageSender messageSender, MetricFactory metricFactory, ReferenceUpdater referenceUpdater, CanSendFrom canSendFrom) {
        this.updatePatchConverter = updatePatchConverter;
        this.messageIdManager = messageIdManager;
        this.mailboxManager = mailboxManager;
        this.systemMailboxesProvider = systemMailboxesProvider;
        this.mailboxIdFactory = mailboxIdFactory;
        this.metricFactory = metricFactory;
        this.messageSender = messageSender;
        this.referenceUpdater = referenceUpdater;
        this.canSendFrom = canSendFrom;
    }

    @Override
    public Mono<SetMessagesResponse> processReactive(SetMessagesRequest request, MailboxSession mailboxSession) {
        if (!request.hasUpdates()) {
            return Mono.just((Object)SetMessagesResponse.builder().build());
        }
        return Mono.from((Publisher)this.metricFactory.decoratePublisherWithTimerMetric("JMAP-SetMessagesUpdateProcessor", (Publisher)this.listMailboxIdsForRole(mailboxSession, Role.OUTBOX).flatMap(outboxIds -> this.prepareResponse(request, mailboxSession, (Set<MailboxId>)outboxIds).map(SetMessagesResponse.Builder::build)).onErrorResume(e -> Mono.just((Object)request.buildUpdatePatches(this.updatePatchConverter).entrySet().stream().map(entry -> this.prepareResponseIfCantReadOutboxes((Throwable)e, (MessageId)entry.getKey(), (UpdateMessagePatch)entry.getValue())).reduce(SetMessagesResponse.Builder::mergeWith).orElse(SetMessagesResponse.builder()).build()))));
    }

    private SetMessagesResponse.Builder prepareResponseIfCantReadOutboxes(Throwable e, MessageId id, UpdateMessagePatch patch) {
        if (patch.isValid()) {
            return this.handleMessageUpdateException(id, e);
        }
        return this.handleInvalidRequest(id, patch.getValidationErrors(), patch);
    }

    private Mono<SetMessagesResponse.Builder> prepareResponse(SetMessagesRequest request, MailboxSession mailboxSession, Set<MailboxId> outboxes) {
        Map<MessageId, UpdateMessagePatch> patches = request.buildUpdatePatches(this.updatePatchConverter);
        return Flux.from((Publisher)this.messageIdManager.messagesMetadata(patches.keySet(), mailboxSession)).collect(ImmutableListMultimap.toImmutableListMultimap(metaData -> metaData.getComposedMessageId().getMessageId(), Function.identity())).flatMap(messages -> {
            if (this.isAMassiveFlagUpdate(patches, (Multimap<MessageId, ComposedMessageIdWithMetaData>)messages)) {
                return Mono.fromCallable(() -> this.applyRangedFlagUpdate(patches, (Multimap<MessageId, ComposedMessageIdWithMetaData>)messages, mailboxSession)).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER);
            }
            if (this.isAMassiveMove(patches, (Multimap<MessageId, ComposedMessageIdWithMetaData>)messages)) {
                return Mono.fromCallable(() -> this.applyMove(patches, (Multimap<MessageId, ComposedMessageIdWithMetaData>)messages, mailboxSession)).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER);
            }
            return Flux.fromIterable(patches.entrySet()).flatMap(entry -> {
                if (((UpdateMessagePatch)entry.getValue()).isValid()) {
                    return this.update(outboxes, (MessageId)entry.getKey(), (UpdateMessagePatch)entry.getValue(), mailboxSession, (Multimap<MessageId, ComposedMessageIdWithMetaData>)messages);
                }
                return Mono.just((Object)this.handleInvalidRequest((MessageId)entry.getKey(), ((UpdateMessagePatch)entry.getValue()).getValidationErrors(), (UpdateMessagePatch)entry.getValue()));
            }).reduce(SetMessagesResponse.Builder::mergeWith).switchIfEmpty(Mono.just((Object)SetMessagesResponse.builder()));
        });
    }

    private boolean isAMassiveFlagUpdate(Map<MessageId, UpdateMessagePatch> patches, Multimap<MessageId, ComposedMessageIdWithMetaData> messages) {
        return StreamUtils.isSingleValued(patches.values().stream()) && StreamUtils.isSingleValued(messages.values().stream().map(metaData -> metaData.getComposedMessageId().getMailboxId())) && patches.values().iterator().next().isOnlyAFlagUpdate() && messages.size() > 3;
    }

    private boolean isAMassiveMove(Map<MessageId, UpdateMessagePatch> patches, Multimap<MessageId, ComposedMessageIdWithMetaData> messages) {
        return StreamUtils.isSingleValued(patches.values().stream()) && StreamUtils.isSingleValued(messages.values().stream().map(metaData -> metaData.getComposedMessageId().getMailboxId())) && patches.values().iterator().next().isOnlyAMove() && messages.size() > 3;
    }

    private SetMessagesResponse.Builder applyRangedFlagUpdate(Map<MessageId, UpdateMessagePatch> patches, Multimap<MessageId, ComposedMessageIdWithMetaData> messages, MailboxSession mailboxSession) {
        MailboxId mailboxId = ((ComposedMessageIdWithMetaData)messages.values().iterator().next()).getComposedMessageId().getMailboxId();
        UpdateMessagePatch patch = patches.values().iterator().next();
        List uidRanges = MessageRange.toRanges((Collection)((Collection)messages.values().stream().map(metaData -> metaData.getComposedMessageId().getUid()).distinct().collect(ImmutableList.toImmutableList())));
        if (patch.isValid()) {
            return uidRanges.stream().map(range -> {
                ImmutableList messageIds = (ImmutableList)messages.entries().stream().filter(entry -> range.includes(((ComposedMessageIdWithMetaData)entry.getValue()).getComposedMessageId().getUid())).map(Map.Entry::getKey).distinct().collect(ImmutableList.toImmutableList());
                try {
                    this.mailboxManager.getMailbox(mailboxId, mailboxSession).setFlags(patch.applyToState(new Flags()), MessageManager.FlagsUpdateMode.REPLACE, range, mailboxSession);
                    return SetMessagesResponse.builder().updated((List<MessageId>)messageIds);
                }
                catch (MailboxException e) {
                    return messageIds.stream().map(messageId -> this.handleMessageUpdateException((MessageId)messageId, e)).reduce(SetMessagesResponse.Builder::mergeWith).orElse(SetMessagesResponse.builder());
                }
                catch (IllegalArgumentException e) {
                    ValidationResult invalidPropertyKeywords = ValidationResult.builder().property(MessageProperties.MessageProperty.keywords.asFieldName()).message(e.getMessage()).build();
                    return messageIds.stream().map(messageId -> this.handleInvalidRequest((MessageId)messageId, (ImmutableList<ValidationResult>)ImmutableList.of((Object)invalidPropertyKeywords), patch)).reduce(SetMessagesResponse.Builder::mergeWith).orElse(SetMessagesResponse.builder());
                }
            }).reduce(SetMessagesResponse.Builder::mergeWith).orElse(SetMessagesResponse.builder());
        }
        return messages.keySet().stream().map(messageId -> this.handleInvalidRequest((MessageId)messageId, patch.getValidationErrors(), patch)).reduce(SetMessagesResponse.Builder::mergeWith).orElse(SetMessagesResponse.builder());
    }

    private SetMessagesResponse.Builder applyMove(Map<MessageId, UpdateMessagePatch> patches, Multimap<MessageId, ComposedMessageIdWithMetaData> messages, MailboxSession mailboxSession) {
        MailboxId mailboxId = ((ComposedMessageIdWithMetaData)messages.values().iterator().next()).getComposedMessageId().getMailboxId();
        UpdateMessagePatch patch = patches.values().iterator().next();
        List uidRanges = MessageRange.toRanges((Collection)((Collection)messages.values().stream().map(metaData -> metaData.getComposedMessageId().getUid()).distinct().collect(ImmutableList.toImmutableList())));
        if (patch.isValid()) {
            return uidRanges.stream().map(range -> {
                ImmutableList messageIds = (ImmutableList)messages.entries().stream().filter(entry -> range.includes(((ComposedMessageIdWithMetaData)entry.getValue()).getComposedMessageId().getUid())).map(Map.Entry::getKey).distinct().collect(ImmutableList.toImmutableList());
                try {
                    MailboxId targetId = this.mailboxIdFactory.fromString(patch.getMailboxIds().get().iterator().next());
                    this.mailboxManager.moveMessages(range, mailboxId, targetId, mailboxSession);
                    return SetMessagesResponse.builder().updated((List<MessageId>)messageIds);
                }
                catch (MailboxException e) {
                    return messageIds.stream().map(messageId -> this.handleMessageUpdateException((MessageId)messageId, e)).reduce(SetMessagesResponse.Builder::mergeWith).orElse(SetMessagesResponse.builder());
                }
                catch (IllegalArgumentException e) {
                    ValidationResult invalidPropertyKeywords = ValidationResult.builder().property(MessageProperties.MessageProperty.keywords.asFieldName()).message(e.getMessage()).build();
                    return messageIds.stream().map(messageId -> this.handleInvalidRequest((MessageId)messageId, (ImmutableList<ValidationResult>)ImmutableList.of((Object)invalidPropertyKeywords), patch)).reduce(SetMessagesResponse.Builder::mergeWith).orElse(SetMessagesResponse.builder());
                }
            }).reduce(SetMessagesResponse.Builder::mergeWith).orElse(SetMessagesResponse.builder());
        }
        return messages.keySet().stream().map(messageId -> this.handleInvalidRequest((MessageId)messageId, patch.getValidationErrors(), patch)).reduce(SetMessagesResponse.Builder::mergeWith).orElse(SetMessagesResponse.builder());
    }

    private Mono<SetMessagesResponse.Builder> update(Set<MailboxId> outboxes, MessageId messageId, UpdateMessagePatch updateMessagePatch, MailboxSession mailboxSession, Multimap<MessageId, ComposedMessageIdWithMetaData> metadata) {
        try {
            List messages = (List)Optional.ofNullable(metadata.get((Object)messageId)).map(ImmutableList::copyOf).orElse(ImmutableList.of());
            this.assertValidUpdate(messages, updateMessagePatch, outboxes);
            if (messages.isEmpty()) {
                return Mono.just((Object)SetMessagesResponse.builder().mergeWith(this.addMessageIdNotFoundToResponse(messageId)));
            }
            return this.setInMailboxes(messageId, updateMessagePatch, mailboxSession).then(Flux.fromIterable((Iterable)messages).flatMap(message -> this.updateFlags(messageId, updateMessagePatch, mailboxSession, (ComposedMessageIdWithMetaData)message)).then()).then(Mono.just((Object)SetMessagesResponse.builder().updated((List<MessageId>)ImmutableList.of((Object)messageId)))).flatMap(builder -> this.sendMessageWhenOutboxInTargetMailboxIds(outboxes, messageId, updateMessagePatch, mailboxSession).map(builder::mergeWith)).onErrorResume(OverQuotaException.class, e -> Mono.just((Object)SetMessagesResponse.builder().notUpdated(messageId, SetError.builder().type(SetError.Type.MAX_QUOTA_REACHED).description(e.getMessage()).build()))).onErrorResume(MailboxException.class, e -> Mono.just((Object)this.handleMessageUpdateException(messageId, (Throwable)e))).onErrorResume(IOException.class, e -> Mono.just((Object)this.handleMessageUpdateException(messageId, (Throwable)e))).onErrorResume(MessagingException.class, e -> Mono.just((Object)this.handleMessageUpdateException(messageId, (Throwable)e))).onErrorResume(IllegalArgumentException.class, e -> {
                ValidationResult invalidPropertyKeywords = ValidationResult.builder().property(MessageProperties.MessageProperty.keywords.asFieldName()).message(e.getMessage()).build();
                return Mono.just((Object)this.handleInvalidRequest(messageId, (ImmutableList<ValidationResult>)ImmutableList.of((Object)invalidPropertyKeywords), updateMessagePatch));
            });
        }
        catch (InvalidOutboxMoveException e2) {
            ValidationResult invalidPropertyMailboxIds = ValidationResult.builder().property(MessageProperties.MessageProperty.mailboxIds.asFieldName()).message(e2.getMessage()).build();
            return Mono.just((Object)this.handleInvalidRequest(messageId, (ImmutableList<ValidationResult>)ImmutableList.of((Object)invalidPropertyMailboxIds), updateMessagePatch));
        }
    }

    private Mono<SetMessagesResponse.Builder> sendMessageWhenOutboxInTargetMailboxIds(Set<MailboxId> outboxes, MessageId messageId, UpdateMessagePatch updateMessagePatch, MailboxSession mailboxSession) {
        if (this.isTargetingOutbox(outboxes, this.listTargetMailboxIds(updateMessagePatch))) {
            return Mono.from((Publisher)this.messageIdManager.getMessagesReactive((Collection)ImmutableList.of((Object)messageId), FetchGroup.FULL_CONTENT, mailboxSession)).flatMap(messageToSend -> Mono.fromCallable(() -> this.buildMailFromMessage((MessageResult)messageToSend)).flatMap(mail -> this.assertUserCanSendFrom(mailboxSession.getUser(), mail.getMaybeSender().asOptional().map(Username::fromMailAddress)).then(Mono.just((Object)Pair.of((Object)messageToSend, (Object)mail))))).flatMap(Throwing.function(pair -> this.messageSender.sendMessage(messageId, (Mail)pair.getRight(), mailboxSession).then(this.referenceUpdater.updateReferences(((MessageResult)pair.getKey()).getHeaders(), mailboxSession)).thenReturn((Object)SetMessagesResponse.builder())).sneakyThrow()).switchIfEmpty(Mono.just((Object)this.addMessageIdNotFoundToResponse(messageId)));
        }
        return Mono.just((Object)SetMessagesResponse.builder());
    }

    @VisibleForTesting
    Mono<Void> assertUserCanSendFrom(Username connectedUser, Optional<Username> maybeFromUser) {
        return Mono.justOrEmpty(maybeFromUser).flatMap(fromUser -> Mono.from((Publisher)this.canSendFrom.userCanSendFromReactive(connectedUser, fromUser))).filter(Boolean::booleanValue).doOnNext(bool -> LOGGER.debug("{} is allowed to send a mail using {} identity", (Object)connectedUser.asString(), (Object)maybeFromUser)).switchIfEmpty(Mono.error(() -> new MailboxSendingNotAllowedException(connectedUser, maybeFromUser))).then();
    }

    private void assertValidUpdate(List<ComposedMessageIdWithMetaData> messagesToBeUpdated, UpdateMessagePatch updateMessagePatch, Set<MailboxId> outboxMailboxes) {
        ImmutableList previousMailboxes = (ImmutableList)messagesToBeUpdated.stream().map(metaData -> metaData.getComposedMessageId().getMailboxId()).collect(ImmutableList.toImmutableList());
        List<MailboxId> targetMailboxes = this.getTargetedMailboxes((ImmutableList<MailboxId>)previousMailboxes, updateMessagePatch);
        boolean isDraft = messagesToBeUpdated.stream().map(ComposedMessageIdWithMetaData::getFlags).map(Keywords.lenientFactory()::fromFlags).reduce(new KeywordsCombiner()).orElse(Keywords.DEFAULT_VALUE).contains(Keyword.DRAFT);
        MessageMoves messageMoves = MessageMoves.builder().previousMailboxIds((Iterable)previousMailboxes).targetMailboxIds(targetMailboxes).build();
        boolean targetContainsOutbox = messageMoves.addedMailboxIds().stream().anyMatch(outboxMailboxes::contains);
        boolean targetIsOnlyOutbox = targetMailboxes.stream().allMatch(outboxMailboxes::contains);
        this.assertOutboxMoveTargetsOnlyOutBox(targetContainsOutbox, targetIsOnlyOutbox);
        this.assertOutboxMoveOriginallyHasDraftKeywordSet(targetContainsOutbox, isDraft);
    }

    private void assertOutboxMoveTargetsOnlyOutBox(boolean targetContainsOutbox, boolean targetIsOnlyOutbox) {
        if (targetContainsOutbox && !targetIsOnlyOutbox) {
            throw new InvalidOutboxMoveException("When moving a message to Outbox, only Outboxes mailboxes should be targeted.");
        }
    }

    private void assertOutboxMoveOriginallyHasDraftKeywordSet(boolean targetIsOutbox, boolean isDraft) {
        if (targetIsOutbox && !isDraft) {
            throw new InvalidOutboxMoveException("Only message with `$Draft` keyword can be moved to Outbox");
        }
    }

    private List<MailboxId> getTargetedMailboxes(ImmutableList<MailboxId> previousMailboxes, UpdateMessagePatch updateMessagePatch) {
        return (List)updateMessagePatch.getMailboxIds().map(ids -> (ImmutableList)ids.stream().map(arg_0 -> ((MailboxId.Factory)this.mailboxIdFactory).fromString(arg_0)).collect(ImmutableList.toImmutableList())).orElse(previousMailboxes);
    }

    private MailImpl buildMailFromMessage(MessageResult message) throws MessagingException, IOException, MailboxException {
        return MailImpl.fromMimeMessage((String)message.getMessageId().serialize(), (MimeMessage)new MimeMessage(Session.getDefaultInstance((Properties)new Properties()), message.getFullContent().getInputStream()));
    }

    private Set<MailboxId> listTargetMailboxIds(UpdateMessagePatch updateMessagePatch) {
        return (Set)updateMessagePatch.getMailboxIds().stream().flatMap(Collection::stream).map(arg_0 -> ((MailboxId.Factory)this.mailboxIdFactory).fromString(arg_0)).collect(ImmutableSet.toImmutableSet());
    }

    private boolean isTargetingOutbox(Set<MailboxId> outboxes, Set<MailboxId> targetMailboxIds) {
        return targetMailboxIds.stream().anyMatch(outboxes::contains);
    }

    private Mono<Set<MailboxId>> listMailboxIdsForRole(MailboxSession session, Role role) {
        return Flux.from((Publisher)this.systemMailboxesProvider.getMailboxByRole(role, session.getUser())).map(MessageManager::getId).collect(ImmutableSet.toImmutableSet());
    }

    private Mono<Void> updateFlags(MessageId messageId, UpdateMessagePatch updateMessagePatch, MailboxSession mailboxSession, ComposedMessageIdWithMetaData message) {
        if (!updateMessagePatch.isFlagsIdentity()) {
            return Mono.from((Publisher)this.messageIdManager.setFlagsReactive(updateMessagePatch.applyToState(message.getFlags()), MessageManager.FlagsUpdateMode.REPLACE, messageId, (List)ImmutableList.of((Object)message.getComposedMessageId().getMailboxId()), mailboxSession));
        }
        return Mono.empty();
    }

    private Mono<Void> setInMailboxes(MessageId messageId, UpdateMessagePatch updateMessagePatch, MailboxSession mailboxSession) {
        Optional<List<String>> serializedMailboxIds = updateMessagePatch.getMailboxIds();
        if (serializedMailboxIds.isPresent()) {
            List mailboxIds = (List)serializedMailboxIds.get().stream().map(arg_0 -> ((MailboxId.Factory)this.mailboxIdFactory).fromString(arg_0)).collect(ImmutableList.toImmutableList());
            return Mono.from((Publisher)this.messageIdManager.setInMailboxesReactive(messageId, (Collection)mailboxIds, mailboxSession));
        }
        return Mono.empty();
    }

    private SetMessagesResponse.Builder addMessageIdNotFoundToResponse(MessageId messageId) {
        return SetMessagesResponse.builder().notUpdated((Map<MessageId, SetError>)ImmutableMap.of((Object)messageId, (Object)SetError.builder().type(SetError.Type.NOT_FOUND).properties((Set<MessageProperties.MessageProperty>)ImmutableSet.of((Object)MessageProperties.MessageProperty.id)).description("message not found").build()));
    }

    private SetMessagesResponse.Builder handleMessageUpdateException(MessageId messageId, Throwable e) {
        LOGGER.error("An error occurred when updating a message", e);
        return SetMessagesResponse.builder().notUpdated((Map<MessageId, SetError>)ImmutableMap.of((Object)messageId, (Object)SetError.builder().type(SetError.Type.ERROR).description("An error occurred when updating a message").build()));
    }

    private SetMessagesResponse.Builder handleInvalidRequest(MessageId messageId, ImmutableList<ValidationResult> validationErrors, UpdateMessagePatch patch) {
        LOGGER.warn("Invalid update request with patch {} for message #{}: {}", new Object[]{patch, messageId, validationErrors});
        String formattedValidationErrorMessage = validationErrors.stream().map(err -> err.getProperty() + ": " + err.getErrorMessage()).collect(Collectors.joining(", "));
        Set<MessageProperties.MessageProperty> properties = validationErrors.stream().flatMap(err -> MessageProperties.MessageProperty.find(err.getProperty())).collect(Collectors.toSet());
        return SetMessagesResponse.builder().notUpdated((Map<MessageId, SetError>)ImmutableMap.of((Object)messageId, (Object)SetError.builder().type(SetError.Type.INVALID_PROPERTIES).properties(properties).description(formattedValidationErrorMessage).build()));
    }
}

