/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.pushsubscription;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.google.common.collect.ImmutableSet;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.change.TypeStateFactory;
import org.apache.james.jmap.api.model.DeviceClientId;
import org.apache.james.jmap.api.model.PushSubscription;
import org.apache.james.jmap.api.model.PushSubscriptionExpiredTime;
import org.apache.james.jmap.api.model.PushSubscriptionId;
import org.apache.james.jmap.api.model.PushSubscriptionKeys;
import org.apache.james.jmap.api.model.PushSubscriptionServerURL;
import org.apache.james.jmap.api.model.TypeName;
import org.apache.james.jmap.api.model.VerificationCode;
import org.apache.james.jmap.cassandra.pushsubscription.tables.CassandraPushSubscriptionTable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.jdk.javaapi.CollectionConverters;
import scala.jdk.javaapi.OptionConverters;

public class CassandraPushSubscriptionDAO {
    private final TypeStateFactory typeStateFactory;
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement insert;
    private final PreparedStatement selectAll;
    private final PreparedStatement deleteOne;

    @Inject
    public CassandraPushSubscriptionDAO(CqlSession session, TypeStateFactory typeStateFactory) {
        this.executor = new CassandraAsyncExecutor(session);
        this.insert = session.prepare(QueryBuilder.insertInto((String)"push_subscription").value(CassandraPushSubscriptionTable.USER, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraPushSubscriptionTable.USER)).value(CassandraPushSubscriptionTable.DEVICE_CLIENT_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraPushSubscriptionTable.DEVICE_CLIENT_ID)).value(CassandraPushSubscriptionTable.ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraPushSubscriptionTable.ID)).value(CassandraPushSubscriptionTable.EXPIRES, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraPushSubscriptionTable.EXPIRES)).value(CassandraPushSubscriptionTable.TYPES, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraPushSubscriptionTable.TYPES)).value(CassandraPushSubscriptionTable.URL, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraPushSubscriptionTable.URL)).value(CassandraPushSubscriptionTable.VERIFICATION_CODE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraPushSubscriptionTable.VERIFICATION_CODE)).value(CassandraPushSubscriptionTable.ENCRYPT_PUBLIC_KEY, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraPushSubscriptionTable.ENCRYPT_PUBLIC_KEY)).value(CassandraPushSubscriptionTable.ENCRYPT_AUTH_SECRET, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraPushSubscriptionTable.ENCRYPT_AUTH_SECRET)).value(CassandraPushSubscriptionTable.VALIDATED, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraPushSubscriptionTable.VALIDATED)).build());
        this.selectAll = session.prepare(((Select)QueryBuilder.selectFrom((String)"push_subscription").all().whereColumn(CassandraPushSubscriptionTable.USER).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraPushSubscriptionTable.USER))).build());
        this.deleteOne = session.prepare(((Delete)((Delete)QueryBuilder.deleteFrom((String)"push_subscription").whereColumn(CassandraPushSubscriptionTable.USER).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraPushSubscriptionTable.USER))).whereColumn(CassandraPushSubscriptionTable.DEVICE_CLIENT_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraPushSubscriptionTable.DEVICE_CLIENT_ID))).build());
        this.typeStateFactory = typeStateFactory;
    }

    public Mono<PushSubscription> insert(Username username, PushSubscription subscription) {
        java.util.Set typeNames = CollectionConverters.asJava((Set)((Iterable)subscription.types().map(TypeName::asString)).toSet());
        Instant utcInstant = subscription.expires().value().withZoneSameInstant(ZoneOffset.UTC).toInstant();
        BoundStatementBuilder insertSubscription = (BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)this.insert.boundStatementBuilder(new Object[0]).setString(CassandraPushSubscriptionTable.USER, username.asString())).setString(CassandraPushSubscriptionTable.DEVICE_CLIENT_ID, subscription.deviceClientId())).setUuid(CassandraPushSubscriptionTable.ID, subscription.id().value())).setInstant(CassandraPushSubscriptionTable.EXPIRES, utcInstant)).setSet(CassandraPushSubscriptionTable.TYPES, typeNames, String.class)).setString(CassandraPushSubscriptionTable.URL, subscription.url().value().toString())).setString(CassandraPushSubscriptionTable.VERIFICATION_CODE, subscription.verificationCode())).setBoolean(CassandraPushSubscriptionTable.VALIDATED, subscription.validated());
        OptionConverters.toJava((Option)subscription.keys()).ifPresent(keys -> ((BoundStatementBuilder)insertSubscription.setString(CassandraPushSubscriptionTable.ENCRYPT_PUBLIC_KEY, keys.p256dh())).setString(CassandraPushSubscriptionTable.ENCRYPT_AUTH_SECRET, keys.auth()));
        return this.executor.executeVoid((Statement)insertSubscription.build()).thenReturn((Object)subscription);
    }

    public Flux<PushSubscription> selectAll(Username username) {
        return this.executor.executeRows((Statement)this.selectAll.bind(new Object[0]).setString(CassandraPushSubscriptionTable.USER, username.asString())).map(this::toPushSubscription);
    }

    public Mono<Void> deleteOne(Username username, String deviceClientId) {
        return this.executor.executeVoid((Statement)((BoundStatement)this.deleteOne.bind(new Object[0]).setString(CassandraPushSubscriptionTable.USER, username.asString())).setString(CassandraPushSubscriptionTable.DEVICE_CLIENT_ID, deviceClientId));
    }

    private PushSubscription toPushSubscription(Row row) {
        return PushSubscription.apply((PushSubscriptionId)PushSubscriptionId.apply((UUID)row.getUuid(CassandraPushSubscriptionTable.ID)), (String)DeviceClientId.apply((String)row.getString(CassandraPushSubscriptionTable.DEVICE_CLIENT_ID)), (PushSubscriptionServerURL)((PushSubscriptionServerURL)PushSubscriptionServerURL.from((String)row.getString(CassandraPushSubscriptionTable.URL)).get()), this.toKeys(row), (String)VerificationCode.apply((String)row.getString(CassandraPushSubscriptionTable.VERIFICATION_CODE)), (boolean)row.getBoolean(CassandraPushSubscriptionTable.VALIDATED), (PushSubscriptionExpiredTime)this.toExpires(row), this.toTypes(row));
    }

    private Option<PushSubscriptionKeys> toKeys(Row row) {
        String p256dh = row.getString(CassandraPushSubscriptionTable.ENCRYPT_PUBLIC_KEY);
        String auth = row.getString(CassandraPushSubscriptionTable.ENCRYPT_AUTH_SECRET);
        if (p256dh == null && auth == null) {
            return Option.empty();
        }
        return Option.apply((Object)PushSubscriptionKeys.apply((String)p256dh, (String)auth));
    }

    private PushSubscriptionExpiredTime toExpires(Row row) {
        return PushSubscriptionExpiredTime.apply((ZonedDateTime)ZonedDateTime.ofInstant(row.getInstant(CassandraPushSubscriptionTable.EXPIRES), ZoneOffset.UTC));
    }

    private Seq<TypeName> toTypes(Row row) {
        return CollectionConverters.asScala((java.util.Set)((java.util.Set)row.getSet(CassandraPushSubscriptionTable.TYPES, String.class).stream().map(string -> (TypeName)this.typeStateFactory.parse(string).right().get()).collect(ImmutableSet.toImmutableSet()))).toSeq();
    }
}

