/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DataChunker {
    private static final String CHUNK_SIZE_MUST_BE_STRICTLY_POSITIVE = "ChunkSize must be strictly positive";

    public static Flux<ByteBuffer> chunk(byte[] data, int chunkSize) {
        Preconditions.checkNotNull((Object)data);
        Preconditions.checkArgument((chunkSize > 0 ? 1 : 0) != 0, (Object)CHUNK_SIZE_MUST_BE_STRICTLY_POSITIVE);
        int size = data.length;
        int fullChunkCount = size / chunkSize;
        return Flux.concat((Publisher[])new Publisher[]{Flux.range((int)0, (int)fullChunkCount).map(i -> ByteBuffer.wrap(data, i * chunkSize, chunkSize)), DataChunker.lastChunk(data, chunkSize * fullChunkCount, fullChunkCount)});
    }

    private static Mono<ByteBuffer> lastChunk(byte[] data, int offset, int index) {
        if (offset == data.length && index > 0) {
            return Mono.empty();
        }
        return Mono.just((Object)ByteBuffer.wrap(data, offset, data.length - offset));
    }
}

