/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.DeliverPasswordResetTokenExtendedResult;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class DeliverPasswordResetTokenExtendedRequest
extends ExtendedRequest {
    @NotNull
    public static final String DELIVER_PW_RESET_TOKEN_REQUEST_OID = "1.3.6.1.4.1.30221.2.6.45";
    private static final byte MESSAGE_SUBJECT_BER_TYPE = -128;
    private static final byte FULL_TEXT_BEFORE_TOKEN_BER_TYPE = -127;
    private static final byte FULL_TEXT_AFTER_TOKEN_BER_TYPE = -126;
    private static final byte COMPACT_TEXT_BEFORE_TOKEN_BER_TYPE = -125;
    private static final byte COMPACT_TEXT_AFTER_TOKEN_BER_TYPE = -124;
    private static final byte PREFERRED_DELIVERY_MECHANISM_BER_TYPE = -91;
    private static final long serialVersionUID = 7608072810737347230L;
    @NotNull
    private final List<ObjectPair<String, String>> preferredDeliveryMechanisms;
    @Nullable
    private final String compactTextAfterToken;
    @Nullable
    private final String compactTextBeforeToken;
    @Nullable
    private final String fullTextAfterToken;
    @Nullable
    private final String fullTextBeforeToken;
    @Nullable
    private final String messageSubject;
    @NotNull
    private final String userDN;

    public DeliverPasswordResetTokenExtendedRequest(@NotNull String userDN, String ... preferredDeliveryMechanisms) {
        this(userDN, DeliverPasswordResetTokenExtendedRequest.preferredMechanismsToList(preferredDeliveryMechanisms), new Control[0]);
    }

    public DeliverPasswordResetTokenExtendedRequest(@NotNull String userDN, @Nullable List<ObjectPair<String, String>> preferredDeliveryMechanisms, Control ... controls) {
        this(userDN, null, null, null, null, null, preferredDeliveryMechanisms, controls);
    }

    public DeliverPasswordResetTokenExtendedRequest(@NotNull String userDN, @Nullable String messageSubject, @Nullable String fullTextBeforeToken, @Nullable String fullTextAfterToken, @Nullable String compactTextBeforeToken, @Nullable String compactTextAfterToken, @Nullable List<ObjectPair<String, String>> preferredDeliveryMechanisms, Control ... controls) {
        super(DELIVER_PW_RESET_TOKEN_REQUEST_OID, DeliverPasswordResetTokenExtendedRequest.encodeValue(userDN, messageSubject, fullTextBeforeToken, fullTextAfterToken, compactTextBeforeToken, compactTextAfterToken, preferredDeliveryMechanisms), controls);
        this.userDN = userDN;
        this.messageSubject = messageSubject;
        this.fullTextBeforeToken = fullTextBeforeToken;
        this.fullTextAfterToken = fullTextAfterToken;
        this.compactTextBeforeToken = compactTextBeforeToken;
        this.compactTextAfterToken = compactTextAfterToken;
        this.preferredDeliveryMechanisms = preferredDeliveryMechanisms == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<ObjectPair<String, String>>(preferredDeliveryMechanisms));
    }

    public DeliverPasswordResetTokenExtendedRequest(@NotNull ExtendedRequest request) throws LDAPException {
        super(request);
        ASN1OctetString value = request.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_DELIVER_PW_RESET_TOKEN_REQUEST_NO_VALUE.get());
        }
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(value.getValue()).elements();
            this.userDN = ASN1OctetString.decodeAsOctetString(elements[0]).stringValue();
            String subject = null;
            String fullBefore = null;
            String fullAfter = null;
            String compactBefore = null;
            String compactAfter = null;
            ArrayList<ObjectPair<String, String>> pdmList = new ArrayList<ObjectPair<String, String>>(10);
            block11: for (int i = 1; i < elements.length; ++i) {
                switch (elements[i].getType()) {
                    case -128: {
                        subject = ASN1OctetString.decodeAsOctetString(elements[i]).stringValue();
                        continue block11;
                    }
                    case -127: {
                        fullBefore = ASN1OctetString.decodeAsOctetString(elements[i]).stringValue();
                        continue block11;
                    }
                    case -126: {
                        fullAfter = ASN1OctetString.decodeAsOctetString(elements[i]).stringValue();
                        continue block11;
                    }
                    case -125: {
                        compactBefore = ASN1OctetString.decodeAsOctetString(elements[i]).stringValue();
                        continue block11;
                    }
                    case -124: {
                        compactAfter = ASN1OctetString.decodeAsOctetString(elements[i]).stringValue();
                        continue block11;
                    }
                    case -91: {
                        ASN1Element[] pdmElements;
                        for (ASN1Element e : pdmElements = ASN1Sequence.decodeAsSequence(elements[i]).elements()) {
                            ASN1Element[] mechElements = ASN1Sequence.decodeAsSequence(e).elements();
                            String mech = ASN1OctetString.decodeAsOctetString(mechElements[0]).stringValue();
                            String recipientID = mechElements.length > 1 ? ASN1OctetString.decodeAsOctetString(mechElements[1]).stringValue() : null;
                            pdmList.add(new ObjectPair<String, String>(mech, recipientID));
                        }
                        continue block11;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_DELIVER_PW_RESET_TOKEN_REQUEST_UNEXPECTED_TYPE.get(StaticUtils.toHex(elements[i].getType())));
                    }
                }
            }
            this.preferredDeliveryMechanisms = Collections.unmodifiableList(pdmList);
            this.messageSubject = subject;
            this.fullTextBeforeToken = fullBefore;
            this.fullTextAfterToken = fullAfter;
            this.compactTextBeforeToken = compactBefore;
            this.compactTextAfterToken = compactAfter;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_DELIVER_PW_RESET_TOKEN_REQUEST_ERROR_DECODING_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Nullable
    private static List<ObjectPair<String, String>> preferredMechanismsToList(String ... preferredDeliveryMechanisms) {
        if (preferredDeliveryMechanisms == null) {
            return null;
        }
        ArrayList<ObjectPair<String, String>> l = new ArrayList<ObjectPair<String, String>>(preferredDeliveryMechanisms.length);
        for (String s : preferredDeliveryMechanisms) {
            l.add(new ObjectPair<String, Object>(s, null));
        }
        return l;
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull String userDN, @Nullable String messageSubject, @Nullable String fullTextBeforeToken, @Nullable String fullTextAfterToken, @Nullable String compactTextBeforeToken, @Nullable String compactTextAfterToken, @Nullable List<ObjectPair<String, String>> preferredDeliveryMechanisms) {
        Validator.ensureNotNull(userDN);
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(7);
        elements.add(new ASN1OctetString(userDN));
        if (messageSubject != null) {
            elements.add(new ASN1OctetString(-128, messageSubject));
        }
        if (fullTextBeforeToken != null) {
            elements.add(new ASN1OctetString(-127, fullTextBeforeToken));
        }
        if (fullTextAfterToken != null) {
            elements.add(new ASN1OctetString(-126, fullTextAfterToken));
        }
        if (compactTextBeforeToken != null) {
            elements.add(new ASN1OctetString(-125, compactTextBeforeToken));
        }
        if (compactTextAfterToken != null) {
            elements.add(new ASN1OctetString(-124, compactTextAfterToken));
        }
        if (preferredDeliveryMechanisms != null && !preferredDeliveryMechanisms.isEmpty()) {
            ArrayList<ASN1Sequence> pdmElements = new ArrayList<ASN1Sequence>(preferredDeliveryMechanisms.size());
            for (ObjectPair<String, String> p : preferredDeliveryMechanisms) {
                if (p.getSecond() == null) {
                    pdmElements.add(new ASN1Sequence(new ASN1OctetString(p.getFirst())));
                    continue;
                }
                pdmElements.add(new ASN1Sequence(new ASN1OctetString(p.getFirst()), new ASN1OctetString(p.getSecond())));
            }
            elements.add(new ASN1Sequence(-91, pdmElements));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @NotNull
    public String getUserDN() {
        return this.userDN;
    }

    @Nullable
    public String getMessageSubject() {
        return this.messageSubject;
    }

    @Nullable
    public String getFullTextBeforeToken() {
        return this.fullTextBeforeToken;
    }

    @Nullable
    public String getFullTextAfterToken() {
        return this.fullTextAfterToken;
    }

    @Nullable
    public String getCompactTextBeforeToken() {
        return this.compactTextBeforeToken;
    }

    @Nullable
    public String getCompactTextAfterToken() {
        return this.compactTextAfterToken;
    }

    @NotNull
    public List<ObjectPair<String, String>> getPreferredDeliveryMechanisms() {
        return this.preferredDeliveryMechanisms;
    }

    @Override
    @NotNull
    public DeliverPasswordResetTokenExtendedResult process(@NotNull LDAPConnection connection, int depth) throws LDAPException {
        ExtendedResult extendedResponse = super.process(connection, depth);
        return new DeliverPasswordResetTokenExtendedResult(extendedResponse);
    }

    @Override
    @NotNull
    public DeliverPasswordResetTokenExtendedRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    @NotNull
    public DeliverPasswordResetTokenExtendedRequest duplicate(@Nullable Control[] controls) {
        DeliverPasswordResetTokenExtendedRequest r = new DeliverPasswordResetTokenExtendedRequest(this.userDN, this.messageSubject, this.fullTextBeforeToken, this.fullTextAfterToken, this.compactTextBeforeToken, this.compactTextAfterToken, this.preferredDeliveryMechanisms, controls);
        r.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return r;
    }

    @Override
    @NotNull
    public String getExtendedRequestName() {
        return ExtOpMessages.INFO_EXTENDED_REQUEST_NAME_DELIVER_PW_RESET_TOKEN.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        Control[] controls;
        buffer.append("DeliverPasswordResetTokenExtendedRequest(userDN='");
        buffer.append(this.userDN);
        buffer.append('\'');
        if (this.messageSubject != null) {
            buffer.append(", messageSubject='");
            buffer.append(this.messageSubject);
            buffer.append('\'');
        }
        if (this.fullTextBeforeToken != null) {
            buffer.append(", fullTextBeforeToken='");
            buffer.append(this.fullTextBeforeToken);
            buffer.append('\'');
        }
        if (this.fullTextAfterToken != null) {
            buffer.append(", fullTextAfterToken='");
            buffer.append(this.fullTextAfterToken);
            buffer.append('\'');
        }
        if (this.compactTextBeforeToken != null) {
            buffer.append(", compactTextBeforeToken='");
            buffer.append(this.compactTextBeforeToken);
            buffer.append('\'');
        }
        if (this.compactTextAfterToken != null) {
            buffer.append(", compactTextAfterToken='");
            buffer.append(this.compactTextAfterToken);
            buffer.append('\'');
        }
        if (this.preferredDeliveryMechanisms != null) {
            buffer.append(", preferredDeliveryMechanisms={");
            Iterator<ObjectPair<String, String>> iterator = this.preferredDeliveryMechanisms.iterator();
            while (iterator.hasNext()) {
                ObjectPair<String, String> p = iterator.next();
                buffer.append('\'');
                buffer.append(p.getFirst());
                if (p.getSecond() != null) {
                    buffer.append('(');
                    buffer.append(p.getSecond());
                    buffer.append(')');
                }
                buffer.append('\'');
                if (!iterator.hasNext()) continue;
                buffer.append(',');
            }
        }
        if ((controls = this.getControls()).length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

