/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorAttribute;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LDAPStatisticsMonitorEntry
extends MonitorEntry {
    @NotNull
    static final String LDAP_STATISTICS_MONITOR_OC = "ds-ldap-statistics-monitor-entry";
    @NotNull
    private static final String ATTR_ABANDON_REQUESTS = "abandonRequests";
    @NotNull
    private static final String ATTR_ADD_REQUESTS = "addRequests";
    @NotNull
    private static final String ATTR_ADD_RESPONSES = "addResponses";
    @NotNull
    private static final String ATTR_BIND_REQUESTS = "bindRequests";
    @NotNull
    private static final String ATTR_BIND_RESPONSES = "bindResponses";
    @NotNull
    private static final String ATTR_BYTES_READ = "bytesRead";
    @NotNull
    private static final String ATTR_BYTES_WRITTEN = "bytesWritten";
    @NotNull
    private static final String ATTR_COMPARE_REQUESTS = "compareRequests";
    @NotNull
    private static final String ATTR_COMPARE_RESPONSES = "compareResponses";
    @NotNull
    private static final String ATTR_CONNECTIONS_CLOSED = "connectionsClosed";
    @NotNull
    private static final String ATTR_CONNECTIONS_ESTABLISHED = "connectionsEstablished";
    @NotNull
    private static final String ATTR_DELETE_REQUESTS = "deleteRequests";
    @NotNull
    private static final String ATTR_DELETE_RESPONSES = "deleteResponses";
    @NotNull
    private static final String ATTR_EXTENDED_REQUESTS = "extendedRequests";
    @NotNull
    private static final String ATTR_EXTENDED_RESPONSES = "extendedResponses";
    @NotNull
    private static final String ATTR_LDAP_MESSAGES_READ = "ldapMessagesRead";
    @NotNull
    private static final String ATTR_LDAP_MESSAGES_WRITTEN = "ldapMessagesWritten";
    @NotNull
    private static final String ATTR_MODIFY_REQUESTS = "modifyRequests";
    @NotNull
    private static final String ATTR_MODIFY_RESPONSES = "modifyResponses";
    @NotNull
    private static final String ATTR_MODIFY_DN_REQUESTS = "modifyDNRequests";
    @NotNull
    private static final String ATTR_MODIFY_DN_RESPONSES = "modifyDNResponses";
    @NotNull
    private static final String ATTR_OPS_ABANDONED = "operationsAbandoned";
    @NotNull
    private static final String ATTR_OPS_COMPLETED = "operationsCompleted";
    @NotNull
    private static final String ATTR_OPS_INITIATED = "operationsInitiated";
    @NotNull
    private static final String ATTR_SEARCH_REQUESTS = "searchRequests";
    @NotNull
    private static final String ATTR_SEARCH_RESULT_DONE_RESPONSES = "searchResultsDone";
    @NotNull
    private static final String ATTR_SEARCH_RESULT_ENTRY_RESPONSES = "searchResultEntries";
    @NotNull
    private static final String ATTR_SEARCH_RESULT_REFERENCE_RESPONSES = "searchResultReferences";
    @NotNull
    private static final String ATTR_UNBIND_REQUESTS = "unbindRequests";
    private static final long serialVersionUID = 4869341619766489249L;
    @Nullable
    private final Long abandonRequests = this.getLong("abandonRequests");
    @Nullable
    private final Long addRequests = this.getLong("addRequests");
    @Nullable
    private final Long addResponses = this.getLong("addResponses");
    @Nullable
    private final Long bindRequests = this.getLong("bindRequests");
    @Nullable
    private final Long bindResponses = this.getLong("bindResponses");
    @Nullable
    private final Long bytesRead = this.getLong("bytesRead");
    @Nullable
    private final Long bytesWritten = this.getLong("bytesWritten");
    @Nullable
    private final Long compareRequests = this.getLong("compareRequests");
    @Nullable
    private final Long compareResponses = this.getLong("compareResponses");
    @Nullable
    private final Long connectionsClosed = this.getLong("connectionsClosed");
    @Nullable
    private final Long connectionsEstablished = this.getLong("connectionsEstablished");
    @Nullable
    private final Long deleteRequests = this.getLong("deleteRequests");
    @Nullable
    private final Long deleteResponses = this.getLong("deleteResponses");
    @Nullable
    private final Long extendedRequests = this.getLong("extendedRequests");
    @Nullable
    private final Long extendedResponses = this.getLong("extendedResponses");
    @Nullable
    private final Long ldapMessagesRead = this.getLong("ldapMessagesRead");
    @Nullable
    private final Long ldapMessagesWritten = this.getLong("ldapMessagesWritten");
    @Nullable
    private final Long modifyRequests = this.getLong("modifyRequests");
    @Nullable
    private final Long modifyResponses = this.getLong("modifyResponses");
    @Nullable
    private final Long modifyDNRequests = this.getLong("modifyDNRequests");
    @Nullable
    private final Long modifyDNResponses = this.getLong("modifyDNResponses");
    @Nullable
    private final Long opsAbandoned = this.getLong("operationsAbandoned");
    @Nullable
    private final Long opsCompleted = this.getLong("operationsCompleted");
    @Nullable
    private final Long opsInitiated = this.getLong("operationsInitiated");
    @Nullable
    private final Long searchRequests = this.getLong("searchRequests");
    @Nullable
    private final Long searchDoneResponses = this.getLong("searchResultsDone");
    @Nullable
    private final Long searchEntryResponses = this.getLong("searchResultEntries");
    @Nullable
    private final Long searchReferenceResponses = this.getLong("searchResultReferences");
    @Nullable
    private final Long unbindRequests = this.getLong("unbindRequests");

    public LDAPStatisticsMonitorEntry(@NotNull Entry entry) {
        super(entry);
    }

    @Nullable
    public Long getConnectionsEstablished() {
        return this.connectionsEstablished;
    }

    @Nullable
    public Long getConnectionsClosed() {
        return this.connectionsClosed;
    }

    @Nullable
    public Long getOperationsInitiated() {
        return this.opsInitiated;
    }

    @Nullable
    public Long getOperationsCompleted() {
        return this.opsCompleted;
    }

    @Nullable
    public Long getOperationsAbandoned() {
        return this.opsAbandoned;
    }

    @Nullable
    public Long getBytesRead() {
        return this.bytesRead;
    }

    @Nullable
    public Long getBytesWritten() {
        return this.bytesWritten;
    }

    @Nullable
    public Long getLDAPMessagesRead() {
        return this.ldapMessagesRead;
    }

    @Nullable
    public Long getLDAPMessagesWritten() {
        return this.ldapMessagesWritten;
    }

    @Nullable
    public Long getAbandonRequests() {
        return this.abandonRequests;
    }

    @Nullable
    public Long getAddRequests() {
        return this.addRequests;
    }

    @Nullable
    public Long getAddResponses() {
        return this.addResponses;
    }

    @Nullable
    public Long getBindRequests() {
        return this.bindRequests;
    }

    @Nullable
    public Long getBindResponses() {
        return this.bindResponses;
    }

    @Nullable
    public Long getCompareRequests() {
        return this.compareRequests;
    }

    @Nullable
    public Long getCompareResponses() {
        return this.compareResponses;
    }

    @Nullable
    public Long getDeleteRequests() {
        return this.deleteRequests;
    }

    @Nullable
    public Long getDeleteResponses() {
        return this.deleteResponses;
    }

    @Nullable
    public Long getExtendedRequests() {
        return this.extendedRequests;
    }

    @Nullable
    public Long getExtendedResponses() {
        return this.extendedResponses;
    }

    @Nullable
    public Long getModifyRequests() {
        return this.modifyRequests;
    }

    @Nullable
    public Long getModifyResponses() {
        return this.modifyResponses;
    }

    @Nullable
    public Long getModifyDNRequests() {
        return this.modifyDNRequests;
    }

    @Nullable
    public Long getModifyDNResponses() {
        return this.modifyDNResponses;
    }

    @Nullable
    public Long getSearchRequests() {
        return this.searchRequests;
    }

    @Nullable
    public Long getSearchResultEntries() {
        return this.searchEntryResponses;
    }

    @Nullable
    public Long getSearchResultReferences() {
        return this.searchReferenceResponses;
    }

    @Nullable
    public Long getSearchDoneResponses() {
        return this.searchDoneResponses;
    }

    @Nullable
    public Long getUnbindRequests() {
        return this.unbindRequests;
    }

    @Override
    @NotNull
    public String getMonitorDisplayName() {
        return MonitorMessages.INFO_LDAP_STATS_MONITOR_DISPNAME.get();
    }

    @Override
    @NotNull
    public String getMonitorDescription() {
        return MonitorMessages.INFO_LDAP_STATS_MONITOR_DESC.get();
    }

    @Override
    @NotNull
    public Map<String, MonitorAttribute> getMonitorAttributes() {
        LinkedHashMap<String, MonitorAttribute> attrs = new LinkedHashMap<String, MonitorAttribute>(StaticUtils.computeMapCapacity(50));
        if (this.connectionsEstablished != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_CONNECTIONS_ESTABLISHED, MonitorMessages.INFO_LDAP_STATS_DISPNAME_CONNECTIONS_ESTABLISHED.get(), MonitorMessages.INFO_LDAP_STATS_DESC_CONNECTIONS_ESTABLISHED.get(), this.connectionsEstablished);
        }
        if (this.connectionsClosed != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_CONNECTIONS_CLOSED, MonitorMessages.INFO_LDAP_STATS_DISPNAME_CONNECTIONS_CLOSED.get(), MonitorMessages.INFO_LDAP_STATS_DESC_CONNECTIONS_CLOSED.get(), this.connectionsClosed);
        }
        if (this.bytesRead != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_BYTES_READ, MonitorMessages.INFO_LDAP_STATS_DISPNAME_BYTES_READ.get(), MonitorMessages.INFO_LDAP_STATS_DESC_BYTES_READ.get(), this.bytesRead);
        }
        if (this.bytesWritten != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_BYTES_WRITTEN, MonitorMessages.INFO_LDAP_STATS_DISPNAME_BYTES_WRITTEN.get(), MonitorMessages.INFO_LDAP_STATS_DESC_BYTES_WRITTEN.get(), this.bytesWritten);
        }
        if (this.ldapMessagesRead != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_LDAP_MESSAGES_READ, MonitorMessages.INFO_LDAP_STATS_DISPNAME_LDAP_MESSAGES_READ.get(), MonitorMessages.INFO_LDAP_STATS_DESC_LDAP_MESSAGES_READ.get(), this.ldapMessagesRead);
        }
        if (this.ldapMessagesWritten != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_LDAP_MESSAGES_WRITTEN, MonitorMessages.INFO_LDAP_STATS_DISPNAME_LDAP_MESSAGES_WRITTEN.get(), MonitorMessages.INFO_LDAP_STATS_DESC_LDAP_MESSAGES_WRITTEN.get(), this.ldapMessagesWritten);
        }
        if (this.opsInitiated != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_OPS_INITIATED, MonitorMessages.INFO_LDAP_STATS_DISPNAME_OPS_INITIATED.get(), MonitorMessages.INFO_LDAP_STATS_DESC_OPS_INITIATED.get(), this.opsInitiated);
        }
        if (this.opsCompleted != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_OPS_COMPLETED, MonitorMessages.INFO_LDAP_STATS_DISPNAME_OPS_COMPLETED.get(), MonitorMessages.INFO_LDAP_STATS_DESC_OPS_COMPLETED.get(), this.opsCompleted);
        }
        if (this.opsAbandoned != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_OPS_ABANDONED, MonitorMessages.INFO_LDAP_STATS_DISPNAME_OPS_ABANDONED.get(), MonitorMessages.INFO_LDAP_STATS_DESC_OPS_ABANDONED.get(), this.opsAbandoned);
        }
        if (this.abandonRequests != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_ABANDON_REQUESTS, MonitorMessages.INFO_LDAP_STATS_DISPNAME_ABANDON_REQUESTS.get(), MonitorMessages.INFO_LDAP_STATS_DESC_ABANDON_REQUESTS.get(), this.abandonRequests);
        }
        if (this.addRequests != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_ADD_REQUESTS, MonitorMessages.INFO_LDAP_STATS_DISPNAME_ADD_REQUESTS.get(), MonitorMessages.INFO_LDAP_STATS_DESC_ADD_REQUESTS.get(), this.addRequests);
        }
        if (this.addResponses != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_ADD_RESPONSES, MonitorMessages.INFO_LDAP_STATS_DISPNAME_ADD_RESPONSES.get(), MonitorMessages.INFO_LDAP_STATS_DESC_ADD_RESPONSES.get(), this.addResponses);
        }
        if (this.bindRequests != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_BIND_REQUESTS, MonitorMessages.INFO_LDAP_STATS_DISPNAME_BIND_REQUESTS.get(), MonitorMessages.INFO_LDAP_STATS_DESC_BIND_REQUESTS.get(), this.bindRequests);
        }
        if (this.bindResponses != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_BIND_RESPONSES, MonitorMessages.INFO_LDAP_STATS_DISPNAME_BIND_RESPONSES.get(), MonitorMessages.INFO_LDAP_STATS_DESC_BIND_RESPONSES.get(), this.bindResponses);
        }
        if (this.compareRequests != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_COMPARE_REQUESTS, MonitorMessages.INFO_LDAP_STATS_DISPNAME_COMPARE_REQUESTS.get(), MonitorMessages.INFO_LDAP_STATS_DESC_COMPARE_REQUESTS.get(), this.compareRequests);
        }
        if (this.compareResponses != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_COMPARE_RESPONSES, MonitorMessages.INFO_LDAP_STATS_DISPNAME_COMPARE_RESPONSES.get(), MonitorMessages.INFO_LDAP_STATS_DESC_COMPARE_RESPONSES.get(), this.compareResponses);
        }
        if (this.deleteRequests != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_DELETE_REQUESTS, MonitorMessages.INFO_LDAP_STATS_DISPNAME_DELETE_REQUESTS.get(), MonitorMessages.INFO_LDAP_STATS_DESC_DELETE_REQUESTS.get(), this.deleteRequests);
        }
        if (this.deleteResponses != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_DELETE_RESPONSES, MonitorMessages.INFO_LDAP_STATS_DISPNAME_DELETE_RESPONSES.get(), MonitorMessages.INFO_LDAP_STATS_DESC_DELETE_RESPONSES.get(), this.deleteResponses);
        }
        if (this.extendedRequests != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_EXTENDED_REQUESTS, MonitorMessages.INFO_LDAP_STATS_DISPNAME_EXTENDED_REQUESTS.get(), MonitorMessages.INFO_LDAP_STATS_DESC_EXTENDED_REQUESTS.get(), this.extendedRequests);
        }
        if (this.extendedResponses != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_EXTENDED_RESPONSES, MonitorMessages.INFO_LDAP_STATS_DISPNAME_EXTENDED_RESPONSES.get(), MonitorMessages.INFO_LDAP_STATS_DESC_EXTENDED_RESPONSES.get(), this.extendedResponses);
        }
        if (this.modifyRequests != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_MODIFY_REQUESTS, MonitorMessages.INFO_LDAP_STATS_DISPNAME_MODIFY_REQUESTS.get(), MonitorMessages.INFO_LDAP_STATS_DESC_MODIFY_REQUESTS.get(), this.modifyRequests);
        }
        if (this.modifyResponses != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_MODIFY_RESPONSES, MonitorMessages.INFO_LDAP_STATS_DISPNAME_MODIFY_RESPONSES.get(), MonitorMessages.INFO_LDAP_STATS_DESC_MODIFY_RESPONSES.get(), this.modifyResponses);
        }
        if (this.modifyDNRequests != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_MODIFY_DN_REQUESTS, MonitorMessages.INFO_LDAP_STATS_DISPNAME_MODIFY_DN_REQUESTS.get(), MonitorMessages.INFO_LDAP_STATS_DESC_MODIFY_DN_REQUESTS.get(), this.modifyDNRequests);
        }
        if (this.modifyDNResponses != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_MODIFY_DN_RESPONSES, MonitorMessages.INFO_LDAP_STATS_DISPNAME_MODIFY_DN_RESPONSES.get(), MonitorMessages.INFO_LDAP_STATS_DESC_MODIFY_DN_RESPONSES.get(), this.modifyDNResponses);
        }
        if (this.searchRequests != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_SEARCH_REQUESTS, MonitorMessages.INFO_LDAP_STATS_DISPNAME_SEARCH_REQUESTS.get(), MonitorMessages.INFO_LDAP_STATS_DESC_SEARCH_REQUESTS.get(), this.searchRequests);
        }
        if (this.searchEntryResponses != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_SEARCH_RESULT_ENTRY_RESPONSES, MonitorMessages.INFO_LDAP_STATS_DISPNAME_SEARCH_ENTRY_RESPONSES.get(), MonitorMessages.INFO_LDAP_STATS_DESC_SEARCH_ENTRY_RESPONSES.get(), this.searchEntryResponses);
        }
        if (this.searchReferenceResponses != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_SEARCH_RESULT_REFERENCE_RESPONSES, MonitorMessages.INFO_LDAP_STATS_DISPNAME_SEARCH_REFERENCE_RESPONSES.get(), MonitorMessages.INFO_LDAP_STATS_DESC_SEARCH_REFERENCE_RESPONSES.get(), this.searchReferenceResponses);
        }
        if (this.searchDoneResponses != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_SEARCH_RESULT_DONE_RESPONSES, MonitorMessages.INFO_LDAP_STATS_DISPNAME_SEARCH_DONE_RESPONSES.get(), MonitorMessages.INFO_LDAP_STATS_DESC_SEARCH_DONE_RESPONSES.get(), this.searchDoneResponses);
        }
        if (this.unbindRequests != null) {
            LDAPStatisticsMonitorEntry.addMonitorAttribute(attrs, ATTR_UNBIND_REQUESTS, MonitorMessages.INFO_LDAP_STATS_DISPNAME_UNBIND_REQUESTS.get(), MonitorMessages.INFO_LDAP_STATS_DESC_UNBIND_REQUESTS.get(), this.unbindRequests);
        }
        return Collections.unmodifiableMap(attrs);
    }
}

