/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.monitors.GaugeMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorAttribute;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class NumericGaugeMonitorEntry
extends GaugeMonitorEntry {
    @NotNull
    static final String NUMERIC_GAUGE_MONITOR_OC = "ds-numeric-gauge-monitor-entry";
    private static final long serialVersionUID = 2049893927290436280L;
    @Nullable
    private final Double currentValue = this.getDouble("value");
    @Nullable
    private final Double maximumValue;
    @Nullable
    private final Double minimumValue;
    @Nullable
    private final Double previousValue = this.getDouble("previous-value");
    @NotNull
    private final List<Double> observedValues;

    public NumericGaugeMonitorEntry(@NotNull Entry entry) {
        super(entry);
        this.minimumValue = this.getDouble("value-minimum");
        this.maximumValue = this.getDouble("value-maximum");
        String observedStr = this.getString("observed-values");
        if (observedStr == null || observedStr.isEmpty()) {
            this.observedValues = Collections.emptyList();
        } else {
            ArrayList<Double> values = new ArrayList<Double>(10);
            try {
                StringTokenizer tokenizer = new StringTokenizer(observedStr, ",");
                while (tokenizer.hasMoreTokens()) {
                    values.add(Double.parseDouble(tokenizer.nextToken()));
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                values.clear();
            }
            this.observedValues = Collections.unmodifiableList(values);
        }
    }

    @Nullable
    public Double getCurrentValue() {
        return this.currentValue;
    }

    @Nullable
    public Double getPreviousValue() {
        return this.previousValue;
    }

    @Nullable
    public Double getMinimumValue() {
        return this.minimumValue;
    }

    @Nullable
    public Double getMaximumValue() {
        return this.maximumValue;
    }

    @NotNull
    public List<Double> getObservedValues() {
        return this.observedValues;
    }

    @Override
    @NotNull
    public String getMonitorDisplayName() {
        return MonitorMessages.INFO_NUMERIC_GAUGE_MONITOR_DISPNAME.get();
    }

    @Override
    @NotNull
    public String getMonitorDescription() {
        return MonitorMessages.INFO_NUMERIC_GAUGE_MONITOR_DESC.get();
    }

    @Override
    @NotNull
    public Map<String, MonitorAttribute> getMonitorAttributes() {
        Map<String, MonitorAttribute> superAttributes = super.getMonitorAttributes();
        LinkedHashMap<String, MonitorAttribute> attrs = new LinkedHashMap<String, MonitorAttribute>(StaticUtils.computeMapCapacity(superAttributes.size() + 5));
        attrs.putAll(superAttributes);
        if (this.currentValue != null) {
            NumericGaugeMonitorEntry.addMonitorAttribute(attrs, "value", MonitorMessages.INFO_NUMERIC_GAUGE_DISPNAME_CURRENT_VALUE.get(), MonitorMessages.INFO_NUMERIC_GAUGE_DESC_CURRENT_VALUE.get(), this.currentValue);
        }
        if (this.previousValue != null) {
            NumericGaugeMonitorEntry.addMonitorAttribute(attrs, "previous-value", MonitorMessages.INFO_NUMERIC_GAUGE_DISPNAME_PREVIOUS_VALUE.get(), MonitorMessages.INFO_NUMERIC_GAUGE_DESC_PREVIOUS_VALUE.get(), this.previousValue);
        }
        if (this.minimumValue != null) {
            NumericGaugeMonitorEntry.addMonitorAttribute(attrs, "value-minimum", MonitorMessages.INFO_NUMERIC_GAUGE_DISPNAME_MINIMUM_VALUE.get(), MonitorMessages.INFO_NUMERIC_GAUGE_DESC_MINIMUM_VALUE.get(), this.minimumValue);
        }
        if (this.maximumValue != null) {
            NumericGaugeMonitorEntry.addMonitorAttribute(attrs, "value-maximum", MonitorMessages.INFO_NUMERIC_GAUGE_DISPNAME_MAXIMUM_VALUE.get(), MonitorMessages.INFO_NUMERIC_GAUGE_DESC_MAXIMUM_VALUE.get(), this.maximumValue);
        }
        if (!this.observedValues.isEmpty()) {
            Double[] values = new Double[this.observedValues.size()];
            this.observedValues.toArray(values);
            attrs.put("observed-values", new MonitorAttribute("observed-values", MonitorMessages.INFO_NUMERIC_GAUGE_DISPNAME_OBSERVED_VALUES.get(), MonitorMessages.INFO_NUMERIC_GAUGE_DESC_OBSERVED_VALUES.get(), values));
        }
        return Collections.unmodifiableMap(attrs);
    }
}

