/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.http;

import java.io.Serializable;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.jmap.JMAPConfiguration;
import org.apache.james.jmap.http.UserProvisioning$;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.user.api.AlreadyExistInUsersRepositoryException;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005}a\u0001\u0002\b\u0010\u0001iA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tU\u0001\u0011\t\u0011)A\u0005W!A!\u0007\u0001B\u0001B\u0003%1\u0007C\u00038\u0001\u0011\u0005\u0001\bC\u0003H\u0001\u0011\u0005\u0001\nC\u0003`\u0001\u0011%\u0001\rC\u0003c\u0001\u0011%1\rC\u0003l\u0001\u0011%A\u000eC\u0003s\u0001\u0011%1o\u0002\u0005\u0000\u001f\u0005\u0005\t\u0012AA\u0001\r!qq\"!A\t\u0002\u0005\r\u0001BB\u001c\f\t\u0003\t)\u0001C\u0005\u0002\b-\t\n\u0011\"\u0001\u0002\n\t\u0001Rk]3s!J|g/[:j_:Lgn\u001a\u0006\u0003!E\tA\u0001\u001b;ua*\u0011!cE\u0001\u0005U6\f\u0007O\u0003\u0002\u0015+\u0005)!.Y7fg*\u0011acF\u0001\u0007CB\f7\r[3\u000b\u0003a\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\u000e\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\r\u0005s\u0017PU3g\u0003=)8/\u001a:t%\u0016\u0004xn]5u_JL\bCA\u0012)\u001b\u0005!#BA\u0013'\u0003\r\t\u0007/\u001b\u0006\u0003OM\tA!^:fe&\u0011\u0011\u0006\n\u0002\u0010+N,'o\u001d*fa>\u001c\u0018\u000e^8ss\u0006iQ.\u001a;sS\u000e4\u0015m\u0019;pef\u0004\"\u0001\f\u0019\u000e\u00035R!!\n\u0018\u000b\u0005=\u001a\u0012aB7fiJL7m]\u0005\u0003c5\u0012Q\"T3ue&\u001cg)Y2u_JL\u0018!\u00056nCB\u001cuN\u001c4jOV\u0014\u0018\r^5p]B\u0011A'N\u0007\u0002#%\u0011a'\u0005\u0002\u0012\u00156\u000b\u0005kQ8oM&<WO]1uS>t\u0017A\u0002\u001fj]&$h\b\u0006\u0003:wqj\u0004C\u0001\u001e\u0001\u001b\u0005y\u0001\"B\u0011\u0005\u0001\u0004\u0011\u0003\"\u0002\u0016\u0005\u0001\u0004Y\u0003b\u0002\u001a\u0005!\u0003\u0005\ra\r\u0015\u0003\t}\u0002\"\u0001Q#\u000e\u0003\u0005S!AQ\"\u0002\r%t'.Z2u\u0015\u0005!\u0015!\u00026bm\u0006D\u0018B\u0001$B\u0005\u0019IeN[3di\u0006i\u0001O]8wSNLwN\\+tKJ$\"!S,\u0011\u0007)\u0013F+D\u0001L\u0015\taU*A\u0005qk\nd\u0017n\u001d5fe*\u0011aD\u0014\u0006\u0003\u001fB\u000bAaY8sK*\t\u0011+A\u0004sK\u0006\u001cGo\u001c:\n\u0005M[%!B*N_:|\u0007C\u0001\u000fV\u0013\t1VD\u0001\u0003V]&$\b\"\u0002-\u0006\u0001\u0004I\u0016aB:fgNLwN\u001c\t\u00035vk\u0011a\u0017\u0006\u00039N\tq!\\1jY\n|\u00070\u0003\u0002_7\nqQ*Y5mE>D8+Z:tS>t\u0017!F2sK\u0006$X-Q2d_VtG/\u00134OK\u0016$W\r\u001a\u000b\u0003\u0013\u0006DQ\u0001\u0017\u0004A\u0002e\u000bQb\u0019:fCR,\u0017iY2pk:$HCA%e\u0011\u0015)w\u00011\u0001g\u0003!)8/\u001a:oC6,\u0007CA4j\u001b\u0005A'BA(\u0014\u0013\tQ\u0007N\u0001\u0005Vg\u0016\u0014h.Y7f\u0003QqW-\u001a3t\u0003\u000e\u001cw.\u001e8u\u0007J,\u0017\r^5p]R\u0011Q.\u001d\t\u0004\u0015Js\u0007C\u0001\u000fp\u0013\t\u0001XDA\u0004C_>dW-\u00198\t\u000b\u0015D\u0001\u0019\u00014\u0002!\u001d,g.\u001a:bi\u0016\u0004\u0016m]:x_J$W#\u0001;\u0011\u0005UdhB\u0001<{!\t9X$D\u0001y\u0015\tI\u0018$\u0001\u0004=e>|GOP\u0005\u0003wv\ta\u0001\u0015:fI\u00164\u0017BA?\u007f\u0005\u0019\u0019FO]5oO*\u001110H\u0001\u0011+N,'\u000f\u0015:pm&\u001c\u0018n\u001c8j]\u001e\u0004\"AO\u0006\u0014\u0005-YBCAA\u0001\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0002\u0016\u0004g\u000551FAA\b!\u0011\t\t\"a\u0007\u000e\u0005\u0005M!\u0002BA\u000b\u0003/\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005eQ$\u0001\u0006b]:|G/\u0019;j_:LA!!\b\u0002\u0014\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class UserProvisioning {
    private final UsersRepository usersRepository;
    private final MetricFactory metricFactory;
    private final JMAPConfiguration jmapConfiguration;

    public static JMAPConfiguration $lessinit$greater$default$3() {
        return UserProvisioning$.MODULE$.$lessinit$greater$default$3();
    }

    public SMono<BoxedUnit> provisionUser(MailboxSession session) {
        if (session != null && !this.usersRepository.isReadOnly() && this.jmapConfiguration.isUserProvisioningEnabled()) {
            return this.createAccountIfNeeded(session);
        }
        return SMono$.MODULE$.empty();
    }

    private SMono<BoxedUnit> createAccountIfNeeded(MailboxSession session) {
        return SMono$.MODULE$.apply(this.metricFactory.decoratePublisherWithTimerMetric("JMAP-RFC-8621-user-provisioning", (Publisher)this.needsAccountCreation(session.getUser()).filter((Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)b))).flatMap((Function1 & Serializable)x$1 -> this.createAccount(session.getUser())).onErrorResume((Function1 & Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof AlreadyExistInUsersRepositoryException) {
                return SMono$.MODULE$.empty();
            }
            return SMono$.MODULE$.error(throwable);
        })));
    }

    private SMono<BoxedUnit> createAccount(Username username) {
        return SMono$.MODULE$.fromCallable(() -> {
            this.usersRepository.addUser(username, this.generatePassword());
            return BoxedUnit.UNIT;
        }).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER);
    }

    private SMono<Object> needsAccountCreation(Username username) {
        return SMono$.MODULE$.apply(this.usersRepository.containsReactive(username)).map((Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)UserProvisioning.$anonfun$needsAccountCreation$1(b)));
    }

    private String generatePassword() {
        return UUID.randomUUID().toString();
    }

    public static final /* synthetic */ boolean $anonfun$needsAccountCreation$1(Boolean b) {
        return !Predef$.MODULE$.Boolean2boolean(b);
    }

    @Inject
    public UserProvisioning(UsersRepository usersRepository, MetricFactory metricFactory, JMAPConfiguration jmapConfiguration) {
        this.usersRepository = usersRepository;
        this.metricFactory = metricFactory;
        this.jmapConfiguration = jmapConfiguration;
    }
}

