/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.api.process;

import com.google.common.collect.ImmutableMap;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.MailboxType;
import org.apache.james.imap.api.process.MailboxTyper;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.model.MailboxPath;

public class DefaultMailboxTyper
implements MailboxTyper {
    private static final ImmutableMap<Role, MailboxType> ROLES_TO_MAILBOX_TYPE = ImmutableMap.of((Object)Role.INBOX, (Object)((Object)MailboxType.INBOX), (Object)Role.SENT, (Object)((Object)MailboxType.SENT), (Object)Role.ARCHIVE, (Object)((Object)MailboxType.ARCHIVE), (Object)Role.SPAM, (Object)((Object)MailboxType.SPAM), (Object)Role.DRAFTS, (Object)((Object)MailboxType.DRAFTS), (Object)Role.TRASH, (Object)((Object)MailboxType.TRASH));

    @Inject
    public DefaultMailboxTyper() {
    }

    @Override
    public MailboxType getMailboxType(ImapSession session, MailboxPath path) {
        return Role.from((String)path.getName()).flatMap(this::asMailboxType).orElse(MailboxType.OTHER);
    }

    private Optional<MailboxType> asMailboxType(Role role) {
        return Optional.ofNullable((MailboxType)((Object)ROLES_TO_MAILBOX_TYPE.get((Object)role)));
    }
}

