/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.SetQuotaRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import reactor.core.publisher.Mono;

public class SetQuotaProcessor
extends AbstractMailboxProcessor<SetQuotaRequest>
implements CapabilityImplementingProcessor {
    private static final List<Capability> CAPABILITIES = ImmutableList.of((Object)ImapConstants.SUPPORTS_QUOTA);

    @Inject
    public SetQuotaProcessor(MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(SetQuotaRequest.class, mailboxManager, factory, metricFactory);
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        return CAPABILITIES;
    }

    @Override
    protected Mono<Void> processRequestReactive(SetQuotaRequest request, ImapSession session, ImapProcessor.Responder responder) {
        return Mono.fromRunnable(() -> {
            Object[] params = new Object[]{"Full admin rights", request.getCommand().getName(), "Can not perform SETQUOTA commands"};
            HumanReadableText humanReadableText = new HumanReadableText("org.apache.james.imap.UNSUFFICIENT_RIGHTS", "You need the {0} right to perform command {1} on mailbox {2}.", params);
            this.no(request, responder, humanReadableText);
        });
    }

    @Override
    protected MDCBuilder mdc(SetQuotaRequest request) {
        return MDCBuilder.create().addToContext("action", "SET_QUOTA").addToContext("quotaRoot", request.getQuotaRoot()).addToContext("limits", request.getResourceLimits().toString());
    }
}

