/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cat;

import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.Bytes;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch.cat.CatRequestBase;
import org.opensearch.client.opensearch.cat.RecoveryResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

public class RecoveryRequest
extends CatRequestBase {
    @Nullable
    private final Boolean activeOnly;
    @Nullable
    private final Bytes bytes;
    @Nullable
    private final Boolean detailed;
    private final List<String> index;
    public static final Endpoint<RecoveryRequest, RecoveryResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<RecoveryRequest, RecoveryResponse>(request -> "GET", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.index())) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/recovery");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/recovery");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("format", "json");
        if (request.detailed != null) {
            params.put("detailed", String.valueOf(request.detailed));
        }
        if (request.activeOnly != null) {
            params.put("active_only", String.valueOf(request.activeOnly));
        }
        if (request.bytes != null) {
            params.put("bytes", request.bytes.jsonValue());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, RecoveryResponse._DESERIALIZER);

    private RecoveryRequest(Builder builder) {
        this.activeOnly = builder.activeOnly;
        this.bytes = builder.bytes;
        this.detailed = builder.detailed;
        this.index = ApiTypeHelper.unmodifiable(builder.index);
    }

    public static RecoveryRequest of(Function<Builder, ObjectBuilder<RecoveryRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean activeOnly() {
        return this.activeOnly;
    }

    @Nullable
    public final Bytes bytes() {
        return this.bytes;
    }

    @Nullable
    public final Boolean detailed() {
        return this.detailed;
    }

    public final List<String> index() {
        return this.index;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<RecoveryRequest> {
        @Nullable
        private Boolean activeOnly;
        @Nullable
        private Bytes bytes;
        @Nullable
        private Boolean detailed;
        @Nullable
        private List<String> index;

        public final Builder activeOnly(@Nullable Boolean value) {
            this.activeOnly = value;
            return this;
        }

        public final Builder bytes(@Nullable Bytes value) {
            this.bytes = value;
            return this;
        }

        public final Builder detailed(@Nullable Boolean value) {
            this.detailed = value;
            return this;
        }

        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        @Override
        public RecoveryRequest build() {
            this._checkSingleUse();
            return new RecoveryRequest(this);
        }
    }
}

