/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.cluster.stats.ClusterProcessCpu;
import org.opensearch.client.opensearch.cluster.stats.ClusterProcessOpenFileDescriptors;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class ClusterProcess
implements JsonpSerializable {
    private final ClusterProcessCpu cpu;
    private final ClusterProcessOpenFileDescriptors openFileDescriptors;
    public static final JsonpDeserializer<ClusterProcess> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterProcess::setupClusterProcessDeserializer);

    private ClusterProcess(Builder builder) {
        this.cpu = ApiTypeHelper.requireNonNull(builder.cpu, this, "cpu");
        this.openFileDescriptors = ApiTypeHelper.requireNonNull(builder.openFileDescriptors, this, "openFileDescriptors");
    }

    public static ClusterProcess of(Function<Builder, ObjectBuilder<ClusterProcess>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final ClusterProcessCpu cpu() {
        return this.cpu;
    }

    public final ClusterProcessOpenFileDescriptors openFileDescriptors() {
        return this.openFileDescriptors;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("cpu");
        this.cpu.serialize(generator, mapper);
        generator.writeKey("open_file_descriptors");
        this.openFileDescriptors.serialize(generator, mapper);
    }

    protected static void setupClusterProcessDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::cpu, ClusterProcessCpu._DESERIALIZER, "cpu");
        op.add(Builder::openFileDescriptors, ClusterProcessOpenFileDescriptors._DESERIALIZER, "open_file_descriptors");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ClusterProcess> {
        private ClusterProcessCpu cpu;
        private ClusterProcessOpenFileDescriptors openFileDescriptors;

        public final Builder cpu(ClusterProcessCpu value) {
            this.cpu = value;
            return this;
        }

        public final Builder cpu(Function<ClusterProcessCpu.Builder, ObjectBuilder<ClusterProcessCpu>> fn) {
            return this.cpu(fn.apply(new ClusterProcessCpu.Builder()).build());
        }

        public final Builder openFileDescriptors(ClusterProcessOpenFileDescriptors value) {
            this.openFileDescriptors = value;
            return this;
        }

        public final Builder openFileDescriptors(Function<ClusterProcessOpenFileDescriptors.Builder, ObjectBuilder<ClusterProcessOpenFileDescriptors>> fn) {
            return this.openFileDescriptors(fn.apply(new ClusterProcessOpenFileDescriptors.Builder()).build());
        }

        @Override
        public ClusterProcess build() {
            this._checkSingleUse();
            return new ClusterProcess(this);
        }
    }
}

