/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.UnionDeserializer;
import org.opensearch.client.opensearch.core.search.SourceFilter;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class SourceConfig
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<SourceConfig> _DESERIALIZER = JsonpDeserializer.lazy(SourceConfig::buildSourceConfigDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private SourceConfig(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private SourceConfig(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static SourceConfig of(Function<Builder, ObjectBuilder<SourceConfig>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isFilter() {
        return this._kind == Kind.Filter;
    }

    public SourceFilter filter() {
        return (SourceFilter)TaggedUnionUtils.get(this, Kind.Filter);
    }

    public boolean isFetch() {
        return this._kind == Kind.Fetch;
    }

    public Boolean fetch() {
        return (Boolean)TaggedUnionUtils.get(this, Kind.Fetch);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case Fetch: {
                    generator.write(((Boolean)this._value).booleanValue());
                }
            }
        }
    }

    private static JsonpDeserializer<SourceConfig> buildSourceConfigDeserializer() {
        return new UnionDeserializer.Builder<SourceConfig, Kind, Object>(SourceConfig::new, false).addMember(Kind.Filter, SourceFilter._DESERIALIZER).addMember(Kind.Fetch, JsonpDeserializer.booleanDeserializer()).build();
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<SourceConfig> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<SourceConfig> filter(SourceFilter v) {
            this._kind = Kind.Filter;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SourceConfig> filter(Function<SourceFilter.Builder, ObjectBuilder<SourceFilter>> fn) {
            return this.filter(fn.apply(new SourceFilter.Builder()).build());
        }

        public ObjectBuilder<SourceConfig> fetch(Boolean v) {
            this._kind = Kind.Fetch;
            this._value = v;
            return this;
        }

        @Override
        public SourceConfig build() {
            this._checkSingleUse();
            return new SourceConfig(this);
        }
    }

    public static enum Kind {
        Filter,
        Fetch;

    }
}

