/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.policies;

import org.apache.james.jspf.core.DNSLookupContinuation;
import org.apache.james.jspf.core.SPF1Record;
import org.apache.james.jspf.core.SPFChecker;
import org.apache.james.jspf.core.SPFSession;
import org.apache.james.jspf.core.exceptions.NeutralException;
import org.apache.james.jspf.core.exceptions.NoneException;
import org.apache.james.jspf.core.exceptions.PermErrorException;
import org.apache.james.jspf.core.exceptions.TempErrorException;
import org.xbill.DNS.Name;
import org.xbill.DNS.TextParseException;

public final class InitialChecksPolicy
implements SPFChecker {
    @Override
    public DNSLookupContinuation checkSPF(SPFSession spfData) throws PermErrorException, TempErrorException, NeutralException, NoneException {
        SPF1Record res = (SPF1Record)spfData.getAttribute("SPF.SPF1Record");
        if (res == null) {
            String currentDomain = spfData.getCurrentDomain();
            if (currentDomain != null) {
                String[] labels = currentDomain.split("\\.");
                for (int i = 0; i < labels.length; ++i) {
                    if (labels[i] == null || labels[i].length() <= 63) continue;
                    throw new NoneException("Domain " + currentDomain + " is malformed (label longer than 63 characters)");
                }
            }
            if (spfData.getSenderDomain().indexOf(46) < 0) {
                throw new NoneException("Sender domain " + spfData.getSenderDomain() + " is not an FQDN.");
            }
            try {
                Name.fromString((String)spfData.getSenderDomain());
            }
            catch (TextParseException e) {
                throw new NoneException("Invalid sender domain: " + e.getMessage());
            }
        }
        return null;
    }
}

