/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.Objects;

public class PackageName {
    static final char PART_SEPARATOR = '.';
    private final String name;

    public static PackageName of(String value) {
        Preconditions.checkNotNull((Object)value);
        String sanitizedValue = PackageName.sanitize(value);
        Preconditions.checkArgument((!PackageName.hasEmptyParts(sanitizedValue) ? 1 : 0) != 0, (Object)("PackageName can not contain empty parts: " + sanitizedValue));
        return new PackageName(sanitizedValue);
    }

    private static boolean hasEmptyParts(String sanitizedValue) {
        return Splitter.on((char)'.').splitToStream((CharSequence)sanitizedValue).anyMatch(String::isEmpty);
    }

    private static String sanitize(String value) {
        if (value.endsWith(String.valueOf('.'))) {
            return value.substring(0, value.length() - 1);
        }
        return value;
    }

    private PackageName(String name) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"Name should not be empty");
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public final boolean equals(Object o) {
        if (o instanceof PackageName) {
            PackageName className = (PackageName)o;
            return Objects.equals(this.name, className.name);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.name);
    }
}

