/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.remote.delivery;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.transport.mailets.remote.delivery.DelaysAndMaxRetry;
import org.apache.james.transport.mailets.remote.delivery.HeloNameProvider;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.ProcessingState;
import org.apache.mailet.base.MailetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteDeliveryConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteDeliveryConfiguration.class);
    public static final String USE_PRIORITY = "usePriority";
    public static final String MAX_DNS_PROBLEM_RETRIES = "maxDnsProblemRetries";
    public static final String HELO_NAME = "heloName";
    public static final String JAVAX_PREFIX = "mail.";
    public static final String BIND = "bind";
    public static final String GATEWAY_PASSWORD = "gatewayPassword";
    public static final String GATEWAY_USERNAME_COMPATIBILITY = "gatewayusername";
    public static final String GATEWAY_USERNAME = "gatewayUsername";
    public static final String GATEWAY_PORT = "gatewayPort";
    public static final String GATEWAY = "gateway";
    public static final String SSL_ENABLE = "sslEnable";
    public static final String START_TLS = "startTLS";
    public static final String VERIFY_SERVER_IDENTITY = "verifyServerIdentity";
    public static final String BOUNCE_PROCESSOR = "bounceProcessor";
    public static final String SENDPARTIAL = "sendpartial";
    public static final String TIMEOUT = "timeout";
    public static final String CONNECTIONTIMEOUT = "connectiontimeout";
    public static final String OUTGOING = "outgoing";
    public static final String MAX_RETRIES = "maxRetries";
    public static final String DELAY_TIME = "delayTime";
    public static final String DEBUG = "debug";
    public static final String ON_SUCCESS = "onSuccess";
    public static final String LOAD_BALANCING = "loadBalancing";
    public static final int DEFAULT_SMTP_TIMEOUT = 180000;
    public static final MailQueueName DEFAULT_OUTGOING_QUEUE_NAME = MailQueueName.of((String)"outgoing");
    public static final int DEFAULT_CONNECTION_TIMEOUT = 60000;
    public static final int DEFAULT_DNS_RETRY_PROBLEM = 0;
    public static final int DEFAULT_MAX_RETRY = 5;
    public static final String ADDRESS_PORT_SEPARATOR = ":";
    private final boolean isDebug;
    private final boolean usePriority;
    private final boolean startTLS;
    private final boolean isSSLEnable;
    private final boolean verifyServerIdentity;
    private final boolean isBindUsed;
    private final boolean sendPartial;
    private final boolean loadBalancing;
    private final int maxRetries;
    private final long smtpTimeout;
    private final int dnsProblemRetry;
    private final int connectionTimeout;
    private final List<Duration> delayTimes;
    private final HeloNameProvider heloNameProvider;
    private final MailQueueName outGoingQueueName;
    private final String bindAddress;
    private final Optional<ProcessingState> bounceProcessor;
    private final Collection<String> gatewayServer;
    private final String authUser;
    private final String authPass;
    private final Properties javaxAdditionalProperties;
    private final Optional<ProcessingState> onSuccess;

    public RemoteDeliveryConfiguration(MailetConfig mailetConfig, DomainList domainList) {
        this.isDebug = MailetUtil.getInitParameter((MailetConfig)mailetConfig, (String)DEBUG).orElse(false);
        this.startTLS = MailetUtil.getInitParameter((MailetConfig)mailetConfig, (String)START_TLS).orElse(false);
        this.isSSLEnable = MailetUtil.getInitParameter((MailetConfig)mailetConfig, (String)SSL_ENABLE).orElse(false);
        this.verifyServerIdentity = MailetUtil.getInitParameter((MailetConfig)mailetConfig, (String)VERIFY_SERVER_IDENTITY).orElse(true);
        this.usePriority = MailetUtil.getInitParameter((MailetConfig)mailetConfig, (String)USE_PRIORITY).orElse(false);
        this.sendPartial = MailetUtil.getInitParameter((MailetConfig)mailetConfig, (String)SENDPARTIAL).orElse(false);
        this.loadBalancing = MailetUtil.getInitParameter((MailetConfig)mailetConfig, (String)LOAD_BALANCING).orElse(true);
        this.outGoingQueueName = Optional.ofNullable(mailetConfig.getInitParameter(OUTGOING)).map(MailQueueName::of).orElse(DEFAULT_OUTGOING_QUEUE_NAME);
        this.bounceProcessor = Optional.ofNullable(mailetConfig.getInitParameter(BOUNCE_PROCESSOR)).map(ProcessingState::new);
        this.bindAddress = mailetConfig.getInitParameter(BIND);
        DelaysAndMaxRetry delaysAndMaxRetry = this.computeDelaysAndMaxRetry(mailetConfig);
        this.maxRetries = delaysAndMaxRetry.getMaxRetries();
        this.delayTimes = delaysAndMaxRetry.getExpandedDelays();
        this.smtpTimeout = this.computeSmtpTimeout(mailetConfig);
        this.connectionTimeout = this.computeConnectionTimeout(mailetConfig);
        this.dnsProblemRetry = this.computeDnsProblemRetry(mailetConfig);
        this.heloNameProvider = new HeloNameProvider(mailetConfig.getInitParameter(HELO_NAME), domainList);
        String gatewayPort = mailetConfig.getInitParameter(GATEWAY_PORT);
        String gateway = mailetConfig.getInitParameter(GATEWAY);
        this.gatewayServer = this.computeGatewayServers(gatewayPort, gateway);
        if (gateway != null) {
            this.authUser = this.computeGatewayUser(mailetConfig);
            this.authPass = mailetConfig.getInitParameter(GATEWAY_PASSWORD);
        } else {
            this.authUser = null;
            this.authPass = null;
        }
        this.isBindUsed = this.bindAddress != null;
        this.javaxAdditionalProperties = this.computeJavaxProperties(mailetConfig);
        this.onSuccess = Optional.ofNullable(mailetConfig.getInitParameter(ON_SUCCESS)).map(ProcessingState::new);
    }

    private Properties computeJavaxProperties(MailetConfig mailetConfig) {
        Properties result = new Properties();
        result.putAll((Map<?, ?>)((Map)ImmutableList.copyOf((Iterator)mailetConfig.getInitParameterNames()).stream().filter(propertyName -> propertyName.startsWith(JAVAX_PREFIX)).map(propertyName -> Pair.of((Object)propertyName, (Object)mailetConfig.getInitParameter(propertyName))).collect(ImmutableMap.toImmutableMap(Pair::getKey, Pair::getValue))));
        return result;
    }

    private int computeDnsProblemRetry(MailetConfig mailetConfig) {
        String dnsRetry = mailetConfig.getInitParameter(MAX_DNS_PROBLEM_RETRIES);
        if (!Strings.isNullOrEmpty((String)dnsRetry)) {
            return Integer.parseInt(dnsRetry);
        }
        return 0;
    }

    private int computeConnectionTimeout(MailetConfig mailetConfig) {
        try {
            return Integer.parseInt(Optional.ofNullable(mailetConfig.getInitParameter(CONNECTIONTIMEOUT)).orElse(String.valueOf(60000)));
        }
        catch (Exception e) {
            LOGGER.warn("Invalid timeout setting: {}", (Object)mailetConfig.getInitParameter(TIMEOUT));
            return 60000;
        }
    }

    private long computeSmtpTimeout(MailetConfig mailetConfig) {
        try {
            if (mailetConfig.getInitParameter(TIMEOUT) != null) {
                return Integer.parseInt(mailetConfig.getInitParameter(TIMEOUT));
            }
            return 180000L;
        }
        catch (Exception e) {
            LOGGER.warn("Invalid timeout setting: {}", (Object)mailetConfig.getInitParameter(TIMEOUT));
            return 180000L;
        }
    }

    private DelaysAndMaxRetry computeDelaysAndMaxRetry(MailetConfig mailetConfig) {
        try {
            int intendedMaxRetries = Integer.parseInt(Optional.ofNullable(mailetConfig.getInitParameter(MAX_RETRIES)).orElse(String.valueOf(5)));
            return DelaysAndMaxRetry.from(intendedMaxRetries, mailetConfig.getInitParameter(DELAY_TIME));
        }
        catch (Exception e) {
            LOGGER.warn("Invalid maxRetries setting: {}", (Object)mailetConfig.getInitParameter(MAX_RETRIES));
            return DelaysAndMaxRetry.defaults();
        }
    }

    private String computeGatewayUser(MailetConfig mailetConfig) {
        String user = mailetConfig.getInitParameter(GATEWAY_USERNAME);
        if (user == null) {
            return mailetConfig.getInitParameter(GATEWAY_USERNAME_COMPATIBILITY);
        }
        return user;
    }

    private List<String> computeGatewayServers(String gatewayPort, String gateway) {
        if (gateway != null && !gateway.isBlank()) {
            ImmutableList.Builder builder = ImmutableList.builder();
            Iterable gatewayParts = Splitter.on((char)',').split((CharSequence)gateway);
            for (String gatewayPart : gatewayParts) {
                builder.add((Object)this.parsePart(gatewayPort, gatewayPart));
            }
            return builder.build();
        }
        return ImmutableList.of();
    }

    private String parsePart(String gatewayPort, String gatewayPart) {
        String address = gatewayPart.trim();
        if (!address.contains(ADDRESS_PORT_SEPARATOR) && gatewayPort != null) {
            return address + ADDRESS_PORT_SEPARATOR + gatewayPort;
        }
        return address;
    }

    public Properties createFinalJavaxProperties() {
        Properties props = this.createFinalJavaxProperties("smtp");
        props.put("mail.smtp.ssl.enable", "false");
        return props;
    }

    public Properties createFinalJavaxPropertiesWithSSL() {
        Properties props = this.createFinalJavaxProperties("smtps");
        props.put("mail.smtps.ssl.enable", "true");
        return props;
    }

    private Properties createFinalJavaxProperties(String protocol) {
        Properties props = new Properties();
        props.put("mail.debug", "false");
        props.put(JAVAX_PREFIX + protocol + ".ehlo", "true");
        props.put(JAVAX_PREFIX + protocol + ".timeout", String.valueOf(this.smtpTimeout));
        props.put(JAVAX_PREFIX + protocol + ".connectiontimeout", String.valueOf(this.connectionTimeout));
        props.put(JAVAX_PREFIX + protocol + ".sendpartial", String.valueOf(this.sendPartial));
        props.put(JAVAX_PREFIX + protocol + ".localhost", this.heloNameProvider.getHeloName());
        props.put(JAVAX_PREFIX + protocol + ".starttls.enable", String.valueOf(this.startTLS));
        props.put(JAVAX_PREFIX + protocol + ".ssl.checkserveridentity", String.valueOf(this.verifyServerIdentity));
        if (this.isBindUsed()) {
            props.put(JAVAX_PREFIX + protocol + ".localaddress", this.bindAddress);
        }
        if (this.authUser != null) {
            props.put(JAVAX_PREFIX + protocol + ".auth", "true");
        }
        props.putAll((Map<?, ?>)this.javaxAdditionalProperties);
        return props;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public List<Duration> getDelayTimes() {
        return this.delayTimes;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public long getSmtpTimeout() {
        return this.smtpTimeout;
    }

    public boolean isSendPartial() {
        return this.sendPartial;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Collection<String> getGatewayServer() {
        return this.gatewayServer;
    }

    public String getAuthUser() {
        return this.authUser;
    }

    public String getAuthPass() {
        return this.authPass;
    }

    public boolean isBindUsed() {
        return this.isBindUsed;
    }

    public Optional<ProcessingState> getBounceProcessor() {
        return this.bounceProcessor;
    }

    public boolean isUsePriority() {
        return this.usePriority;
    }

    public boolean isStartTLS() {
        return this.startTLS;
    }

    public boolean isSSLEnable() {
        return this.isSSLEnable;
    }

    public boolean isVerifyServerIdentity() {
        return this.verifyServerIdentity;
    }

    public boolean isConnectByHostname() {
        return (this.isSSLEnable() || this.isStartTLS()) && this.isVerifyServerIdentity();
    }

    public HeloNameProvider getHeloNameProvider() {
        return this.heloNameProvider;
    }

    public MailQueueName getOutGoingQueueName() {
        return this.outGoingQueueName;
    }

    public Properties getJavaxAdditionalProperties() {
        return this.javaxAdditionalProperties;
    }

    public int getDnsProblemRetry() {
        return this.dnsProblemRetry;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public Optional<ProcessingState> getOnSuccess() {
        return this.onSuccess;
    }

    public boolean isLoadBalancing() {
        return this.loadBalancing;
    }
}

